/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassFile;
import org.glavo.classfile.CodeBuilder;
import org.glavo.classfile.CodeElement;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.CustomAttribute;
import org.glavo.classfile.Label;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.attribute.CharacterRangeTableAttribute;
import org.glavo.classfile.attribute.CodeAttribute;
import org.glavo.classfile.attribute.LineNumberTableAttribute;
import org.glavo.classfile.attribute.LocalVariableTableAttribute;
import org.glavo.classfile.attribute.LocalVariableTypeTableAttribute;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.impl.AbstractDirectBuilder;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.AbstractPseudoInstruction;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.BufferedCodeBuilder;
import org.glavo.classfile.impl.BytecodeHelpers;
import org.glavo.classfile.impl.ClassFileImpl;
import org.glavo.classfile.impl.CodeImpl;
import org.glavo.classfile.impl.LabelContext;
import org.glavo.classfile.impl.LabelImpl;
import org.glavo.classfile.impl.MethodInfo;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.StackCounter;
import org.glavo.classfile.impl.StackMapGenerator;
import org.glavo.classfile.impl.TerminalCodeBuilder;
import org.glavo.classfile.impl.UnboundAttribute;
import org.glavo.classfile.impl.Util;
import org.glavo.classfile.instruction.CharacterRange;
import org.glavo.classfile.instruction.ExceptionCatch;
import org.glavo.classfile.instruction.LocalVariable;
import org.glavo.classfile.instruction.LocalVariableType;
import org.glavo.classfile.instruction.SwitchCase;

public final class DirectCodeBuilder
extends AbstractDirectBuilder<CodeModel>
implements TerminalCodeBuilder,
LabelContext {
    private final List<CharacterRange> characterRanges = new ArrayList<CharacterRange>();
    final List<AbstractPseudoInstruction.ExceptionCatchImpl> handlers = new ArrayList<AbstractPseudoInstruction.ExceptionCatchImpl>();
    private final List<LocalVariable> localVariables = new ArrayList<LocalVariable>();
    private final List<LocalVariableType> localVariableTypes = new ArrayList<LocalVariableType>();
    private final boolean transformFwdJumps;
    private final boolean transformBackJumps;
    private final Label startLabel;
    private final Label endLabel;
    final MethodInfo methodInfo;
    final BufWriter bytecodesBufWriter;
    private CodeAttribute mruParent;
    private int[] mruParentTable;
    private Map<CodeAttribute, int[]> parentMap;
    private DedupLineNumberTableAttribute lineNumberWriter;
    private int topLocal;
    List<DeferredLabel> deferredLabels;
    private Attribute<CodeAttribute> content = null;

    public static Attribute<CodeAttribute> build(MethodInfo methodInfo, Consumer<? super CodeBuilder> handler, SplitConstantPool constantPool, ClassFileImpl context, CodeModel original) {
        DirectCodeBuilder cb;
        try {
            cb = new DirectCodeBuilder(methodInfo, constantPool, context, original, false);
            handler.accept(cb);
            cb.buildContent();
        }
        catch (LabelOverflowException loe) {
            if (context.shortJumpsOption() == ClassFile.ShortJumpsOption.FIX_SHORT_JUMPS) {
                cb = new DirectCodeBuilder(methodInfo, constantPool, context, original, true);
                handler.accept(cb);
                cb.buildContent();
            }
            throw loe;
        }
        return cb.content;
    }

    private DirectCodeBuilder(MethodInfo methodInfo, SplitConstantPool constantPool, ClassFileImpl context, CodeModel original, boolean transformFwdJumps) {
        super(constantPool, context);
        BufWriterImpl bufWriterImpl;
        this.setOriginal(original);
        this.methodInfo = methodInfo;
        this.transformFwdJumps = transformFwdJumps;
        boolean bl = this.transformBackJumps = context.shortJumpsOption() == ClassFile.ShortJumpsOption.FIX_SHORT_JUMPS;
        if (original instanceof CodeImpl) {
            CodeImpl cai = (CodeImpl)original;
            bufWriterImpl = new BufWriterImpl(constantPool, context, cai.codeLength());
        } else {
            bufWriterImpl = new BufWriterImpl(constantPool, context);
        }
        this.bytecodesBufWriter = bufWriterImpl;
        this.startLabel = new LabelImpl(this, 0);
        this.endLabel = new LabelImpl(this, -1);
        this.topLocal = Util.maxLocals(methodInfo.methodFlags(), methodInfo.methodTypeSymbol());
        if (original != null) {
            this.topLocal = Math.max(this.topLocal, original.maxLocals());
        }
    }

    @Override
    public CodeBuilder with(CodeElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)element);
        }
        return this;
    }

    @Override
    public Label newLabel() {
        return new LabelImpl(this, -1);
    }

    @Override
    public Label startLabel() {
        return this.startLabel;
    }

    @Override
    public Label endLabel() {
        return this.endLabel;
    }

    @Override
    public int receiverSlot() {
        return this.methodInfo.receiverSlot();
    }

    @Override
    public int parameterSlot(int paramNo) {
        return this.methodInfo.parameterSlot(paramNo);
    }

    public int curTopLocal() {
        return this.topLocal;
    }

    @Override
    public int allocateLocal(TypeKind typeKind) {
        int retVal = this.topLocal;
        this.topLocal += typeKind.slotSize();
        return retVal;
    }

    public int curPc() {
        return this.bytecodesBufWriter.size();
    }

    public MethodInfo methodInfo() {
        return this.methodInfo;
    }

    private void writeExceptionHandlers(BufWriter buf) {
        int pos = buf.size();
        int handlersSize = this.handlers.size();
        buf.writeU2(handlersSize);
        for (AbstractPseudoInstruction.ExceptionCatchImpl h : this.handlers) {
            int startPc = this.labelToBci(h.tryStart());
            int endPc = this.labelToBci(h.tryEnd());
            int handlerPc = this.labelToBci(h.handler());
            if (startPc == -1 || endPc == -1 || handlerPc == -1) {
                if (this.context.deadLabelsOption() == ClassFile.DeadLabelsOption.DROP_DEAD_LABELS) {
                    --handlersSize;
                    continue;
                }
                throw new IllegalArgumentException("Unbound label in exception handler");
            }
            buf.writeU2(startPc);
            buf.writeU2(endPc);
            buf.writeU2(handlerPc);
            buf.writeIndexOrZero(h.catchTypeEntry());
            ++handlersSize;
        }
        if (handlersSize < this.handlers.size()) {
            buf.patchInt(pos, 2, handlersSize);
        }
    }

    private void buildContent() {
        if (this.content != null) {
            return;
        }
        this.setLabelTarget(this.endLabel);
        this.processDeferredLabels();
        if (this.context.debugElementsOption() == ClassFile.DebugElementsOption.PASS_DEBUG) {
            UnboundAttribute.AdHocAttribute<Attribute<CharacterRangeTableAttribute>> a;
            if (!this.characterRanges.isEmpty()) {
                a = new UnboundAttribute.AdHocAttribute<CharacterRangeTableAttribute>(Attributes.CHARACTER_RANGE_TABLE){

                    @Override
                    public void writeBody(BufWriter b) {
                        int pos = b.size();
                        int crSize = DirectCodeBuilder.this.characterRanges.size();
                        b.writeU2(crSize);
                        for (CharacterRange cr : DirectCodeBuilder.this.characterRanges) {
                            int start = DirectCodeBuilder.this.labelToBci(cr.startScope());
                            int end = DirectCodeBuilder.this.labelToBci(cr.endScope());
                            if (start == -1 || end == -1) {
                                if (DirectCodeBuilder.this.context.deadLabelsOption() == ClassFile.DeadLabelsOption.DROP_DEAD_LABELS) {
                                    --crSize;
                                    continue;
                                }
                                throw new IllegalArgumentException("Unbound label in character range");
                            }
                            b.writeU2(start);
                            b.writeU2(end - 1);
                            b.writeInt(cr.characterRangeStart());
                            b.writeInt(cr.characterRangeEnd());
                            b.writeU2(cr.flags());
                        }
                        if (crSize < DirectCodeBuilder.this.characterRanges.size()) {
                            b.patchInt(pos, 2, crSize);
                        }
                    }
                };
                this.attributes.withAttribute(a);
            }
            if (!this.localVariables.isEmpty()) {
                a = new UnboundAttribute.AdHocAttribute<LocalVariableTableAttribute>(Attributes.LOCAL_VARIABLE_TABLE){

                    @Override
                    public void writeBody(BufWriter b) {
                        int pos = b.size();
                        int lvSize = DirectCodeBuilder.this.localVariables.size();
                        b.writeU2(lvSize);
                        for (LocalVariable l : DirectCodeBuilder.this.localVariables) {
                            if (l.writeTo(b)) continue;
                            if (DirectCodeBuilder.this.context.deadLabelsOption() == ClassFile.DeadLabelsOption.DROP_DEAD_LABELS) {
                                --lvSize;
                                continue;
                            }
                            throw new IllegalArgumentException("Unbound label in local variable type");
                        }
                        if (lvSize < DirectCodeBuilder.this.localVariables.size()) {
                            b.patchInt(pos, 2, lvSize);
                        }
                    }
                };
                this.attributes.withAttribute(a);
            }
            if (!this.localVariableTypes.isEmpty()) {
                a = new UnboundAttribute.AdHocAttribute<LocalVariableTypeTableAttribute>(Attributes.LOCAL_VARIABLE_TYPE_TABLE){

                    @Override
                    public void writeBody(BufWriter b) {
                        int pos = b.size();
                        int lvtSize = DirectCodeBuilder.this.localVariableTypes.size();
                        b.writeU2(DirectCodeBuilder.this.localVariableTypes.size());
                        for (LocalVariableType l : DirectCodeBuilder.this.localVariableTypes) {
                            if (l.writeTo(b)) continue;
                            if (DirectCodeBuilder.this.context.deadLabelsOption() == ClassFile.DeadLabelsOption.DROP_DEAD_LABELS) {
                                --lvtSize;
                                continue;
                            }
                            throw new IllegalArgumentException("Unbound label in local variable type");
                        }
                        if (lvtSize < DirectCodeBuilder.this.localVariableTypes.size()) {
                            b.patchInt(pos, 2, lvtSize);
                        }
                    }
                };
                this.attributes.withAttribute(a);
            }
        }
        if (this.lineNumberWriter != null) {
            this.attributes.withAttribute(this.lineNumberWriter);
        }
        this.content = new UnboundAttribute.AdHocAttribute<CodeAttribute>(Attributes.CODE){

            private void writeCounters(boolean codeMatch, BufWriterImpl buf) {
                if (codeMatch) {
                    buf.writeU2(((CodeModel)DirectCodeBuilder.this.original).maxStack());
                    buf.writeU2(((CodeModel)DirectCodeBuilder.this.original).maxLocals());
                } else {
                    StackCounter cntr = StackCounter.of(DirectCodeBuilder.this, buf);
                    buf.writeU2(cntr.maxStack());
                    buf.writeU2(cntr.maxLocals());
                }
            }

            private void generateStackMaps(BufWriterImpl buf) throws IllegalArgumentException {
                StackMapGenerator gen = StackMapGenerator.of(DirectCodeBuilder.this, buf);
                DirectCodeBuilder.this.attributes.withAttribute(gen.stackMapTableAttribute());
                buf.writeU2(gen.maxStack());
                buf.writeU2(gen.maxLocals());
            }

            private void tryGenerateStackMaps(boolean codeMatch, BufWriterImpl buf) {
                if (buf.getMajorVersion() >= 50) {
                    try {
                        this.generateStackMaps(buf);
                    }
                    catch (IllegalArgumentException e) {
                        if (buf.getMajorVersion() == 50) {
                            this.writeCounters(codeMatch, buf);
                        }
                        throw e;
                    }
                } else {
                    this.writeCounters(codeMatch, buf);
                }
            }

            @Override
            public void writeBody(BufWriter b) {
                BufWriterImpl buf = (BufWriterImpl)b;
                buf.setLabelContext(DirectCodeBuilder.this);
                int codeLength = DirectCodeBuilder.this.curPc();
                if (codeLength == 0 || codeLength >= 65536) {
                    throw new IllegalArgumentException(String.format("Code length %d is outside the allowed range in %s%s", codeLength, DirectCodeBuilder.this.methodInfo.methodName().stringValue(), DirectCodeBuilder.this.methodInfo.methodTypeSymbol().displayDescriptor()));
                }
                if (DirectCodeBuilder.this.codeAndExceptionsMatch(codeLength)) {
                    switch (DirectCodeBuilder.this.context.stackMapsOption()) {
                        case STACK_MAPS_WHEN_REQUIRED: {
                            DirectCodeBuilder.this.attributes.withAttribute(((CodeModel)DirectCodeBuilder.this.original).findAttribute(Attributes.STACK_MAP_TABLE).orElse(null));
                            this.writeCounters(true, buf);
                            break;
                        }
                        case GENERATE_STACK_MAPS: {
                            this.generateStackMaps(buf);
                            break;
                        }
                        case DROP_STACK_MAPS: {
                            this.writeCounters(true, buf);
                        }
                    }
                } else {
                    switch (DirectCodeBuilder.this.context.stackMapsOption()) {
                        case STACK_MAPS_WHEN_REQUIRED: {
                            this.tryGenerateStackMaps(false, buf);
                            break;
                        }
                        case GENERATE_STACK_MAPS: {
                            this.generateStackMaps(buf);
                            break;
                        }
                        case DROP_STACK_MAPS: {
                            this.writeCounters(false, buf);
                        }
                    }
                }
                buf.writeInt(codeLength);
                buf.writeBytes(DirectCodeBuilder.this.bytecodesBufWriter);
                DirectCodeBuilder.this.writeExceptionHandlers(b);
                DirectCodeBuilder.this.attributes.writeTo(b);
                buf.setLabelContext(null);
            }
        };
    }

    private boolean codeAndExceptionsMatch(int codeLength) {
        boolean codeAttributesMatch;
        CodeImpl cai;
        Object object = this.original;
        if (object instanceof CodeImpl && this.canWriteDirect((cai = (CodeImpl)object).constantPool())) {
            boolean bl = codeAttributesMatch = cai.codeLength == this.curPc() && cai.compareCodeBytes(this.bytecodesBufWriter, 0, codeLength);
            if (codeAttributesMatch) {
                BufWriterImpl bw = new BufWriterImpl(this.constantPool, this.context);
                this.writeExceptionHandlers(bw);
                codeAttributesMatch = cai.classReader.compare(bw, 0, cai.exceptionHandlerPos, bw.size());
            }
        } else {
            codeAttributesMatch = false;
        }
        return codeAttributesMatch;
    }

    private void writeLabelOffset(int nBytes, int instructionPc, Label label) {
        int targetBci = this.labelToBci(label);
        if (targetBci == -1) {
            int pc = this.curPc();
            this.bytecodesBufWriter.writeIntBytes(nBytes, 0L);
            if (this.deferredLabels == null) {
                this.deferredLabels = new ArrayList<DeferredLabel>();
            }
            this.deferredLabels.add(new DeferredLabel(pc, nBytes, instructionPc, label));
        } else {
            int branchOffset = targetBci - instructionPc;
            if (nBytes == 2 && (short)branchOffset != branchOffset) {
                throw new LabelOverflowException();
            }
            this.bytecodesBufWriter.writeIntBytes(nBytes, branchOffset);
        }
    }

    private void processDeferredLabels() {
        if (this.deferredLabels != null) {
            for (DeferredLabel dl : this.deferredLabels) {
                int branchOffset = this.labelToBci(dl.label) - dl.instructionPc;
                if (dl.size == 2 && (short)branchOffset != branchOffset) {
                    throw new LabelOverflowException();
                }
                this.bytecodesBufWriter.patchInt(dl.labelPc, dl.size, branchOffset);
            }
        }
    }

    public void writeBytecode(Opcode opcode) {
        if (opcode.isWide()) {
            this.bytecodesBufWriter.writeU1(196);
        }
        this.bytecodesBufWriter.writeU1(opcode.bytecode() & 0xFF);
    }

    public void writeLocalVar(Opcode opcode, int localVar) {
        this.writeBytecode(opcode);
        switch (opcode.sizeIfFixed()) {
            case 1: {
                break;
            }
            case 2: {
                this.bytecodesBufWriter.writeU1(localVar);
                break;
            }
            case 4: {
                this.bytecodesBufWriter.writeU2(localVar);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected instruction size: " + opcode);
            }
        }
    }

    public void writeIncrement(int slot, int val) {
        Opcode opcode = slot < 256 && val < 128 && val > -127 ? Opcode.IINC : Opcode.IINC_W;
        this.writeBytecode(opcode);
        if (opcode.isWide()) {
            this.bytecodesBufWriter.writeU2(slot);
            this.bytecodesBufWriter.writeU2(val);
        } else {
            this.bytecodesBufWriter.writeU1(slot);
            this.bytecodesBufWriter.writeU1(val);
        }
    }

    public void writeBranch(Opcode op, Label target) {
        int instructionPc = this.curPc();
        int targetBci = this.labelToBci(target);
        if (op.sizeIfFixed() == 3 && (targetBci == -1 ? this.transformFwdJumps : this.transformBackJumps && targetBci - instructionPc < Short.MIN_VALUE)) {
            if (op == Opcode.GOTO) {
                this.writeBytecode(Opcode.GOTO_W);
                this.writeLabelOffset(4, instructionPc, target);
            } else if (op == Opcode.JSR) {
                this.writeBytecode(Opcode.JSR_W);
                this.writeLabelOffset(4, instructionPc, target);
            } else {
                this.writeBytecode(BytecodeHelpers.reverseBranchOpcode(op));
                Label bypassJump = this.newLabel();
                this.writeLabelOffset(2, instructionPc, bypassJump);
                this.writeBytecode(Opcode.GOTO_W);
                this.writeLabelOffset(4, instructionPc + 3, target);
                this.labelBinding(bypassJump);
            }
        } else {
            this.writeBytecode(op);
            this.writeLabelOffset(op.sizeIfFixed() == 3 ? 2 : 4, instructionPc, target);
        }
    }

    public void writeLookupSwitch(Label defaultTarget, List<SwitchCase> cases) {
        int instructionPc = this.curPc();
        this.writeBytecode(Opcode.LOOKUPSWITCH);
        int pad = 4 - this.curPc() % 4;
        if (pad != 4) {
            this.bytecodesBufWriter.writeIntBytes(pad, 0L);
        }
        this.writeLabelOffset(4, instructionPc, defaultTarget);
        this.bytecodesBufWriter.writeInt(cases.size());
        cases = new ArrayList<SwitchCase>(cases);
        cases.sort(new Comparator<SwitchCase>(){

            @Override
            public int compare(SwitchCase c1, SwitchCase c2) {
                return Integer.compare(c1.caseValue(), c2.caseValue());
            }
        });
        for (SwitchCase c : cases) {
            this.bytecodesBufWriter.writeInt(c.caseValue());
            this.writeLabelOffset(4, instructionPc, c.target());
        }
    }

    public void writeTableSwitch(int low, int high, Label defaultTarget, List<SwitchCase> cases) {
        int instructionPc = this.curPc();
        this.writeBytecode(Opcode.TABLESWITCH);
        int pad = 4 - this.curPc() % 4;
        if (pad != 4) {
            this.bytecodesBufWriter.writeIntBytes(pad, 0L);
        }
        this.writeLabelOffset(4, instructionPc, defaultTarget);
        this.bytecodesBufWriter.writeInt(low);
        this.bytecodesBufWriter.writeInt(high);
        HashMap<Integer, Label> caseMap = new HashMap<Integer, Label>(cases.size());
        for (SwitchCase c : cases) {
            caseMap.put(c.caseValue(), c.target());
        }
        for (long l = (long)low; l <= (long)high; ++l) {
            this.writeLabelOffset(4, instructionPc, caseMap.getOrDefault((int)l, defaultTarget));
        }
    }

    public void writeFieldAccess(Opcode opcode, FieldRefEntry ref) {
        this.writeBytecode(opcode);
        this.bytecodesBufWriter.writeIndex(ref);
    }

    public void writeInvokeNormal(Opcode opcode, MemberRefEntry ref) {
        this.writeBytecode(opcode);
        this.bytecodesBufWriter.writeIndex(ref);
    }

    public void writeInvokeInterface(Opcode opcode, InterfaceMethodRefEntry ref, int count) {
        this.writeBytecode(opcode);
        this.bytecodesBufWriter.writeIndex(ref);
        this.bytecodesBufWriter.writeU1(count);
        this.bytecodesBufWriter.writeU1(0);
    }

    public void writeInvokeDynamic(InvokeDynamicEntry ref) {
        this.writeBytecode(Opcode.INVOKEDYNAMIC);
        this.bytecodesBufWriter.writeIndex(ref);
        this.bytecodesBufWriter.writeU2(0);
    }

    public void writeNewObject(ClassEntry type) {
        this.writeBytecode(Opcode.NEW);
        this.bytecodesBufWriter.writeIndex(type);
    }

    public void writeNewPrimitiveArray(int newArrayCode) {
        this.writeBytecode(Opcode.NEWARRAY);
        this.bytecodesBufWriter.writeU1(newArrayCode);
    }

    public void writeNewReferenceArray(ClassEntry type) {
        this.writeBytecode(Opcode.ANEWARRAY);
        this.bytecodesBufWriter.writeIndex(type);
    }

    public void writeNewMultidimensionalArray(int dimensions, ClassEntry type) {
        this.writeBytecode(Opcode.MULTIANEWARRAY);
        this.bytecodesBufWriter.writeIndex(type);
        this.bytecodesBufWriter.writeU1(dimensions);
    }

    public void writeTypeCheck(Opcode opcode, ClassEntry type) {
        this.writeBytecode(opcode);
        this.bytecodesBufWriter.writeIndex(type);
    }

    public void writeArgumentConstant(Opcode opcode, int value) {
        this.writeBytecode(opcode);
        if (opcode.sizeIfFixed() == 3) {
            this.bytecodesBufWriter.writeU2(value);
        } else {
            this.bytecodesBufWriter.writeU1(value);
        }
    }

    public void writeLoadConstant(Opcode opcode, LoadableConstantEntry value) {
        int index = AbstractPoolEntry.maybeClone(this.constantPool, value).index();
        Opcode op = opcode;
        if (value instanceof LongEntry || value instanceof DoubleEntry) {
            op = Opcode.LDC2_W;
        } else if (index >= 256) {
            op = Opcode.LDC_W;
        }
        this.writeBytecode(op);
        if (op.sizeIfFixed() == 3) {
            this.bytecodesBufWriter.writeU2(index);
        } else {
            this.bytecodesBufWriter.writeU1(index);
        }
    }

    @Override
    public Label getLabel(int bci) {
        throw new UnsupportedOperationException("Lookup by BCI not supported by CodeBuilder");
    }

    @Override
    public int labelToBci(Label label) {
        LabelImpl lab = (LabelImpl)label;
        LabelContext context = lab.labelContext();
        if (context == this) {
            return lab.getBCI();
        }
        if (context == this.mruParent) {
            return this.mruParentTable[lab.getBCI()] - 1;
        }
        if (context instanceof CodeAttribute) {
            final CodeAttribute parent = (CodeAttribute)((Object)context);
            if (this.parentMap == null) {
                this.parentMap = new IdentityHashMap<CodeAttribute, int[]>();
            }
            int[] table = this.parentMap.computeIfAbsent(parent, new Function<CodeAttribute, int[]>(){

                @Override
                public int[] apply(CodeAttribute x) {
                    return new int[parent.codeLength() + 1];
                }
            });
            this.mruParent = parent;
            this.mruParentTable = table;
            return this.mruParentTable[lab.getBCI()] - 1;
        }
        if (context instanceof BufferedCodeBuilder) {
            return lab.getBCI();
        }
        throw new IllegalStateException(String.format("Unexpected label context %s in =%s", context, this));
    }

    public void setLineNumber(int lineNo) {
        if (this.lineNumberWriter == null) {
            this.lineNumberWriter = new DedupLineNumberTableAttribute(this.constantPool, this.context);
        }
        this.lineNumberWriter.writeLineNumber(this.curPc(), lineNo);
    }

    public void setLabelTarget(Label label) {
        this.setLabelTarget(label, this.curPc());
    }

    @Override
    public void setLabelTarget(Label label, int bci) {
        LabelImpl lab = (LabelImpl)label;
        LabelContext context = lab.labelContext();
        if (context == this) {
            if (lab.getBCI() != -1) {
                throw new IllegalArgumentException("Setting label target for already-set label");
            }
            lab.setBCI(bci);
        } else if (context == this.mruParent) {
            this.mruParentTable[lab.getBCI()] = bci + 1;
        } else if (context instanceof CodeAttribute) {
            final CodeAttribute parent = (CodeAttribute)((Object)context);
            if (this.parentMap == null) {
                this.parentMap = new IdentityHashMap<CodeAttribute, int[]>();
            }
            int[] table = this.parentMap.computeIfAbsent(parent, new Function<CodeAttribute, int[]>(){

                @Override
                public int[] apply(CodeAttribute x) {
                    return new int[parent.codeLength() + 1];
                }
            });
            this.mruParent = parent;
            this.mruParentTable = table;
            this.mruParentTable[lab.getBCI()] = bci + 1;
        } else if (context instanceof BufferedCodeBuilder) {
            lab.setBCI(bci);
        } else {
            throw new IllegalStateException(String.format("Unexpected label context %s in =%s", context, this));
        }
    }

    public void addCharacterRange(CharacterRange element) {
        this.characterRanges.add(element);
    }

    public void addHandler(ExceptionCatch element) {
        AbstractPseudoInstruction.ExceptionCatchImpl el = (AbstractPseudoInstruction.ExceptionCatchImpl)element;
        ClassEntry type = el.catchTypeEntry();
        if (type != null && !this.constantPool.canWriteDirect(type.constantPool())) {
            el = new AbstractPseudoInstruction.ExceptionCatchImpl(element.handler(), element.tryStart(), element.tryEnd(), AbstractPoolEntry.maybeClone(this.constantPool, type));
        }
        this.handlers.add(el);
    }

    public void addLocalVariable(LocalVariable element) {
        this.localVariables.add(element);
    }

    public void addLocalVariableType(LocalVariableType element) {
        this.localVariableTypes.add(element);
    }

    public String toString() {
        return String.format("CodeBuilder[id=%d]", System.identityHashCode(this));
    }

    private static final class LabelOverflowException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public LabelOverflowException() {
            super("Label target offset overflow");
        }
    }

    private static class DedupLineNumberTableAttribute
    extends UnboundAttribute.AdHocAttribute<LineNumberTableAttribute> {
        private final BufWriterImpl buf;
        private int lastPc;
        private int lastLine;
        private int writtenLine;

        public DedupLineNumberTableAttribute(ConstantPoolBuilder constantPool, ClassFileImpl context) {
            super(Attributes.LINE_NUMBER_TABLE);
            this.buf = new BufWriterImpl(constantPool, context);
            this.lastPc = -1;
            this.writtenLine = -1;
        }

        private void push() {
            if (this.lastPc >= 0 && this.lastLine != this.writtenLine) {
                this.buf.writeU2(this.lastPc);
                this.buf.writeU2(this.lastLine);
                this.writtenLine = this.lastLine;
            }
        }

        public void writeLineNumber(int pc, int lineNo) {
            if (this.lastPc != pc && this.lastLine != lineNo) {
                this.push();
                this.lastPc = pc;
            }
            this.lastLine = lineNo;
        }

        @Override
        public void writeBody(BufWriter b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeTo(BufWriter b) {
            b.writeIndex(b.constantPool().utf8Entry("LineNumberTable"));
            this.push();
            b.writeInt(this.buf.size() + 2);
            b.writeU2(this.buf.size() / 4);
            b.writeBytes(this.buf);
        }
    }

    private record DeferredLabel(int labelPc, int size, int instructionPc, Label label) {
    }
}

