/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.function.Consumer;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.CustomAttribute;
import org.glavo.classfile.FieldBuilder;
import org.glavo.classfile.FieldElement;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.WritableElement;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractDirectBuilder;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.ClassFileImpl;
import org.glavo.classfile.impl.SplitConstantPool;
import org.glavo.classfile.impl.TerminalFieldBuilder;

public final class DirectFieldBuilder
extends AbstractDirectBuilder<FieldModel>
implements TerminalFieldBuilder,
WritableElement<FieldModel> {
    private final Utf8Entry name;
    private final Utf8Entry desc;
    private int flags;

    public DirectFieldBuilder(SplitConstantPool constantPool, ClassFileImpl context, Utf8Entry name, Utf8Entry type, FieldModel original) {
        super(constantPool, context);
        this.setOriginal(original);
        this.name = name;
        this.desc = type;
        this.flags = 0;
    }

    @Override
    public FieldBuilder with(FieldElement element) {
        if (element instanceof AbstractElement) {
            AbstractElement ae = (AbstractElement)((Object)element);
            ae.writeTo(this);
        } else {
            this.writeAttribute((CustomAttribute)element);
        }
        return this;
    }

    public DirectFieldBuilder run(Consumer<? super FieldBuilder> handler) {
        handler.accept(this);
        return this;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    @Override
    public void writeTo(BufWriter buf) {
        buf.writeU2(this.flags);
        buf.writeIndex(this.name);
        buf.writeIndex(this.desc);
        this.attributes.writeTo(buf);
    }
}

