/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

public abstract class EntryMap<T> {
    public static final int NO_VALUE = -1;
    private int[] data;
    private final float fillFactor;
    private int resizeThreshold;
    private int size;
    private int mask1;
    private int mask2;

    public EntryMap(int size, float fillFactor) {
        if (fillFactor <= 0.0f || fillFactor >= 1.0f) {
            throw new IllegalArgumentException("FillFactor must be in (0, 1)");
        }
        if (size <= 0) {
            throw new IllegalArgumentException("Size must be positive!");
        }
        int capacity = EntryMap.arraySize(size, fillFactor);
        this.fillFactor = fillFactor;
        this.resizeThreshold = (int)((float)capacity * fillFactor);
        this.mask1 = capacity - 1;
        this.mask2 = capacity * 2 - 1;
        this.data = new int[capacity * 2];
    }

    protected abstract T fetchElement(int var1);

    public int firstToken(int hash) {
        if (hash == 0) {
            throw new IllegalArgumentException("hash must be nonzero");
        }
        int ix = (hash & this.mask1) << 1;
        int k = this.data[ix];
        if (k == 0) {
            return -1;
        }
        if (k == hash) {
            return ix;
        }
        return this.nextToken(hash, ix);
    }

    public int nextToken(int hash, int token) {
        int k;
        int ix = token;
        do {
            if ((k = this.data[ix = ix + 2 & this.mask2]) != 0) continue;
            return -1;
        } while (k != hash);
        return ix;
    }

    public int getIndexByToken(int token) {
        return this.data[token + 1];
    }

    public T getElementByToken(int token) {
        return this.fetchElement(this.data[token + 1]);
    }

    public void put(int hash, int index) {
        if (hash == 0) {
            throw new IllegalArgumentException("hash must be nonzero");
        }
        int ptr = (hash & this.mask1) << 1;
        int k = this.data[ptr];
        if (k == 0) {
            this.data[ptr] = hash;
            this.data[ptr + 1] = index;
            if (this.size >= this.resizeThreshold) {
                this.rehash(this.data.length * 2);
            } else {
                ++this.size;
            }
            return;
        }
        if (k == hash && this.data[ptr + 1] == index) {
            return;
        }
        do {
            if ((k = this.data[ptr = ptr + 2 & this.mask2]) != 0) continue;
            this.data[ptr] = hash;
            this.data[ptr + 1] = index;
            if (this.size >= this.resizeThreshold) {
                this.rehash(this.data.length * 2);
            } else {
                ++this.size;
            }
            return;
        } while (k != hash || this.data[ptr + 1] != index);
    }

    public int size() {
        return this.size;
    }

    private void rehash(int newCapacity) {
        this.resizeThreshold = (int)((float)(newCapacity / 2) * this.fillFactor);
        this.mask1 = newCapacity / 2 - 1;
        this.mask2 = newCapacity - 1;
        int oldCapacity = this.data.length;
        int[] oldData = this.data;
        this.data = new int[newCapacity];
        this.size = 0;
        for (int i = 0; i < oldCapacity; i += 2) {
            int oldHash = oldData[i];
            if (oldHash == 0) continue;
            this.put(oldHash, oldData[i + 1]);
        }
    }

    public static long nextPowerOfTwo(long x) {
        return 1L << -Long.numberOfLeadingZeros(x - 1L);
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, EntryMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }
}

