/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.glavo.classfile.AccessFlags;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.CodeModel;
import org.glavo.classfile.MethodBuilder;
import org.glavo.classfile.MethodElement;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractElement;
import org.glavo.classfile.impl.BoundAttribute;
import org.glavo.classfile.impl.BufWriterImpl;
import org.glavo.classfile.impl.ClassReaderImpl;
import org.glavo.classfile.impl.DirectClassBuilder;
import org.glavo.classfile.impl.MethodInfo;
import org.glavo.classfile.impl.Util;

public final class MethodImpl
extends AbstractElement
implements MethodModel,
MethodInfo {
    private final ClassReader reader;
    private final int startPos;
    private final int endPos;
    private final int attributesPos;
    private List<Attribute<?>> attributes;
    private int[] parameterSlots;
    private MethodTypeDesc mDesc;

    public MethodImpl(ClassReader reader, int startPos, int endPos, int attrStart) {
        this.reader = reader;
        this.startPos = startPos;
        this.endPos = endPos;
        this.attributesPos = attrStart;
    }

    @Override
    public AccessFlags flags() {
        return AccessFlags.ofMethod(this.reader.readU2(this.startPos));
    }

    @Override
    public Optional<ClassModel> parent() {
        ClassReader classReader = this.reader;
        if (classReader instanceof ClassReaderImpl) {
            ClassReaderImpl cri = (ClassReaderImpl)classReader;
            return Optional.of(cri.getContainedClass());
        }
        return Optional.empty();
    }

    @Override
    public Utf8Entry methodName() {
        return this.reader.readUtf8Entry(this.startPos + 2);
    }

    @Override
    public Utf8Entry methodType() {
        return this.reader.readUtf8Entry(this.startPos + 4);
    }

    @Override
    public MethodTypeDesc methodTypeSymbol() {
        if (this.mDesc == null) {
            this.mDesc = MethodTypeDesc.ofDescriptor(this.methodType().stringValue());
        }
        return this.mDesc;
    }

    @Override
    public int methodFlags() {
        return this.reader.readU2(this.startPos);
    }

    @Override
    public int parameterSlot(int paramNo) {
        if (this.parameterSlots == null) {
            this.parameterSlots = Util.parseParameterSlots(this.methodFlags(), this.methodTypeSymbol());
        }
        return this.parameterSlots[paramNo];
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(this, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }

    @Override
    public void writeTo(BufWriter b) {
        BufWriterImpl buf = (BufWriterImpl)b;
        if (buf.canWriteDirect(this.reader)) {
            this.reader.copyBytesTo(buf, this.startPos, this.endPos - this.startPos);
        } else {
            buf.writeU2(this.flags().flagsMask());
            buf.writeIndex(this.methodName());
            buf.writeIndex(this.methodType());
            buf.writeList(this.attributes());
        }
    }

    @Override
    public Optional<CodeModel> code() {
        return this.findAttribute(Attributes.CODE).map(a -> a);
    }

    @Override
    public void forEachElement(Consumer<MethodElement> consumer) {
        consumer.accept(this.flags());
        for (Attribute<?> attr : this.attributes()) {
            if (!(attr instanceof MethodElement)) continue;
            MethodElement e = (MethodElement)((Object)attr);
            consumer.accept(e);
        }
    }

    @Override
    public void writeTo(DirectClassBuilder builder) {
        if (builder.canWriteDirect(this.reader)) {
            builder.withMethod(this);
        } else {
            builder.withMethod(this.methodName(), this.methodType(), this.methodFlags(), (Consumer<? super MethodBuilder>)new Consumer<MethodBuilder>(){

                @Override
                public void accept(MethodBuilder mb) {
                    MethodImpl.this.forEachElement(mb);
                }
            });
        }
    }

    public String toString() {
        return String.format("MethodModel[methodName=%s, methodType=%s, flags=%d]", this.methodName().stringValue(), this.methodType().stringValue(), this.flags().flagsMask());
    }
}

