/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ConstantDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.Arrays;
import java.util.List;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.BootstrapMethodEntry;
import org.glavo.classfile.BufWriter;
import org.glavo.classfile.ClassReader;
import org.glavo.classfile.attribute.BootstrapMethodsAttribute;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantDynamicEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.ConstantPoolBuilder;
import org.glavo.classfile.constantpool.ConstantPoolException;
import org.glavo.classfile.constantpool.DoubleEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.FloatEntry;
import org.glavo.classfile.constantpool.IntegerEntry;
import org.glavo.classfile.constantpool.InterfaceMethodRefEntry;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.LongEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.MethodHandleEntry;
import org.glavo.classfile.constantpool.MethodRefEntry;
import org.glavo.classfile.constantpool.MethodTypeEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PackageEntry;
import org.glavo.classfile.constantpool.PoolEntry;
import org.glavo.classfile.constantpool.StringEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.BootstrapMethodEntryImpl;
import org.glavo.classfile.impl.ClassReaderImpl;
import org.glavo.classfile.impl.EntryMap;
import org.glavo.classfile.impl.UnboundAttribute;

public final class SplitConstantPool
implements ConstantPoolBuilder {
    private final ClassReaderImpl parent;
    private final int parentSize;
    private final int parentBsmSize;
    private int size;
    private int bsmSize;
    private PoolEntry[] myEntries;
    private BootstrapMethodEntryImpl[] myBsmEntries;
    private boolean doneFullScan;
    private EntryMap<PoolEntry> map;
    private EntryMap<BootstrapMethodEntryImpl> bsmMap;

    public SplitConstantPool() {
        this.size = 1;
        this.bsmSize = 0;
        this.myEntries = new PoolEntry[1024];
        this.myBsmEntries = new BootstrapMethodEntryImpl[8];
        this.parent = null;
        this.parentSize = 0;
        this.parentBsmSize = 0;
        this.doneFullScan = true;
    }

    public SplitConstantPool(ClassReader parent) {
        this.parent = (ClassReaderImpl)parent;
        this.parentSize = parent.size();
        this.parentBsmSize = parent.bootstrapMethodCount();
        this.size = this.parentSize;
        this.bsmSize = this.parentBsmSize;
        this.myEntries = new PoolEntry[8];
        this.myBsmEntries = new BootstrapMethodEntryImpl[8];
        this.doneFullScan = true;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int bootstrapMethodCount() {
        return this.bsmSize;
    }

    @Override
    public PoolEntry entryByIndex(int index) {
        PoolEntry pe;
        if (index <= 0 || index >= this.size()) {
            throw new ConstantPoolException("Bad CP index: " + index);
        }
        PoolEntry poolEntry = pe = index < this.parentSize ? this.parent.entryByIndex(index) : this.myEntries[index - this.parentSize];
        if (pe == null) {
            throw new ConstantPoolException("Unusable CP index: " + index);
        }
        return pe;
    }

    @Override
    public BootstrapMethodEntryImpl bootstrapMethodEntry(int index) {
        if (index < 0 || index >= this.bootstrapMethodCount()) {
            throw new ConstantPoolException("Bad BSM index: " + index);
        }
        return index < this.parentBsmSize ? this.parent.bootstrapMethodEntry(index) : this.myBsmEntries[index - this.parentBsmSize];
    }

    @Override
    public boolean canWriteDirect(ConstantPool other) {
        return this == other || this.parent == other;
    }

    @Override
    public boolean writeBootstrapMethods(final BufWriter buf) {
        if (this.bsmSize == 0) {
            return false;
        }
        int pos = buf.size();
        if (this.parent != null && this.parentBsmSize != 0) {
            this.parent.writeBootstrapMethods(buf);
            for (int i = this.parentBsmSize; i < this.bsmSize; ++i) {
                this.bootstrapMethodEntry(i).writeTo(buf);
            }
            int attrLen = buf.size() - pos;
            buf.patchInt(pos + 2, 4, attrLen - 6);
            buf.patchInt(pos + 6, 2, this.bsmSize);
        } else {
            UnboundAttribute.AdHocAttribute<BootstrapMethodsAttribute> a = new UnboundAttribute.AdHocAttribute<BootstrapMethodsAttribute>(Attributes.BOOTSTRAP_METHODS){

                @Override
                public void writeBody(BufWriter b) {
                    buf.writeU2(SplitConstantPool.this.bsmSize);
                    for (int i = 0; i < SplitConstantPool.this.bsmSize; ++i) {
                        SplitConstantPool.this.bootstrapMethodEntry(i).writeTo(buf);
                    }
                }
            };
            a.writeTo(buf);
        }
        return true;
    }

    @Override
    public void writeTo(BufWriter buf) {
        PoolEntry info;
        int writeFrom = 1;
        if (this.size() >= 65536) {
            throw new IllegalArgumentException(String.format("Constant pool is too large %d", this.size()));
        }
        buf.writeU2(this.size());
        if (this.parent != null && buf.constantPool().canWriteDirect(this)) {
            this.parent.writeConstantPoolEntries(buf);
            writeFrom = this.parent.size();
        }
        for (int i = writeFrom; i < this.size(); i += info.width()) {
            info = this.entryByIndex(i);
            info.writeTo(buf);
        }
    }

    private EntryMap<PoolEntry> map() {
        if (this.map == null) {
            PoolEntry cpi;
            this.map = new EntryMap<PoolEntry>(Math.max(this.size, 1024), 0.75f){

                @Override
                protected PoolEntry fetchElement(int index) {
                    return SplitConstantPool.this.entryByIndex(index);
                }
            };
            int i = 1;
            while (i < this.parentSize) {
                cpi = this.parent.cp[i];
                if (cpi == null) {
                    this.doneFullScan = false;
                    ++i;
                    continue;
                }
                this.map.put(cpi.hashCode(), cpi.index());
                i += cpi.width();
            }
            for (i = Math.max(this.parentSize, 1); i < this.size; i += cpi.width()) {
                cpi = this.myEntries[i - this.parentSize];
                this.map.put(cpi.hashCode(), cpi.index());
            }
        }
        return this.map;
    }

    private void fullScan() {
        PoolEntry cpi;
        for (int i = 1; i < this.parentSize; i += cpi.width()) {
            cpi = this.parent.entryByIndex(i);
            this.map.put(cpi.hashCode(), cpi.index());
        }
        this.doneFullScan = true;
    }

    private EntryMap<BootstrapMethodEntryImpl> bsmMap() {
        if (this.bsmMap == null) {
            BootstrapMethodEntryImpl bsm;
            int i;
            this.bsmMap = new EntryMap<BootstrapMethodEntryImpl>(Math.max(this.bsmSize, 16), 0.75f){

                @Override
                protected BootstrapMethodEntryImpl fetchElement(int index) {
                    return SplitConstantPool.this.bootstrapMethodEntry(index);
                }
            };
            for (i = 0; i < this.parentBsmSize; ++i) {
                bsm = this.parent.bootstrapMethodEntry(i);
                this.bsmMap.put(bsm.hash, bsm.index);
            }
            for (i = this.parentBsmSize; i < this.bsmSize; ++i) {
                bsm = this.myBsmEntries[i - this.parentBsmSize];
                this.bsmMap.put(bsm.hash, bsm.index);
            }
        }
        return this.bsmMap;
    }

    private <E extends PoolEntry> E internalAdd(E cpi) {
        return this.internalAdd(cpi, cpi.hashCode());
    }

    private <E extends PoolEntry> E internalAdd(E cpi, int hash) {
        int newIndex = this.size - this.parentSize;
        if (newIndex + 2 > this.myEntries.length) {
            this.myEntries = (PoolEntry[])Arrays.copyOf(this.myEntries, 2 * newIndex, PoolEntry[].class);
        }
        this.myEntries[newIndex] = cpi;
        this.size += cpi.width();
        this.map().put(hash, cpi.index());
        return cpi;
    }

    private BootstrapMethodEntryImpl internalAdd(BootstrapMethodEntryImpl bsm, int hash) {
        int newIndex = this.bsmSize - this.parentBsmSize;
        if (newIndex + 2 > this.myBsmEntries.length) {
            this.myBsmEntries = (BootstrapMethodEntryImpl[])Arrays.copyOf(this.myBsmEntries, 2 * newIndex, BootstrapMethodEntryImpl[].class);
        }
        this.myBsmEntries[newIndex] = bsm;
        ++this.bsmSize;
        this.bsmMap().put(hash, bsm.index);
        return bsm;
    }

    private <T extends ConstantDesc> PoolEntry findPrimitiveEntry(int tag, T val) {
        int hash = AbstractPoolEntry.hash1(tag, val.hashCode());
        EntryMap<PoolEntry> map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.PrimitiveEntry ce;
            PoolEntry e = map.getElementByToken(token);
            if (e.tag() == tag && e instanceof AbstractPoolEntry.PrimitiveEntry && (ce = (AbstractPoolEntry.PrimitiveEntry)((Object)e)).value().equals(val)) {
                return e;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findPrimitiveEntry(tag, val);
        }
        return null;
    }

    private <T extends AbstractPoolEntry> AbstractPoolEntry findEntry(int tag, T ref1) {
        int hash = AbstractPoolEntry.hash1(tag, ref1.index());
        EntryMap<PoolEntry> map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            PoolEntry e = map.getElementByToken(token);
            if (e.tag() == tag && e instanceof AbstractPoolEntry.AbstractRefEntry) {
                AbstractPoolEntry.AbstractRefEntry re = (AbstractPoolEntry.AbstractRefEntry)((Object)e);
                if (re.ref1 == ref1) {
                    return re;
                }
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findEntry(tag, ref1);
        }
        return null;
    }

    private <T extends AbstractPoolEntry, U extends AbstractPoolEntry> AbstractPoolEntry findEntry(int tag, T ref1, U ref2) {
        int hash = AbstractPoolEntry.hash2(tag, ref1.index(), ref2.index());
        EntryMap<PoolEntry> map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            PoolEntry e = map.getElementByToken(token);
            if (e.tag() == tag && e instanceof AbstractPoolEntry.AbstractRefsEntry) {
                AbstractPoolEntry.AbstractRefsEntry re = (AbstractPoolEntry.AbstractRefsEntry)((Object)e);
                if (re.ref1 == ref1 && re.ref2 == ref2) {
                    return re;
                }
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.findEntry(tag, ref1, ref2);
        }
        return null;
    }

    private AbstractPoolEntry.Utf8EntryImpl tryFindUtf8(int hash, String target) {
        EntryMap<PoolEntry> map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.Utf8EntryImpl ce;
            PoolEntry e = map.getElementByToken(token);
            if (e.tag() == 1 && e instanceof AbstractPoolEntry.Utf8EntryImpl && (ce = (AbstractPoolEntry.Utf8EntryImpl)e).hashCode() == hash && target.equals(ce.stringValue())) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.tryFindUtf8(hash, target);
        }
        return null;
    }

    private AbstractPoolEntry.Utf8EntryImpl tryFindUtf8(int hash, AbstractPoolEntry.Utf8EntryImpl target) {
        EntryMap<PoolEntry> map = this.map();
        int token = map.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.Utf8EntryImpl ce;
            PoolEntry e = map.getElementByToken(token);
            if (e.tag() == 1 && e instanceof AbstractPoolEntry.Utf8EntryImpl && target.equalsUtf8(ce = (AbstractPoolEntry.Utf8EntryImpl)e)) {
                return ce;
            }
            token = map.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.tryFindUtf8(hash, target);
        }
        return null;
    }

    @Override
    public AbstractPoolEntry.Utf8EntryImpl utf8Entry(String s) {
        int hash = AbstractPoolEntry.hashString(s.hashCode());
        AbstractPoolEntry.Utf8EntryImpl ce = this.tryFindUtf8(hash, s);
        return ce == null ? this.internalAdd(new AbstractPoolEntry.Utf8EntryImpl((ConstantPool)this, this.size, s, hash)) : ce;
    }

    AbstractPoolEntry.Utf8EntryImpl maybeCloneUtf8Entry(Utf8Entry entry) {
        AbstractPoolEntry.Utf8EntryImpl e = (AbstractPoolEntry.Utf8EntryImpl)entry;
        if (e.constantPool == this || e.constantPool == this.parent) {
            return e;
        }
        AbstractPoolEntry.Utf8EntryImpl ce = this.tryFindUtf8(e.hashCode(), e);
        return ce == null ? this.internalAdd(new AbstractPoolEntry.Utf8EntryImpl((ConstantPool)this, this.size, e)) : ce;
    }

    @Override
    public AbstractPoolEntry.ClassEntryImpl classEntry(Utf8Entry nameEntry) {
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.ClassEntryImpl e = (AbstractPoolEntry.ClassEntryImpl)this.findEntry(7, ne);
        return e == null ? this.internalAdd(new AbstractPoolEntry.ClassEntryImpl(this, this.size, ne)) : e;
    }

    @Override
    public PackageEntry packageEntry(Utf8Entry nameEntry) {
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.PackageEntryImpl e = (AbstractPoolEntry.PackageEntryImpl)this.findEntry(20, ne);
        return e == null ? (PackageEntry)this.internalAdd(new AbstractPoolEntry.PackageEntryImpl(this, this.size, ne)) : e;
    }

    @Override
    public ModuleEntry moduleEntry(Utf8Entry nameEntry) {
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.ModuleEntryImpl e = (AbstractPoolEntry.ModuleEntryImpl)this.findEntry(19, ne);
        return e == null ? (ModuleEntry)this.internalAdd(new AbstractPoolEntry.ModuleEntryImpl(this, this.size, ne)) : e;
    }

    @Override
    public AbstractPoolEntry.NameAndTypeEntryImpl nameAndTypeEntry(Utf8Entry nameEntry, Utf8Entry typeEntry) {
        AbstractPoolEntry.Utf8EntryImpl te;
        AbstractPoolEntry.Utf8EntryImpl ne = this.maybeCloneUtf8Entry(nameEntry);
        AbstractPoolEntry.NameAndTypeEntryImpl e = (AbstractPoolEntry.NameAndTypeEntryImpl)this.findEntry(12, ne, te = this.maybeCloneUtf8Entry(typeEntry));
        return e == null ? this.internalAdd(new AbstractPoolEntry.NameAndTypeEntryImpl((ConstantPool)this, this.size, ne, te)) : e;
    }

    @Override
    public FieldRefEntry fieldRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        AbstractPoolEntry.FieldRefEntryImpl e;
        AbstractPoolEntry.ClassEntryImpl oe = (AbstractPoolEntry.ClassEntryImpl)owner;
        AbstractPoolEntry.NameAndTypeEntryImpl ne = (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType;
        if (!this.canWriteDirect(oe.constantPool)) {
            oe = this.classEntry(owner.name());
        }
        if (!this.canWriteDirect(ne.constantPool)) {
            ne = this.nameAndTypeEntry(nameAndType.name(), nameAndType.type());
        }
        return (e = (AbstractPoolEntry.FieldRefEntryImpl)this.findEntry(9, oe, ne)) == null ? (FieldRefEntry)this.internalAdd(new AbstractPoolEntry.FieldRefEntryImpl((ConstantPool)this, this.size, oe, ne)) : e;
    }

    @Override
    public MethodRefEntry methodRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        AbstractPoolEntry.MethodRefEntryImpl e;
        AbstractPoolEntry.ClassEntryImpl oe = (AbstractPoolEntry.ClassEntryImpl)owner;
        AbstractPoolEntry.NameAndTypeEntryImpl ne = (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType;
        if (!this.canWriteDirect(oe.constantPool)) {
            oe = this.classEntry(owner.name());
        }
        if (!this.canWriteDirect(ne.constantPool)) {
            ne = this.nameAndTypeEntry(nameAndType.name(), nameAndType.type());
        }
        return (e = (AbstractPoolEntry.MethodRefEntryImpl)this.findEntry(10, oe, ne)) == null ? (MethodRefEntry)this.internalAdd(new AbstractPoolEntry.MethodRefEntryImpl((ConstantPool)this, this.size, oe, ne)) : e;
    }

    @Override
    public InterfaceMethodRefEntry interfaceMethodRefEntry(ClassEntry owner, NameAndTypeEntry nameAndType) {
        AbstractPoolEntry.InterfaceMethodRefEntryImpl e;
        AbstractPoolEntry.ClassEntryImpl oe = (AbstractPoolEntry.ClassEntryImpl)owner;
        AbstractPoolEntry.NameAndTypeEntryImpl ne = (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType;
        if (!this.canWriteDirect(oe.constantPool)) {
            oe = this.classEntry(owner.name());
        }
        if (!this.canWriteDirect(ne.constantPool)) {
            ne = this.nameAndTypeEntry(nameAndType.name(), nameAndType.type());
        }
        return (e = (AbstractPoolEntry.InterfaceMethodRefEntryImpl)this.findEntry(11, oe, ne)) == null ? (InterfaceMethodRefEntry)this.internalAdd(new AbstractPoolEntry.InterfaceMethodRefEntryImpl((ConstantPool)this, this.size, oe, ne)) : e;
    }

    @Override
    public MethodTypeEntry methodTypeEntry(MethodTypeDesc descriptor) {
        AbstractPoolEntry.MethodTypeEntryImpl ret = (AbstractPoolEntry.MethodTypeEntryImpl)this.methodTypeEntry(this.utf8Entry(descriptor.descriptorString()));
        ret.sym = descriptor;
        return ret;
    }

    @Override
    public MethodTypeEntry methodTypeEntry(Utf8Entry descriptor) {
        AbstractPoolEntry.Utf8EntryImpl de = this.maybeCloneUtf8Entry(descriptor);
        AbstractPoolEntry.MethodTypeEntryImpl e = (AbstractPoolEntry.MethodTypeEntryImpl)this.findEntry(16, de);
        return e == null ? (MethodTypeEntry)this.internalAdd(new AbstractPoolEntry.MethodTypeEntryImpl(this, this.size, de)) : e;
    }

    @Override
    public MethodHandleEntry methodHandleEntry(int refKind, MemberRefEntry reference) {
        if (!this.canWriteDirect(reference.constantPool())) {
            reference = switch (reference.tag()) {
                case 9 -> this.fieldRefEntry(reference.owner(), reference.nameAndType());
                case 10 -> this.methodRefEntry(reference.owner(), reference.nameAndType());
                case 11 -> this.interfaceMethodRefEntry(reference.owner(), reference.nameAndType());
                default -> throw new IllegalArgumentException(String.format("Bad tag %d", reference.tag()));
            };
        }
        int hash = AbstractPoolEntry.hash2(15, refKind, reference.index());
        EntryMap<PoolEntry> map1 = this.map();
        int token = map1.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.MethodHandleEntryImpl ce;
            PoolEntry e = map1.getElementByToken(token);
            if (e.tag() == 15 && e instanceof AbstractPoolEntry.MethodHandleEntryImpl && (ce = (AbstractPoolEntry.MethodHandleEntryImpl)e).kind() == refKind && ce.reference() == reference) {
                return ce;
            }
            token = map1.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.methodHandleEntry(refKind, reference);
        }
        return this.internalAdd(new AbstractPoolEntry.MethodHandleEntryImpl(this, this.size, hash, refKind, (AbstractPoolEntry.AbstractMemberRefEntry)reference), hash);
    }

    @Override
    public InvokeDynamicEntry invokeDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, NameAndTypeEntry nameAndType) {
        if (!this.canWriteDirect(bootstrapMethodEntry.constantPool())) {
            bootstrapMethodEntry = this.bsmEntry(bootstrapMethodEntry.bootstrapMethod(), bootstrapMethodEntry.arguments());
        }
        if (!this.canWriteDirect(nameAndType.constantPool())) {
            nameAndType = this.nameAndTypeEntry(nameAndType.name(), nameAndType.type());
        }
        int hash = AbstractPoolEntry.hash2(18, bootstrapMethodEntry.bsmIndex(), nameAndType.index());
        EntryMap<PoolEntry> map1 = this.map();
        int token = map1.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.InvokeDynamicEntryImpl ce;
            PoolEntry e = map1.getElementByToken(token);
            if (e.tag() == 18 && e instanceof AbstractPoolEntry.InvokeDynamicEntryImpl && (ce = (AbstractPoolEntry.InvokeDynamicEntryImpl)e).bootstrap() == bootstrapMethodEntry && ce.nameAndType() == nameAndType) {
                return ce;
            }
            token = map1.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.invokeDynamicEntry(bootstrapMethodEntry, nameAndType);
        }
        AbstractPoolEntry.InvokeDynamicEntryImpl ce = new AbstractPoolEntry.InvokeDynamicEntryImpl(this, this.size, hash, (BootstrapMethodEntryImpl)bootstrapMethodEntry, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType);
        this.internalAdd(ce, hash);
        return ce;
    }

    @Override
    public ConstantDynamicEntry constantDynamicEntry(BootstrapMethodEntry bootstrapMethodEntry, NameAndTypeEntry nameAndType) {
        if (!this.canWriteDirect(bootstrapMethodEntry.constantPool())) {
            bootstrapMethodEntry = this.bsmEntry(bootstrapMethodEntry.bootstrapMethod(), bootstrapMethodEntry.arguments());
        }
        if (!this.canWriteDirect(nameAndType.constantPool())) {
            nameAndType = this.nameAndTypeEntry(nameAndType.name(), nameAndType.type());
        }
        int hash = AbstractPoolEntry.hash2(17, bootstrapMethodEntry.bsmIndex(), nameAndType.index());
        EntryMap<PoolEntry> map1 = this.map();
        int token = map1.firstToken(hash);
        while (token != -1) {
            AbstractPoolEntry.ConstantDynamicEntryImpl ce;
            PoolEntry e = map1.getElementByToken(token);
            if (e.tag() == 17 && e instanceof AbstractPoolEntry.ConstantDynamicEntryImpl && (ce = (AbstractPoolEntry.ConstantDynamicEntryImpl)e).bootstrap() == bootstrapMethodEntry && ce.nameAndType() == nameAndType) {
                return ce;
            }
            token = map1.nextToken(hash, token);
        }
        if (!this.doneFullScan) {
            this.fullScan();
            return this.constantDynamicEntry(bootstrapMethodEntry, nameAndType);
        }
        AbstractPoolEntry.ConstantDynamicEntryImpl ce = new AbstractPoolEntry.ConstantDynamicEntryImpl(this, this.size, hash, (BootstrapMethodEntryImpl)bootstrapMethodEntry, (AbstractPoolEntry.NameAndTypeEntryImpl)nameAndType);
        this.internalAdd(ce, hash);
        return ce;
    }

    @Override
    public IntegerEntry intEntry(int value) {
        IntegerEntry e = (IntegerEntry)this.findPrimitiveEntry(3, value);
        return e == null ? (IntegerEntry)this.internalAdd(new AbstractPoolEntry.IntegerEntryImpl(this, this.size, value)) : e;
    }

    @Override
    public FloatEntry floatEntry(float value) {
        FloatEntry e = (FloatEntry)this.findPrimitiveEntry(4, Float.valueOf(value));
        return e == null ? (FloatEntry)this.internalAdd(new AbstractPoolEntry.FloatEntryImpl(this, this.size, value)) : e;
    }

    @Override
    public LongEntry longEntry(long value) {
        LongEntry e = (LongEntry)this.findPrimitiveEntry(5, value);
        return e == null ? (LongEntry)this.internalAdd(new AbstractPoolEntry.LongEntryImpl(this, this.size, value)) : e;
    }

    @Override
    public DoubleEntry doubleEntry(double value) {
        DoubleEntry e = (DoubleEntry)this.findPrimitiveEntry(6, value);
        return e == null ? (DoubleEntry)this.internalAdd(new AbstractPoolEntry.DoubleEntryImpl(this, this.size, value)) : e;
    }

    @Override
    public StringEntry stringEntry(Utf8Entry utf8) {
        AbstractPoolEntry.Utf8EntryImpl ue = this.maybeCloneUtf8Entry(utf8);
        AbstractPoolEntry.StringEntryImpl e = (AbstractPoolEntry.StringEntryImpl)this.findEntry(8, ue);
        return e == null ? (StringEntry)this.internalAdd(new AbstractPoolEntry.StringEntryImpl(this, this.size, ue)) : e;
    }

    @Override
    public BootstrapMethodEntry bsmEntry(MethodHandleEntry methodReference, List<LoadableConstantEntry> arguments) {
        if (!this.canWriteDirect(methodReference.constantPool())) {
            methodReference = this.methodHandleEntry(methodReference.kind(), methodReference.reference());
        }
        for (LoadableConstantEntry a : arguments) {
            if (this.canWriteDirect(a.constantPool())) continue;
            LoadableConstantEntry[] arr = arguments.toArray(new LoadableConstantEntry[0]);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = AbstractPoolEntry.maybeClone(this, arr[i]);
            }
            arguments = List.of(arr);
            break;
        }
        AbstractPoolEntry.MethodHandleEntryImpl mre = (AbstractPoolEntry.MethodHandleEntryImpl)methodReference;
        int hash = BootstrapMethodEntryImpl.computeHashCode(mre, arguments);
        EntryMap<BootstrapMethodEntryImpl> map = this.bsmMap();
        int token = map.firstToken(hash);
        while (token != -1) {
            BootstrapMethodEntryImpl e = map.getElementByToken(token);
            if (e.bootstrapMethod() == mre && e.arguments().equals(arguments)) {
                return e;
            }
            token = map.nextToken(hash, token);
        }
        BootstrapMethodEntryImpl ne = new BootstrapMethodEntryImpl(this, this.bsmSize, hash, mre, arguments);
        return this.internalAdd(ne, hash);
    }
}

