/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.util.List;
import java.util.Objects;
import org.glavo.classfile.Label;
import org.glavo.classfile.TypeAnnotation;

public final class TargetInfoImpl {
    private TargetInfoImpl() {
    }

    private static TypeAnnotation.TargetType checkValid(TypeAnnotation.TargetType targetType, int rangeFrom, int rangeTo) {
        Objects.requireNonNull(targetType);
        if (targetType.targetTypeValue() < rangeFrom || targetType.targetTypeValue() > rangeTo) {
            throw new IllegalArgumentException("Wrong target type specified " + targetType);
        }
        return targetType;
    }

    public record TypeArgumentTargetImpl(TypeAnnotation.TargetType targetType, Label target, int typeArgumentIndex) implements TypeAnnotation.TypeArgumentTarget
    {
        public TypeArgumentTargetImpl(TypeAnnotation.TargetType targetType, Label target, int typeArgumentIndex) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 71, 75);
            this.target = Objects.requireNonNull(target);
            this.typeArgumentIndex = typeArgumentIndex;
        }
    }

    public record OffsetTargetImpl(TypeAnnotation.TargetType targetType, Label target) implements TypeAnnotation.OffsetTarget
    {
        public OffsetTargetImpl(TypeAnnotation.TargetType targetType, Label target) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 67, 70);
            this.target = Objects.requireNonNull(target);
        }
    }

    public record CatchTargetImpl(int exceptionTableIndex) implements TypeAnnotation.CatchTarget
    {
        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.EXCEPTION_PARAMETER;
        }
    }

    public record LocalVarTargetInfoImpl(Label startLabel, Label endLabel, int index) implements TypeAnnotation.LocalVarTargetInfo
    {
        public LocalVarTargetInfoImpl {
            Objects.requireNonNull(startLabel);
            Objects.requireNonNull(endLabel);
        }
    }

    public record LocalVarTargetImpl(TypeAnnotation.TargetType targetType, List<TypeAnnotation.LocalVarTargetInfo> table) implements TypeAnnotation.LocalVarTarget
    {
        public LocalVarTargetImpl(TypeAnnotation.TargetType targetType, List<TypeAnnotation.LocalVarTargetInfo> table) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 64, 65);
            this.table = List.copyOf(table);
        }

        @Override
        public int size() {
            return 2 + 6 * this.table.size();
        }
    }

    public record ThrowsTargetImpl(int throwsTargetIndex) implements TypeAnnotation.ThrowsTarget
    {
        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.THROWS;
        }
    }

    public record FormalParameterTargetImpl(int formalParameterIndex) implements TypeAnnotation.FormalParameterTarget
    {
        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.METHOD_FORMAL_PARAMETER;
        }
    }

    public record EmptyTargetImpl(TypeAnnotation.TargetType targetType) implements TypeAnnotation.EmptyTarget
    {
        public EmptyTargetImpl(TypeAnnotation.TargetType targetType) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 19, 21);
        }
    }

    public record TypeParameterBoundTargetImpl(TypeAnnotation.TargetType targetType, int typeParameterIndex, int boundIndex) implements TypeAnnotation.TypeParameterBoundTarget
    {
        public TypeParameterBoundTargetImpl(TypeAnnotation.TargetType targetType, int typeParameterIndex, int boundIndex) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 17, 18);
            this.typeParameterIndex = typeParameterIndex;
            this.boundIndex = boundIndex;
        }
    }

    public record SupertypeTargetImpl(int supertypeIndex) implements TypeAnnotation.SupertypeTarget
    {
        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.CLASS_EXTENDS;
        }
    }

    public record TypeParameterTargetImpl(TypeAnnotation.TargetType targetType, int typeParameterIndex) implements TypeAnnotation.TypeParameterTarget
    {
        public TypeParameterTargetImpl(TypeAnnotation.TargetType targetType, int typeParameterIndex) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 0, 1);
            this.typeParameterIndex = typeParameterIndex;
        }
    }
}

