/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl;

import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.Attribute;
import org.glavo.classfile.AttributeMapper;
import org.glavo.classfile.ClassFile;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.constant.ModuleDesc;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ModuleEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.impl.AbstractPoolEntry;
import org.glavo.classfile.impl.BoundAttribute;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.jdk.ClassDescUtils;
import org.glavo.classfile.jdk.CollectionUtils;

public class Util {
    private static final int ATTRIBUTE_STABILITY_COUNT = AttributeMapper.AttributeStability.values().length;

    private Util() {
    }

    public static boolean isAttributeAllowed(Attribute<?> attr, ClassFile.AttributesProcessingOption processingOption) {
        return attr instanceof BoundAttribute ? ATTRIBUTE_STABILITY_COUNT - attr.attributeMapper().stability().ordinal() > processingOption.ordinal() : true;
    }

    public static int parameterSlots(MethodTypeDesc mDesc) {
        int count = 0;
        for (int i = 0; i < mDesc.parameterCount(); ++i) {
            count += Util.slotSize(mDesc.parameterType(i));
        }
        return count;
    }

    public static int[] parseParameterSlots(int flags, MethodTypeDesc mDesc) {
        int[] result = new int[mDesc.parameterCount()];
        int count = (flags & 8) != 0 ? 0 : 1;
        for (int i = 0; i < result.length; ++i) {
            result[i] = count;
            count += Util.slotSize(mDesc.parameterType(i));
        }
        return result;
    }

    public static int maxLocals(int flags, MethodTypeDesc mDesc) {
        int count = (flags & 8) != 0 ? 0 : 1;
        for (int i = 0; i < mDesc.parameterCount(); ++i) {
            count += Util.slotSize(mDesc.parameterType(i));
        }
        return count;
    }

    public static String toBinaryName(ClassDesc cd) {
        return Util.toInternalName(cd).replace('/', '.');
    }

    public static String toInternalName(ClassDesc cd) {
        String desc = cd.descriptorString();
        if (desc.charAt(0) == 'L') {
            return desc.substring(1, desc.length() - 1);
        }
        throw new IllegalArgumentException(desc);
    }

    public static ClassDesc toClassDesc(String classInternalNameOrArrayDesc) {
        return classInternalNameOrArrayDesc.charAt(0) == '[' ? ClassDesc.ofDescriptor(classInternalNameOrArrayDesc) : ClassDescUtils.ofInternalName(classInternalNameOrArrayDesc);
    }

    public static <T, U> List<U> mappedList(final List<? extends T> list, final Function<T, U> mapper) {
        return new AbstractList<U>(){

            @Override
            public U get(int index) {
                return mapper.apply(list.get(index));
            }

            @Override
            public int size() {
                return list.size();
            }
        };
    }

    public static List<ClassEntry> entryList(List<? extends ClassDesc> list) {
        Object[] result = new Object[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TemporaryConstantPool.INSTANCE.classEntry(list.get(i));
        }
        return CollectionUtils.listFromTrustedArray(result);
    }

    public static List<ModuleEntry> moduleEntryList(List<? extends ModuleDesc> list) {
        Object[] result = new Object[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = TemporaryConstantPool.INSTANCE.moduleEntry(TemporaryConstantPool.INSTANCE.utf8Entry(list.get(i).name()));
        }
        return CollectionUtils.listFromTrustedArray(result);
    }

    public static void checkKind(Opcode op, Opcode.Kind k) {
        if (op.kind() != k) {
            throw new IllegalArgumentException(String.format("Wrong opcode kind specified; found %s(%s), expected %s", new Object[]{op, op.kind(), k}));
        }
    }

    public static int flagsToBits(AccessFlag.Location location, Collection<AccessFlag> flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + f + " use in target location: " + location);
            }
            i |= f.mask();
        }
        return i;
    }

    public static int flagsToBits(AccessFlag.Location location, AccessFlag ... flags) {
        int i = 0;
        for (AccessFlag f : flags) {
            if (!f.locations().contains((Object)location)) {
                throw new IllegalArgumentException("unexpected flag: " + f + " use in target location: " + location);
            }
            i |= f.mask();
        }
        return i;
    }

    public static boolean has(AccessFlag.Location location, int flagsMask, AccessFlag flag) {
        return (flag.mask() & flagsMask) == flag.mask() && flag.locations().contains((Object)location);
    }

    public static ClassDesc fieldTypeSymbol(NameAndTypeEntry nat) {
        return ((AbstractPoolEntry.NameAndTypeEntryImpl)nat).fieldTypeSymbol();
    }

    public static MethodTypeDesc methodTypeSymbol(NameAndTypeEntry nat) {
        return ((AbstractPoolEntry.NameAndTypeEntryImpl)nat).methodTypeSymbol();
    }

    public static int slotSize(ClassDesc desc) {
        return switch (desc.descriptorString().charAt(0)) {
            case 'V' -> 0;
            case 'D', 'J' -> 2;
            default -> 1;
        };
    }

    public static boolean isDoubleSlot(ClassDesc desc) {
        char ch = desc.descriptorString().charAt(0);
        return ch == 'D' || ch == 'J';
    }
}

