/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.impl.verifier;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.glavo.classfile.AccessFlag;
import org.glavo.classfile.Attributes;
import org.glavo.classfile.ClassModel;
import org.glavo.classfile.FieldModel;
import org.glavo.classfile.MethodModel;
import org.glavo.classfile.attribute.LocalVariableInfo;
import org.glavo.classfile.attribute.LocalVariableTableAttribute;
import org.glavo.classfile.attribute.StackMapTableAttribute;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.ConstantPool;
import org.glavo.classfile.constantpool.DynamicConstantPoolEntry;
import org.glavo.classfile.constantpool.MemberRefEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.PoolEntry;
import org.glavo.classfile.impl.BoundAttribute;
import org.glavo.classfile.impl.CodeImpl;
import org.glavo.classfile.impl.Util;

public final class VerificationWrapper {
    private final ClassModel clm;
    private final ConstantPoolWrapper cp;

    public VerificationWrapper(ClassModel clm) {
        this.clm = clm;
        this.cp = new ConstantPoolWrapper(clm.constantPool());
    }

    String thisClassName() {
        return this.clm.thisClass().asInternalName();
    }

    int majorVersion() {
        return this.clm.majorVersion();
    }

    String superclassName() {
        return this.clm.superclass().map(ClassEntry::asInternalName).orElse(null);
    }

    Iterable<String> interfaceNames() {
        return Util.mappedList(this.clm.interfaces(), ClassEntry::asInternalName);
    }

    Iterable<MethodWrapper> methods() {
        return this.clm.methods().stream().map(m -> new MethodWrapper((MethodModel)m)).toList();
    }

    boolean findField(String name, String sig) {
        for (FieldModel f : this.clm.fields()) {
            if (!f.fieldName().stringValue().equals(name) || !f.fieldType().stringValue().equals(sig)) continue;
            return true;
        }
        return false;
    }

    static class ConstantPoolWrapper {
        private final ConstantPool cp;

        ConstantPoolWrapper(ConstantPool cp) {
            this.cp = cp;
        }

        int entryCount() {
            return this.cp.size();
        }

        String classNameAt(int index) {
            return ((ClassEntry)this.cp.entryByIndex(index)).asInternalName();
        }

        String dynamicConstantSignatureAt(int index) {
            return ((DynamicConstantPoolEntry)this.cp.entryByIndex(index)).type().stringValue();
        }

        int tagAt(int index) {
            return this.cp.entryByIndex(index).tag();
        }

        private NameAndTypeEntry _refNameType(int index) {
            NameAndTypeEntry nameAndTypeEntry;
            PoolEntry e = this.cp.entryByIndex(index);
            if (e instanceof DynamicConstantPoolEntry) {
                DynamicConstantPoolEntry de = (DynamicConstantPoolEntry)e;
                nameAndTypeEntry = de.nameAndType();
            } else {
                nameAndTypeEntry = e != null ? ((MemberRefEntry)e).nameAndType() : null;
            }
            return nameAndTypeEntry;
        }

        String refNameAt(int index) {
            return this._refNameType(index).name().stringValue();
        }

        String refSignatureAt(int index) {
            return this._refNameType(index).type().stringValue();
        }

        int refClassIndexAt(int index) {
            return ((MemberRefEntry)this.cp.entryByIndex(index)).owner().index();
        }
    }

    class MethodWrapper {
        final MethodModel m;
        private final CodeImpl c;
        private final List<int[]> exc;

        MethodWrapper(MethodModel m) {
            this.m = m;
            this.c = m.code().orElse(null);
            this.exc = new LinkedList<int[]>();
            if (this.c != null) {
                this.c.iterateExceptionHandlers((start, end, handler, catchType) -> this.exc.add(new int[]{start, end, handler, catchType}));
            }
        }

        ConstantPoolWrapper constantPool() {
            return VerificationWrapper.this.cp;
        }

        boolean isNative() {
            return this.m.flags().has(AccessFlag.NATIVE);
        }

        boolean isAbstract() {
            return this.m.flags().has(AccessFlag.ABSTRACT);
        }

        boolean isBridge() {
            return this.m.flags().has(AccessFlag.BRIDGE);
        }

        boolean isStatic() {
            return this.m.flags().has(AccessFlag.STATIC);
        }

        String name() {
            return this.m.methodName().stringValue();
        }

        int maxStack() {
            return this.c == null ? 0 : this.c.maxStack();
        }

        int maxLocals() {
            return this.c == null ? 0 : this.c.maxLocals();
        }

        String descriptor() {
            return this.m.methodType().stringValue();
        }

        int codeLength() {
            return this.c == null ? 0 : this.c.codeLength();
        }

        byte[] codeArray() {
            return this.c == null ? null : this.c.codeArray();
        }

        List<int[]> exceptionTable() {
            return this.exc;
        }

        List<LocalVariableInfo> localVariableTable() {
            Optional<LocalVariableTableAttribute> attro = this.c.findAttribute(Attributes.LOCAL_VARIABLE_TABLE);
            return attro.map(lvta -> lvta.localVariables()).orElse(List.of());
        }

        byte[] stackMapTableRawData() {
            Optional<StackMapTableAttribute> attro = this.c.findAttribute(Attributes.STACK_MAP_TABLE);
            return attro.map(attr -> ((BoundAttribute)((Object)attr)).contents()).orElse(null);
        }
    }
}

