/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import java.lang.constant.ConstantDesc;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.TypeKind;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ConstantInstruction
extends Instruction {
    public ConstantDesc constantValue();

    public TypeKind typeKind();

    public static IntrinsicConstantInstruction ofIntrinsic(Opcode op) {
        Util.checkKind(op, Opcode.Kind.CONSTANT);
        if (op.constantValue() == null) {
            throw new IllegalArgumentException(String.format("Wrong opcode specified; found %s, expected xCONST_val", new Object[]{op}));
        }
        return new AbstractInstruction.UnboundIntrinsicConstantInstruction(op);
    }

    public static ArgumentConstantInstruction ofArgument(Opcode op, int value) {
        Util.checkKind(op, Opcode.Kind.CONSTANT);
        if (op != Opcode.BIPUSH && op != Opcode.SIPUSH) {
            throw new IllegalArgumentException(String.format("Wrong opcode specified; found %s, expected BIPUSH or SIPUSH", new Object[]{op}));
        }
        return new AbstractInstruction.UnboundArgumentConstantInstruction(op, value);
    }

    public static LoadConstantInstruction ofLoad(Opcode op, LoadableConstantEntry constant) {
        Util.checkKind(op, Opcode.Kind.CONSTANT);
        if (op != Opcode.LDC && op != Opcode.LDC_W && op != Opcode.LDC2_W) {
            throw new IllegalArgumentException(String.format("Wrong opcode specified; found %s, expected LDC, LDC_W or LDC2_W", new Object[]{op}));
        }
        return new AbstractInstruction.UnboundLoadConstantInstruction(op, constant);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LoadConstantInstruction
    extends ConstantInstruction {
        public LoadableConstantEntry constantEntry();

        @Override
        default public TypeKind typeKind() {
            return this.constantEntry().typeKind();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ArgumentConstantInstruction
    extends ConstantInstruction {
        @Override
        public Integer constantValue();

        @Override
        default public TypeKind typeKind() {
            return this.opcode().primaryTypeKind();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface IntrinsicConstantInstruction
    extends ConstantInstruction {
        @Override
        default public TypeKind typeKind() {
            return this.opcode().primaryTypeKind();
        }
    }
}

