/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import org.glavo.classfile.Instruction;
import org.glavo.classfile.Label;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DiscontinuedInstruction
extends Instruction {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RetInstruction
    extends DiscontinuedInstruction {
        public int slot();

        public static RetInstruction of(Opcode op, int slot) {
            Util.checkKind(op, Opcode.Kind.DISCONTINUED_RET);
            return new AbstractInstruction.UnboundRetInstruction(op, slot);
        }

        public static RetInstruction of(int slot) {
            return RetInstruction.of(slot < 256 ? Opcode.RET : Opcode.RET_W, slot);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JsrInstruction
    extends DiscontinuedInstruction {
        public Label target();

        public static JsrInstruction of(Opcode op, Label target) {
            Util.checkKind(op, Opcode.Kind.DISCONTINUED_JSR);
            return new AbstractInstruction.UnboundJsrInstruction(op, target);
        }

        public static JsrInstruction of(Label target) {
            return JsrInstruction.of(Opcode.JSR, target);
        }
    }
}

