/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import java.lang.constant.ClassDesc;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.Opcode;
import org.glavo.classfile.constantpool.ClassEntry;
import org.glavo.classfile.constantpool.FieldRefEntry;
import org.glavo.classfile.constantpool.NameAndTypeEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.TemporaryConstantPool;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface FieldInstruction
extends Instruction {
    public FieldRefEntry field();

    default public ClassEntry owner() {
        return this.field().owner();
    }

    default public Utf8Entry name() {
        return this.field().nameAndType().name();
    }

    default public Utf8Entry type() {
        return this.field().nameAndType().type();
    }

    default public ClassDesc typeSymbol() {
        return this.field().typeSymbol();
    }

    public static FieldInstruction of(Opcode op, FieldRefEntry field) {
        Util.checkKind(op, Opcode.Kind.FIELD_ACCESS);
        return new AbstractInstruction.UnboundFieldInstruction(op, field);
    }

    public static FieldInstruction of(Opcode op, ClassEntry owner, Utf8Entry name, Utf8Entry type) {
        return FieldInstruction.of(op, owner, TemporaryConstantPool.INSTANCE.nameAndTypeEntry(name, type));
    }

    public static FieldInstruction of(Opcode op, ClassEntry owner, NameAndTypeEntry nameAndType) {
        return FieldInstruction.of(op, TemporaryConstantPool.INSTANCE.fieldRefEntry(owner, nameAndType));
    }
}

