/*
 * Decompiled with CFR 0.152.
 */
package org.glavo.classfile.instruction;

import java.lang.constant.ConstantDesc;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.List;
import java.util.function.Function;
import org.glavo.classfile.Instruction;
import org.glavo.classfile.constantpool.InvokeDynamicEntry;
import org.glavo.classfile.constantpool.LoadableConstantEntry;
import org.glavo.classfile.constantpool.Utf8Entry;
import org.glavo.classfile.impl.AbstractInstruction;
import org.glavo.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InvokeDynamicInstruction
extends Instruction {
    public InvokeDynamicEntry invokedynamic();

    default public Utf8Entry name() {
        return this.invokedynamic().name();
    }

    default public Utf8Entry type() {
        return this.invokedynamic().type();
    }

    default public MethodTypeDesc typeSymbol() {
        return this.invokedynamic().typeSymbol();
    }

    default public DirectMethodHandleDesc bootstrapMethod() {
        return this.invokedynamic().bootstrap().bootstrapMethod().asSymbol();
    }

    default public List<ConstantDesc> bootstrapArgs() {
        return Util.mappedList(this.invokedynamic().bootstrap().arguments(), new Function<LoadableConstantEntry, ConstantDesc>(){

            @Override
            public ConstantDesc apply(LoadableConstantEntry loadableConstantEntry) {
                return loadableConstantEntry.constantValue();
            }
        });
    }

    public static InvokeDynamicInstruction of(InvokeDynamicEntry invokedynamic) {
        return new AbstractInstruction.UnboundInvokeDynamicInstruction(invokedynamic);
    }
}

