/*
 * Decompiled with CFR 0.152.
 */
package moe.yushi.authlibinjector.httpd;

import java.io.IOException;
import java.util.Optional;
import moe.yushi.authlibinjector.httpd.URLFilter;
import moe.yushi.authlibinjector.internal.fi.iki.elonen.IHTTPSession;
import moe.yushi.authlibinjector.internal.fi.iki.elonen.Response;
import moe.yushi.authlibinjector.internal.fi.iki.elonen.Status;

public class AntiFeaturesFilter
implements URLFilter {
    private static final String RESPONSE_PRIVILEGES = "{\"privileges\":{\"onlineChat\":{\"enabled\":true},\"multiplayerServer\":{\"enabled\":true},\"multiplayerRealms\":{\"enabled\":true},\"telemetry\":{\"enabled\":false}}}";
    private static final String RESPONSE_PLAYER_ATTRIBUTES = "{\"privileges\":{\"multiplayerRealms\":{\"enabled\":true},\"multiplayerServer\":{\"enabled\":true},\"onlineChat\":{\"enabled\":true},\"telemetry\":{\"enabled\":false}},\"profanityFilterPreferences\":{\"profanityFilterOn\":false}}";
    private static final String RESPONSE_PRIVACY_BLOCKLIST = "{\"blockedProfiles\":[]}";

    @Override
    public boolean canHandle(String domain) {
        return domain.equals("api.minecraftservices.com") || domain.equals("sessionserver.mojang.com");
    }

    @Override
    public Optional<Response> handle(String domain, String path, IHTTPSession session) throws IOException {
        if (domain.equals("api.minecraftservices.com") && path.equals("/privileges") && session.getMethod().equals("GET")) {
            return Optional.of(Response.newFixedLength(Status.OK, "application/json; charset=utf-8", RESPONSE_PRIVILEGES));
        }
        if (domain.equals("api.minecraftservices.com") && path.equals("/player/attributes") && session.getMethod().equals("GET")) {
            return Optional.of(Response.newFixedLength(Status.OK, "application/json; charset=utf-8", RESPONSE_PLAYER_ATTRIBUTES));
        }
        if (domain.equals("api.minecraftservices.com") && path.equals("/privacy/blocklist") && session.getMethod().equals("GET")) {
            return Optional.of(Response.newFixedLength(Status.OK, "application/json; charset=utf-8", RESPONSE_PRIVACY_BLOCKLIST));
        }
        if (domain.equals("sessionserver.mojang.com") && path.equals("/blockedservers") && session.getMethod().equals("GET")) {
            return Optional.of(Response.newFixedLength(Status.NOT_FOUND, "text/plain; charset=utf-8", ""));
        }
        return Optional.empty();
    }
}

