/*
 * Decompiled with CFR 0.152.
 */
package moe.yushi.authlibinjector.httpd;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Optional;
import moe.yushi.authlibinjector.httpd.URLFilter;
import moe.yushi.authlibinjector.internal.fi.iki.elonen.IHTTPSession;
import moe.yushi.authlibinjector.internal.fi.iki.elonen.Response;
import moe.yushi.authlibinjector.internal.fi.iki.elonen.Status;
import moe.yushi.authlibinjector.internal.org.json.simple.JSONArray;
import moe.yushi.authlibinjector.internal.org.json.simple.JSONObject;
import moe.yushi.authlibinjector.transform.support.YggdrasilKeyTransformUnit;

public class PublickeysFilter
implements URLFilter {
    @Override
    public boolean canHandle(String domain) {
        return domain.equals("api.minecraftservices.com");
    }

    @Override
    public Optional<Response> handle(String domain, String path, IHTTPSession session) throws IOException {
        if (domain.equals("api.minecraftservices.com") && path.equals("/publickeys") && session.getMethod().equals("GET")) {
            return Optional.of(Response.newFixedLength(Status.OK, "application/json; charset=utf-8", this.makePublickeysResponse().toJSONString()));
        }
        return Optional.empty();
    }

    private JSONObject makePublickeysResponse() {
        JSONObject response = new JSONObject();
        JSONArray profilePropertyKeys = new JSONArray();
        JSONArray playerCertificateKeys = new JSONArray();
        for (PublicKey key : YggdrasilKeyTransformUnit.PUBLIC_KEYS) {
            JSONObject entry = new JSONObject();
            entry.put("publicKey", Base64.getEncoder().encodeToString(key.getEncoded()));
            profilePropertyKeys.add(entry);
            playerCertificateKeys.add(entry);
        }
        response.put("profilePropertyKeys", profilePropertyKeys);
        response.put("playerCertificateKeys", playerCertificateKeys);
        return response;
    }
}

