/*
 * Decompiled with CFR 0.152.
 */
package moe.yushi.authlibinjector.transform.support;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.ClassVisitor;
import moe.yushi.authlibinjector.internal.org.objectweb.asm.MethodVisitor;
import moe.yushi.authlibinjector.transform.CallbackMethod;
import moe.yushi.authlibinjector.transform.TransformContext;
import moe.yushi.authlibinjector.transform.TransformUnit;
import moe.yushi.authlibinjector.util.IOUtils;
import moe.yushi.authlibinjector.util.KeyUtils;
import moe.yushi.authlibinjector.util.Logging;

public class YggdrasilKeyTransformUnit
implements TransformUnit {
    public static final List<PublicKey> PUBLIC_KEYS = new CopyOnWriteArrayList<PublicKey>();

    private static PublicKey loadMojangPublicKey() {
        PublicKey publicKey;
        block8: {
            InputStream in = YggdrasilKeyTransformUnit.class.getResourceAsStream("/mojang_publickey.der");
            try {
                publicKey = KeyUtils.parseX509PublicKey(IOUtils.asBytes(in));
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException("Failed to load Mojang public key", e);
                }
            }
            in.close();
        }
        return publicKey;
    }

    @CallbackMethod
    public static boolean verifyPropertySignature(Object propertyObj) {
        String propertyValue;
        String base64Signature;
        try {
            MethodHandle signatureHandle;
            MethodHandle valueHandle;
            try {
                valueHandle = MethodHandles.publicLookup().findVirtual(propertyObj.getClass(), "getValue", MethodType.methodType(String.class));
            }
            catch (NoSuchMethodException ignored) {
                valueHandle = MethodHandles.publicLookup().findVirtual(propertyObj.getClass(), "value", MethodType.methodType(String.class));
            }
            try {
                signatureHandle = MethodHandles.publicLookup().findVirtual(propertyObj.getClass(), "getSignature", MethodType.methodType(String.class));
            }
            catch (NoSuchMethodException ignored) {
                signatureHandle = MethodHandles.publicLookup().findVirtual(propertyObj.getClass(), "signature", MethodType.methodType(String.class));
            }
            base64Signature = (String)signatureHandle.invokeWithArguments(propertyObj);
            propertyValue = (String)valueHandle.invokeWithArguments(propertyObj);
        }
        catch (Throwable e) {
            Logging.log(Logging.Level.ERROR, "Failed to get property attributes", e);
            return false;
        }
        byte[] sig = Base64.getDecoder().decode(base64Signature);
        byte[] data = propertyValue.getBytes();
        for (PublicKey customKey : PUBLIC_KEYS) {
            try {
                Signature signature = Signature.getInstance("SHA1withRSA");
                signature.initVerify(customKey);
                signature.update(data);
                if (!signature.verify(sig)) continue;
                return true;
            }
            catch (GeneralSecurityException e) {
                Logging.log(Logging.Level.DEBUG, "Failed to verify signature with key " + customKey, e);
            }
        }
        Logging.log(Logging.Level.WARNING, "Failed to verify property signature");
        return false;
    }

    @CallbackMethod
    public static Signature createDummySignature() {
        Signature sig = new Signature("authlib-injector-dummy-verify"){

            @Override
            protected boolean engineVerify(byte[] sigBytes) {
                return true;
            }

            @Override
            protected void engineUpdate(byte[] b, int off, int len) {
            }

            @Override
            protected void engineUpdate(byte b) {
            }

            @Override
            protected byte[] engineSign() {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            protected void engineSetParameter(String param, Object value) {
            }

            @Override
            protected void engineInitVerify(PublicKey publicKey) {
            }

            @Override
            protected void engineInitSign(PrivateKey privateKey) {
                throw new UnsupportedOperationException();
            }

            @Override
            @Deprecated
            protected Object engineGetParameter(String param) {
                return null;
            }
        };
        try {
            sig.initVerify((PublicKey)null);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return sig;
    }

    @Override
    public Optional<ClassVisitor> transform(ClassLoader classLoader, String className, ClassVisitor writer, final TransformContext ctx) {
        if ("com.mojang.authlib.properties.Property".equals(className)) {
            return Optional.of(new ClassVisitor(589824, writer){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if ("isSignatureValid".equals(name) && "(Ljava/security/PublicKey;)Z".equals(desc)) {
                        ctx.markModified();
                        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                        mv.visitCode();
                        mv.visitVarInsn(25, 0);
                        ctx.invokeCallback(mv, YggdrasilKeyTransformUnit.class, "verifyPropertySignature");
                        mv.visitInsn(172);
                        mv.visitMaxs(-1, -1);
                        mv.visitEnd();
                        return null;
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            });
        }
        if ("com.mojang.authlib.yggdrasil.YggdrasilServicesKeyInfo".equals(className)) {
            return Optional.of(new ClassVisitor(589824, writer){

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if ("validateProperty".equals(name) && "(Lcom/mojang/authlib/properties/Property;)Z".equals(desc)) {
                        ctx.markModified();
                        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                        mv.visitCode();
                        mv.visitVarInsn(25, 1);
                        ctx.invokeCallback(mv, YggdrasilKeyTransformUnit.class, "verifyPropertySignature");
                        mv.visitInsn(172);
                        mv.visitMaxs(-1, -1);
                        mv.visitEnd();
                        return null;
                    }
                    if ("signature".equals(name) && "()Ljava/security/Signature;".equals(desc)) {
                        ctx.markModified();
                        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                        mv.visitCode();
                        ctx.invokeCallback(mv, YggdrasilKeyTransformUnit.class, "createDummySignature");
                        mv.visitInsn(176);
                        mv.visitMaxs(-1, -1);
                        mv.visitEnd();
                        return null;
                    }
                    return super.visitMethod(access, name, desc, signature, exceptions);
                }
            });
        }
        return Optional.empty();
    }

    public String toString() {
        return "Yggdrasil Public Key Transformer";
    }

    static {
        PUBLIC_KEYS.add(YggdrasilKeyTransformUnit.loadMojangPublicKey());
    }
}

