/*
 * Decompiled with CFR 0.152.
 */
package ca.weblite.nativeutils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class NativeUtils {
    private NativeUtils() {
    }

    public static void loadLibraryFromJar(String path) throws IOException {
        NativeUtils.loadLibraryFromJar(path, NativeUtils.class);
    }

    public static void loadLibraryFromJar(String path, Class<?> source) throws IOException, UnsatisfiedLinkError {
        System.load(NativeUtils.extractFromJar(path, source).toAbsolutePath().toString());
    }

    public static Path extractFromJar(String path, Class<?> source) throws IOException {
        String suffix;
        String prefix;
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String filename = path.substring(path.lastIndexOf(47) + 1);
        int lastDot = filename.lastIndexOf(46);
        if (lastDot == -1) {
            prefix = filename;
            suffix = null;
        } else {
            prefix = filename.substring(0, lastDot);
            suffix = filename.substring(lastDot);
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        Path temp = Files.createTempFile(prefix, suffix, new FileAttribute[0]);
        temp.toFile().deleteOnExit();
        try (InputStream is = source.getResourceAsStream(path);){
            if (is == null) {
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            try (OutputStream out = Files.newOutputStream(temp, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                int len;
                byte[] buffer = new byte[1024];
                while ((len = is.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
        }
        return temp;
    }
}

