/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.MapListenerHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;

public class ObservableMapWrapper<K, V>
implements ObservableMap<K, V> {
    private ObservableEntrySet entrySet;
    private ObservableKeySet keySet;
    private ObservableValues values;
    private MapListenerHelper<K, V> listenerHelper;
    private final Map<K, V> backingMap;

    public ObservableMapWrapper(Map<K, V> map) {
        this.backingMap = map;
    }

    protected void callObservers(MapChangeListener.Change<K, V> change) {
        MapListenerHelper.fireValueChangedEvent(this.listenerHelper, change);
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, listener);
    }

    @Override
    public void addListener(MapChangeListener<? super K, ? super V> observer) {
        this.listenerHelper = MapListenerHelper.addListener(this.listenerHelper, observer);
    }

    @Override
    public void removeListener(MapChangeListener<? super K, ? super V> observer) {
        this.listenerHelper = MapListenerHelper.removeListener(this.listenerHelper, observer);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        V ret;
        if (this.backingMap.containsKey(key)) {
            ret = this.backingMap.put(key, value);
            if (ret == null && value != null || ret != null && !ret.equals(value)) {
                this.callObservers(new SimpleChange(key, ret, value, true, true));
            }
        } else {
            ret = this.backingMap.put(key, value);
            this.callObservers(new SimpleChange(key, ret, value, true, false));
        }
        return ret;
    }

    @Override
    public V remove(Object key) {
        if (!this.backingMap.containsKey(key)) {
            return null;
        }
        V ret = this.backingMap.remove(key);
        this.callObservers(new SimpleChange(key, ret, null, false, true));
        return ret;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        Iterator<Map.Entry<K, V>> i = this.backingMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<K, V> e = i.next();
            K key = e.getKey();
            V val = e.getValue();
            i.remove();
            this.callObservers(new SimpleChange(key, val, null, false, true));
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new ObservableKeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new ObservableValues();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new ObservableEntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        return this.backingMap.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.backingMap.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.backingMap.hashCode();
    }

    private class ObservableEntrySet
    implements Set<Map.Entry<K, V>> {
        private ObservableEntrySet() {
        }

        @Override
        public int size() {
            return ObservableMapWrapper.this.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return ObservableMapWrapper.this.backingMap.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObservableMapWrapper.this.backingMap.entrySet().contains(o);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                private Iterator<Map.Entry<K, V>> backingIt;
                private K lastKey;
                private V lastValue;
                {
                    this.backingIt = ObservableMapWrapper.this.backingMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.backingIt.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    Map.Entry last = this.backingIt.next();
                    this.lastKey = last.getKey();
                    this.lastValue = last.getValue();
                    return new ObservableEntry(last);
                }

                @Override
                public void remove() {
                    this.backingIt.remove();
                    ObservableMapWrapper.this.callObservers(new SimpleChange(this.lastKey, this.lastValue, null, false, true));
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] array = ObservableMapWrapper.this.backingMap.entrySet().toArray();
            for (int i = 0; i < array.length; ++i) {
                array[i] = new ObservableEntry((Map.Entry)array[i]);
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = ObservableMapWrapper.this.backingMap.entrySet().toArray(a);
            for (int i = 0; i < array.length; ++i) {
                array[i] = new ObservableEntry((Map.Entry)array[i]);
            }
            return array;
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object o) {
            boolean ret = ObservableMapWrapper.this.backingMap.entrySet().remove(o);
            if (ret) {
                Map.Entry entry = (Map.Entry)o;
                ObservableMapWrapper.this.callObservers(new SimpleChange(entry.getKey(), entry.getValue(), null, false, true));
            }
            return ret;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ObservableMapWrapper.this.backingMap.entrySet().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.removeRetain(c, false);
        }

        private boolean removeRetain(Collection<?> c, boolean remove) {
            boolean removed = false;
            Iterator i = ObservableMapWrapper.this.backingMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (remove != c.contains(e)) continue;
                removed = true;
                Object key = e.getKey();
                Object value = e.getValue();
                i.remove();
                ObservableMapWrapper.this.callObservers(new SimpleChange(key, value, null, false, true));
            }
            return removed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.removeRetain(c, true);
        }

        @Override
        public void clear() {
            ObservableMapWrapper.this.clear();
        }

        public String toString() {
            return ObservableMapWrapper.this.backingMap.entrySet().toString();
        }

        @Override
        public boolean equals(Object obj) {
            return ObservableMapWrapper.this.backingMap.entrySet().equals(obj);
        }

        @Override
        public int hashCode() {
            return ObservableMapWrapper.this.backingMap.entrySet().hashCode();
        }
    }

    private class ObservableEntry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> backingEntry;

        public ObservableEntry(Map.Entry<K, V> backingEntry) {
            this.backingEntry = backingEntry;
        }

        @Override
        public K getKey() {
            return this.backingEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.backingEntry.getValue();
        }

        @Override
        public V setValue(V value) {
            Object oldValue = this.backingEntry.setValue(value);
            ObservableMapWrapper.this.callObservers(new SimpleChange(this.getKey(), oldValue, value, true, true));
            return oldValue;
        }

        @Override
        public final boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public final int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    private class ObservableValues
    implements Collection<V> {
        private ObservableValues() {
        }

        @Override
        public int size() {
            return ObservableMapWrapper.this.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return ObservableMapWrapper.this.backingMap.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObservableMapWrapper.this.backingMap.values().contains(o);
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                private Iterator<Map.Entry<K, V>> entryIt;
                private K lastKey;
                private V lastValue;
                {
                    this.entryIt = ObservableMapWrapper.this.backingMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIt.hasNext();
                }

                @Override
                public V next() {
                    Map.Entry last = this.entryIt.next();
                    this.lastKey = last.getKey();
                    this.lastValue = last.getValue();
                    return this.lastValue;
                }

                @Override
                public void remove() {
                    this.entryIt.remove();
                    ObservableMapWrapper.this.callObservers(new SimpleChange(this.lastKey, this.lastValue, null, false, true));
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ObservableMapWrapper.this.backingMap.values().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ObservableMapWrapper.this.backingMap.values().toArray(a);
        }

        @Override
        public boolean add(V e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object o) {
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (!i.next().equals(o)) continue;
                i.remove();
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ObservableMapWrapper.this.backingMap.values().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends V> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.removeRetain(c, true);
        }

        private boolean removeRetain(Collection<?> c, boolean remove) {
            boolean removed = false;
            Iterator i = ObservableMapWrapper.this.backingMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (remove != c.contains(e.getValue())) continue;
                removed = true;
                Object key = e.getKey();
                Object value = e.getValue();
                i.remove();
                ObservableMapWrapper.this.callObservers(new SimpleChange(key, value, null, false, true));
            }
            return removed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.removeRetain(c, false);
        }

        @Override
        public void clear() {
            ObservableMapWrapper.this.clear();
        }

        public String toString() {
            return ObservableMapWrapper.this.backingMap.values().toString();
        }

        @Override
        public boolean equals(Object obj) {
            return ObservableMapWrapper.this.backingMap.values().equals(obj);
        }

        @Override
        public int hashCode() {
            return ObservableMapWrapper.this.backingMap.values().hashCode();
        }
    }

    private class ObservableKeySet
    implements Set<K> {
        private ObservableKeySet() {
        }

        @Override
        public int size() {
            return ObservableMapWrapper.this.backingMap.size();
        }

        @Override
        public boolean isEmpty() {
            return ObservableMapWrapper.this.backingMap.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return ObservableMapWrapper.this.backingMap.keySet().contains(o);
        }

        @Override
        public Iterator<K> iterator() {
            return new Iterator<K>(){
                private Iterator<Map.Entry<K, V>> entryIt;
                private K lastKey;
                private V lastValue;
                {
                    this.entryIt = ObservableMapWrapper.this.backingMap.entrySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.entryIt.hasNext();
                }

                @Override
                public K next() {
                    Map.Entry last = this.entryIt.next();
                    this.lastKey = last.getKey();
                    this.lastValue = last.getValue();
                    return last.getKey();
                }

                @Override
                public void remove() {
                    this.entryIt.remove();
                    ObservableMapWrapper.this.callObservers(new SimpleChange(this.lastKey, this.lastValue, null, false, true));
                }
            };
        }

        @Override
        public Object[] toArray() {
            return ObservableMapWrapper.this.backingMap.keySet().toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return ObservableMapWrapper.this.backingMap.keySet().toArray(a);
        }

        @Override
        public boolean add(K e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object o) {
            return ObservableMapWrapper.this.remove(o) != null;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return ObservableMapWrapper.this.backingMap.keySet().containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends K> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.removeRetain(c, false);
        }

        private boolean removeRetain(Collection<?> c, boolean remove) {
            boolean removed = false;
            Iterator i = ObservableMapWrapper.this.backingMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry e = i.next();
                if (remove != c.contains(e.getKey())) continue;
                removed = true;
                Object key = e.getKey();
                Object value = e.getValue();
                i.remove();
                ObservableMapWrapper.this.callObservers(new SimpleChange(key, value, null, false, true));
            }
            return removed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.removeRetain(c, true);
        }

        @Override
        public void clear() {
            ObservableMapWrapper.this.clear();
        }

        public String toString() {
            return ObservableMapWrapper.this.backingMap.keySet().toString();
        }

        @Override
        public boolean equals(Object obj) {
            return ObservableMapWrapper.this.backingMap.keySet().equals(obj);
        }

        @Override
        public int hashCode() {
            return ObservableMapWrapper.this.backingMap.keySet().hashCode();
        }
    }

    private class SimpleChange
    extends MapChangeListener.Change<K, V> {
        private final K key;
        private final V old;
        private final V added;
        private final boolean wasAdded;
        private final boolean wasRemoved;

        public SimpleChange(K key, V old, V added, boolean wasAdded, boolean wasRemoved) {
            super(ObservableMapWrapper.this);
            assert (wasAdded || wasRemoved);
            this.key = key;
            this.old = old;
            this.added = added;
            this.wasAdded = wasAdded;
            this.wasRemoved = wasRemoved;
        }

        @Override
        public boolean wasAdded() {
            return this.wasAdded;
        }

        @Override
        public boolean wasRemoved() {
            return this.wasRemoved;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValueAdded() {
            return this.added;
        }

        @Override
        public V getValueRemoved() {
            return this.old;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.wasAdded) {
                if (this.wasRemoved) {
                    builder.append(this.old).append(" replaced by ").append(this.added);
                } else {
                    builder.append(this.added).append(" added");
                }
            } else {
                builder.append(this.old).append(" removed");
            }
            builder.append(" at key ").append(this.key);
            return builder.toString();
        }
    }
}

