/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging.jfr;

import com.sun.javafx.logging.Logger;
import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.logging.jfr.JFRInputEvent;
import com.sun.javafx.logging.jfr.JFRPulsePhaseEvent;
import jdk.jfr.FlightRecorder;

public final class JFRPulseLogger
extends Logger {
    private final ThreadLocal<JFRPulsePhaseEvent> currentPulsePhaseEvent;
    private final ThreadLocal<JFRInputEvent> currentInputEvent;
    private int pulseNumber;
    private int fxPulseNumber;
    private int renderPulseNumber;
    private Thread fxThread;

    public static Logger createInstance() {
        if (FlightRecorder.isInitialized() || PulseLogger.isPulseLoggingRequested()) {
            return new JFRPulseLogger();
        }
        return null;
    }

    private JFRPulseLogger() {
        FlightRecorder.register(JFRInputEvent.class);
        FlightRecorder.register(JFRPulsePhaseEvent.class);
        this.currentPulsePhaseEvent = new ThreadLocal<JFRPulsePhaseEvent>(){

            @Override
            public JFRPulsePhaseEvent initialValue() {
                return new JFRPulsePhaseEvent();
            }
        };
        this.currentInputEvent = new ThreadLocal<JFRInputEvent>(){

            @Override
            public JFRInputEvent initialValue() {
                return new JFRInputEvent();
            }
        };
    }

    @Override
    public void pulseStart() {
        ++this.pulseNumber;
        this.fxPulseNumber = this.pulseNumber;
        if (this.fxThread == null) {
            this.fxThread = Thread.currentThread();
        }
        this.newPhase("Pulse start");
    }

    @Override
    public void pulseEnd() {
        this.newPhase(null);
        this.fxPulseNumber = 0;
    }

    @Override
    public void renderStart() {
        this.renderPulseNumber = this.fxPulseNumber;
    }

    @Override
    public void renderEnd() {
        this.newPhase(null);
        this.renderPulseNumber = 0;
    }

    @Override
    public void newPhase(String phaseName) {
        JFRPulsePhaseEvent event = this.currentPulsePhaseEvent.get();
        if (!event.isEnabled()) {
            event.setPhaseName(null);
            return;
        }
        if (event.getPhaseName() != null) {
            event.commit();
        }
        if (phaseName == null) {
            event.setPhaseName(null);
            return;
        }
        event = new JFRPulsePhaseEvent();
        event.begin();
        event.setPhaseName(phaseName);
        event.setPulseId(Thread.currentThread() == this.fxThread ? this.fxPulseNumber : this.renderPulseNumber);
        this.currentPulsePhaseEvent.set(event);
    }

    @Override
    public void newInput(String input) {
        JFRInputEvent event = this.currentInputEvent.get();
        if (!event.isEnabled()) {
            event.setInput(null);
            return;
        }
        if (event.getInput() != null) {
            event.commit();
        }
        if (input == null) {
            event.setInput(null);
            return;
        }
        event = new JFRInputEvent();
        event.begin();
        event.setInput(input);
        this.currentInputEvent.set(event);
    }
}

