/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.Properties;

public class PlatformUtil {
    private static final String os;
    private static final String version;
    private static final boolean embedded;
    private static final String embeddedType;
    private static final boolean useEGL;
    private static final boolean doEGLCompositing;
    private static String javafxPlatform;
    private static final boolean ANDROID;
    private static final boolean WINDOWS;
    private static final boolean WINDOWS_VISTA_OR_LATER;
    private static final boolean WINDOWS_7_OR_LATER;
    private static final boolean MAC;
    private static final boolean LINUX;
    private static final boolean SOLARIS;
    private static final boolean IOS;
    private static final boolean STATIC_BUILD;

    private static boolean versionNumberGreaterThanOrEqualTo(float value) {
        try {
            return Float.parseFloat(version) >= value;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWindows() {
        return WINDOWS;
    }

    public static boolean isWinVistaOrLater() {
        return WINDOWS_VISTA_OR_LATER;
    }

    public static boolean isWin7OrLater() {
        return WINDOWS_7_OR_LATER;
    }

    public static boolean isMac() {
        return MAC;
    }

    public static boolean isLinux() {
        return LINUX;
    }

    public static boolean useEGL() {
        return useEGL;
    }

    public static boolean useEGLWindowComposition() {
        return doEGLCompositing;
    }

    public static boolean useGLES2() {
        String useGles2 = AccessController.doPrivileged(() -> System.getProperty("use.gles2"));
        return "true".equals(useGles2);
    }

    public static boolean isSolaris() {
        return SOLARIS;
    }

    public static boolean isUnix() {
        return LINUX || SOLARIS;
    }

    public static boolean isEmbedded() {
        return embedded;
    }

    public static String getEmbeddedType() {
        return embeddedType;
    }

    public static boolean isIOS() {
        return IOS;
    }

    public static boolean isStaticBuild() {
        return STATIC_BUILD;
    }

    private static void loadPropertiesFromFile(File file) {
        Properties p = new Properties();
        try {
            FileInputStream in = new FileInputStream(file);
            p.load(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (javafxPlatform == null) {
            javafxPlatform = p.getProperty("javafx.platform");
        }
        String prefix = javafxPlatform + ".";
        int prefixLength = prefix.length();
        boolean foundPlatform = false;
        for (Object o : p.keySet()) {
            String key = (String)o;
            if (!key.startsWith(prefix)) continue;
            foundPlatform = true;
            String systemKey = key.substring(prefixLength);
            if (System.getProperty(systemKey) != null) continue;
            String value = p.getProperty(key);
            System.setProperty(systemKey, value);
        }
        if (!foundPlatform) {
            System.err.println("Warning: No settings found for javafx.platform='" + javafxPlatform + "'");
        }
    }

    private static File getRTDir() {
        try {
            String theClassFile = "PlatformUtil.class";
            Class<PlatformUtil> theClass = PlatformUtil.class;
            URL url = theClass.getResource(theClassFile);
            if (url == null) {
                return null;
            }
            String classUrlString = url.toString();
            if (!classUrlString.startsWith("jar:file:") || classUrlString.indexOf(33) == -1) {
                return null;
            }
            String s = classUrlString.substring(4, classUrlString.lastIndexOf(33));
            int lastIndexOfSlash = Math.max(s.lastIndexOf(47), s.lastIndexOf(92));
            return new File(new URL(s.substring(0, lastIndexOfSlash + 1)).getPath());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static void loadProperties() {
        String vmname = System.getProperty("java.vm.name");
        String arch = System.getProperty("os.arch");
        if (!(javafxPlatform != null || arch != null && arch.equals("arm") || vmname != null && vmname.indexOf("Embedded") > 0)) {
            return;
        }
        AccessController.doPrivileged(() -> {
            File rtDir = PlatformUtil.getRTDir();
            String propertyFilename = "javafx.platform.properties";
            File rtProperties = new File(rtDir, "javafx.platform.properties");
            if (rtProperties.exists()) {
                PlatformUtil.loadPropertiesFromFile(rtProperties);
                return null;
            }
            String javaHome = System.getProperty("java.home");
            File javaHomeProperties = new File(javaHome, "lib" + File.separator + "javafx.platform.properties");
            if (javaHomeProperties.exists()) {
                PlatformUtil.loadPropertiesFromFile(javaHomeProperties);
                return null;
            }
            String javafxRuntimePath = System.getProperty("javafx.runtime.path");
            File javafxRuntimePathProperties = new File(javafxRuntimePath, File.separator + "javafx.platform.properties");
            if (javafxRuntimePathProperties.exists()) {
                PlatformUtil.loadPropertiesFromFile(javafxRuntimePathProperties);
                return null;
            }
            return null;
        });
    }

    public static boolean isAndroid() {
        return ANDROID;
    }

    static {
        boolean bool3;
        boolean bool2;
        String str2;
        boolean bool1;
        String str1;
        os = System.getProperty("os.name");
        version = System.getProperty("os.version");
        javafxPlatform = str1 = AccessController.doPrivileged(() -> System.getProperty("javafx.platform"));
        PlatformUtil.loadProperties();
        embedded = bool1 = AccessController.doPrivileged(() -> Boolean.getBoolean("com.sun.javafx.isEmbedded")).booleanValue();
        embeddedType = str2 = AccessController.doPrivileged(() -> System.getProperty("embedded"));
        useEGL = bool2 = AccessController.doPrivileged(() -> Boolean.getBoolean("use.egl")).booleanValue();
        doEGLCompositing = useEGL ? (bool3 = AccessController.doPrivileged(() -> Boolean.getBoolean("doNativeComposite")).booleanValue()) : false;
        ANDROID = "android".equals(javafxPlatform) || "Dalvik".equals(System.getProperty("java.vm.name"));
        WINDOWS = os.startsWith("Windows");
        WINDOWS_VISTA_OR_LATER = WINDOWS && PlatformUtil.versionNumberGreaterThanOrEqualTo(6.0f);
        WINDOWS_7_OR_LATER = WINDOWS && PlatformUtil.versionNumberGreaterThanOrEqualTo(6.1f);
        MAC = os.startsWith("Mac");
        LINUX = os.startsWith("Linux") && !ANDROID;
        SOLARIS = os.startsWith("SunOS");
        IOS = os.startsWith("iOS");
        STATIC_BUILD = "Substrate VM".equals(System.getProperty("java.vm.name"));
    }
}

