/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.ExpressionHelperBase;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SourceAdapterChange;
import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableListValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class ListExpressionHelper<E>
extends ExpressionHelperBase {
    protected final ObservableListValue<E> observable;

    public static <E> ListExpressionHelper<E> addListener(ListExpressionHelper<E> helper, ObservableListValue<E> observable, InvalidationListener listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        observable.getValue();
        return helper == null ? new SingleInvalidation<E>(observable, listener) : helper.addListener(listener);
    }

    public static <E> ListExpressionHelper<E> removeListener(ListExpressionHelper<E> helper, InvalidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <E> ListExpressionHelper<E> addListener(ListExpressionHelper<E> helper, ObservableListValue<E> observable, ChangeListener<? super ObservableList<E>> listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? new SingleChange<E>(observable, listener) : helper.addListener(listener);
    }

    public static <E> ListExpressionHelper<E> removeListener(ListExpressionHelper<E> helper, ChangeListener<? super ObservableList<E>> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <E> ListExpressionHelper<E> addListener(ListExpressionHelper<E> helper, ObservableListValue<E> observable, ListChangeListener<? super E> listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? new SingleListChange<E>(observable, listener) : helper.addListener(listener);
    }

    public static <E> ListExpressionHelper<E> removeListener(ListExpressionHelper<E> helper, ListChangeListener<? super E> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <E> void fireValueChangedEvent(ListExpressionHelper<E> helper) {
        if (helper != null) {
            helper.fireValueChangedEvent();
        }
    }

    public static <E> void fireValueChangedEvent(ListExpressionHelper<E> helper, ListChangeListener.Change<? extends E> change) {
        if (helper != null) {
            helper.fireValueChangedEvent(change);
        }
    }

    protected ListExpressionHelper(ObservableListValue<E> observable) {
        this.observable = observable;
    }

    protected abstract ListExpressionHelper<E> addListener(InvalidationListener var1);

    protected abstract ListExpressionHelper<E> removeListener(InvalidationListener var1);

    protected abstract ListExpressionHelper<E> addListener(ChangeListener<? super ObservableList<E>> var1);

    protected abstract ListExpressionHelper<E> removeListener(ChangeListener<? super ObservableList<E>> var1);

    protected abstract ListExpressionHelper<E> addListener(ListChangeListener<? super E> var1);

    protected abstract ListExpressionHelper<E> removeListener(ListChangeListener<? super E> var1);

    protected abstract void fireValueChangedEvent();

    protected abstract void fireValueChangedEvent(ListChangeListener.Change<? extends E> var1);

    private static class SingleInvalidation<E>
    extends ListExpressionHelper<E> {
        private final InvalidationListener listener;

        private SingleInvalidation(ObservableListValue<E> observable, InvalidationListener listener) {
            super(observable);
            this.listener = listener;
        }

        @Override
        protected ListExpressionHelper<E> addListener(InvalidationListener listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(InvalidationListener listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ChangeListener<? super ObservableList<E>> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ChangeListener<? super ObservableList<E>> listener) {
            return this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ListChangeListener<? super E> listener) {
            return new Generic<E>(this.observable, this.listener, listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ListChangeListener<? super E> listener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            this.listener.invalidated(this.observable);
        }

        @Override
        protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
            this.listener.invalidated(this.observable);
        }
    }

    private static class SingleChange<E>
    extends ListExpressionHelper<E> {
        private final ChangeListener<? super ObservableList<E>> listener;
        private ObservableList<E> currentValue;

        private SingleChange(ObservableListValue<E> observable, ChangeListener<? super ObservableList<E>> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = (ObservableList)observable.getValue();
        }

        @Override
        protected ListExpressionHelper<E> addListener(InvalidationListener listener) {
            return new Generic(this.observable, listener, this.listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ChangeListener<? super ObservableList<E>> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ChangeListener<? super ObservableList<E>> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ListChangeListener<? super E> listener) {
            return new Generic<E>(this.observable, this.listener, listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ListChangeListener<? super E> listener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            ObservableList<E> oldValue = this.currentValue;
            this.currentValue = (ObservableList)this.observable.getValue();
            if (this.currentValue != oldValue) {
                this.listener.changed(this.observable, oldValue, this.currentValue);
            }
        }

        @Override
        protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
            this.listener.changed(this.observable, this.currentValue, this.currentValue);
        }
    }

    private static class SingleListChange<E>
    extends ListExpressionHelper<E> {
        private final ListChangeListener<? super E> listener;
        private ObservableList<E> currentValue;

        private SingleListChange(ObservableListValue<E> observable, ListChangeListener<? super E> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = (ObservableList)observable.getValue();
        }

        @Override
        protected ListExpressionHelper<E> addListener(InvalidationListener listener) {
            return new Generic<E>(this.observable, listener, this.listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ChangeListener<? super ObservableList<E>> listener) {
            return new Generic<E>(this.observable, listener, this.listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ChangeListener<? super ObservableList<E>> listener) {
            return this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ListChangeListener<? super E> listener) {
            return new Generic<E>(this.observable, this.listener, listener);
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ListChangeListener<? super E> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChangedEvent() {
            ObservableList<E> oldValue = this.currentValue;
            this.currentValue = (ObservableList)this.observable.getValue();
            if (this.currentValue != oldValue) {
                int safeSize = this.currentValue == null ? 0 : this.currentValue.size();
                ObservableList safeOldValue = oldValue == null ? FXCollections.emptyObservableList() : FXCollections.unmodifiableObservableList(oldValue);
                NonIterableChange.GenericAddRemoveChange change = new NonIterableChange.GenericAddRemoveChange(0, safeSize, safeOldValue, this.observable);
                this.listener.onChanged(change);
            }
        }

        @Override
        protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
            this.listener.onChanged(new SourceAdapterChange<E>(this.observable, change));
        }
    }

    private static class Generic<E>
    extends ListExpressionHelper<E> {
        private InvalidationListener[] invalidationListeners;
        private ChangeListener<? super ObservableList<E>>[] changeListeners;
        private ListChangeListener<? super E>[] listChangeListeners;
        private int invalidationSize;
        private int changeSize;
        private int listChangeSize;
        private boolean locked;
        private ObservableList<E> currentValue;

        private Generic(ObservableListValue<E> observable, InvalidationListener listener0, InvalidationListener listener1) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{listener0, listener1};
            this.invalidationSize = 2;
        }

        private Generic(ObservableListValue<E> observable, ChangeListener<? super ObservableList<E>> listener0, ChangeListener<? super ObservableList<E>> listener1) {
            super(observable);
            this.changeListeners = new ChangeListener[]{listener0, listener1};
            this.changeSize = 2;
            this.currentValue = (ObservableList)observable.getValue();
        }

        private Generic(ObservableListValue<E> observable, ListChangeListener<? super E> listener0, ListChangeListener<? super E> listener1) {
            super(observable);
            this.listChangeListeners = new ListChangeListener[]{listener0, listener1};
            this.listChangeSize = 2;
            this.currentValue = (ObservableList)observable.getValue();
        }

        private Generic(ObservableListValue<E> observable, InvalidationListener invalidationListener, ChangeListener<? super ObservableList<E>> changeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.currentValue = (ObservableList)observable.getValue();
        }

        private Generic(ObservableListValue<E> observable, InvalidationListener invalidationListener, ListChangeListener<? super E> listChangeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.listChangeListeners = new ListChangeListener[]{listChangeListener};
            this.listChangeSize = 1;
            this.currentValue = (ObservableList)observable.getValue();
        }

        private Generic(ObservableListValue<E> observable, ChangeListener<? super ObservableList<E>> changeListener, ListChangeListener<? super E> listChangeListener) {
            super(observable);
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.listChangeListeners = new ListChangeListener[]{listChangeListener};
            this.listChangeSize = 1;
            this.currentValue = (ObservableList)observable.getValue();
        }

        @Override
        protected ListExpressionHelper<E> addListener(InvalidationListener listener) {
            if (this.invalidationListeners == null) {
                this.invalidationListeners = new InvalidationListener[]{listener};
                this.invalidationSize = 1;
            } else {
                int oldCapacity = this.invalidationListeners.length;
                if (this.locked) {
                    int newCapacity = this.invalidationSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                } else if (this.invalidationSize == oldCapacity) {
                    this.invalidationSize = Generic.trim(this.invalidationSize, this.invalidationListeners);
                    if (this.invalidationSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                    }
                }
                this.invalidationListeners[this.invalidationSize++] = listener;
            }
            return this;
        }

        @Override
        protected ListExpressionHelper<E> removeListener(InvalidationListener listener) {
            if (this.invalidationListeners != null) {
                for (int index = 0; index < this.invalidationSize; ++index) {
                    if (!listener.equals(this.invalidationListeners[index])) continue;
                    if (this.invalidationSize == 1) {
                        if (this.changeSize == 1 && this.listChangeSize == 0) {
                            return new SingleChange(this.observable, this.changeListeners[0]);
                        }
                        if (this.changeSize == 0 && this.listChangeSize == 1) {
                            return new SingleListChange<E>(this.observable, this.listChangeListeners[0]);
                        }
                        this.invalidationListeners = null;
                        this.invalidationSize = 0;
                        break;
                    }
                    if (this.invalidationSize == 2 && this.changeSize == 0 && this.listChangeSize == 0) {
                        return new SingleInvalidation(this.observable, this.invalidationListeners[1 - index]);
                    }
                    int numMoved = this.invalidationSize - index - 1;
                    InvalidationListener[] oldListeners = this.invalidationListeners;
                    if (this.locked) {
                        this.invalidationListeners = new InvalidationListener[this.invalidationListeners.length];
                        System.arraycopy(oldListeners, 0, this.invalidationListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.invalidationListeners, index, numMoved);
                    }
                    --this.invalidationSize;
                    if (this.locked) break;
                    this.invalidationListeners[this.invalidationSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ChangeListener<? super ObservableList<E>> listener) {
            if (this.changeListeners == null) {
                this.changeListeners = new ChangeListener[]{listener};
                this.changeSize = 1;
            } else {
                int oldCapacity = this.changeListeners.length;
                if (this.locked) {
                    int newCapacity = this.changeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                } else if (this.changeSize == oldCapacity) {
                    this.changeSize = Generic.trim(this.changeSize, this.changeListeners);
                    if (this.changeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                    }
                }
                this.changeListeners[this.changeSize++] = listener;
            }
            if (this.changeSize == 1) {
                this.currentValue = (ObservableList)this.observable.getValue();
            }
            return this;
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ChangeListener<? super ObservableList<E>> listener) {
            if (this.changeListeners != null) {
                for (int index = 0; index < this.changeSize; ++index) {
                    if (!listener.equals(this.changeListeners[index])) continue;
                    if (this.changeSize == 1) {
                        if (this.invalidationSize == 1 && this.listChangeSize == 0) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        if (this.invalidationSize == 0 && this.listChangeSize == 1) {
                            return new SingleListChange<E>(this.observable, this.listChangeListeners[0]);
                        }
                        this.changeListeners = null;
                        this.changeSize = 0;
                        break;
                    }
                    if (this.changeSize == 2 && this.invalidationSize == 0 && this.listChangeSize == 0) {
                        return new SingleChange(this.observable, this.changeListeners[1 - index]);
                    }
                    int numMoved = this.changeSize - index - 1;
                    ChangeListener<? super ObservableList<E>>[] oldListeners = this.changeListeners;
                    if (this.locked) {
                        this.changeListeners = new ChangeListener[this.changeListeners.length];
                        System.arraycopy(oldListeners, 0, this.changeListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.changeListeners, index, numMoved);
                    }
                    --this.changeSize;
                    if (this.locked) break;
                    this.changeListeners[this.changeSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected ListExpressionHelper<E> addListener(ListChangeListener<? super E> listener) {
            if (this.listChangeListeners == null) {
                this.listChangeListeners = new ListChangeListener[]{listener};
                this.listChangeSize = 1;
            } else {
                int oldCapacity = this.listChangeListeners.length;
                if (this.locked) {
                    int newCapacity = this.listChangeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.listChangeListeners = Arrays.copyOf(this.listChangeListeners, newCapacity);
                } else if (this.listChangeSize == oldCapacity) {
                    this.listChangeSize = Generic.trim(this.listChangeSize, this.listChangeListeners);
                    if (this.listChangeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.listChangeListeners = Arrays.copyOf(this.listChangeListeners, newCapacity);
                    }
                }
                this.listChangeListeners[this.listChangeSize++] = listener;
            }
            if (this.listChangeSize == 1) {
                this.currentValue = (ObservableList)this.observable.getValue();
            }
            return this;
        }

        @Override
        protected ListExpressionHelper<E> removeListener(ListChangeListener<? super E> listener) {
            if (this.listChangeListeners != null) {
                for (int index = 0; index < this.listChangeSize; ++index) {
                    if (!listener.equals(this.listChangeListeners[index])) continue;
                    if (this.listChangeSize == 1) {
                        if (this.invalidationSize == 1 && this.changeSize == 0) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        if (this.invalidationSize == 0 && this.changeSize == 1) {
                            return new SingleChange(this.observable, this.changeListeners[0]);
                        }
                        this.listChangeListeners = null;
                        this.listChangeSize = 0;
                        break;
                    }
                    if (this.listChangeSize == 2 && this.invalidationSize == 0 && this.changeSize == 0) {
                        return new SingleListChange<E>(this.observable, this.listChangeListeners[1 - index]);
                    }
                    int numMoved = this.listChangeSize - index - 1;
                    ListChangeListener<? super E>[] oldListeners = this.listChangeListeners;
                    if (this.locked) {
                        this.listChangeListeners = new ListChangeListener[this.listChangeListeners.length];
                        System.arraycopy(oldListeners, 0, this.listChangeListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.listChangeListeners, index, numMoved);
                    }
                    --this.listChangeSize;
                    if (this.locked) break;
                    this.listChangeListeners[this.listChangeSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            if (this.changeSize == 0 && this.listChangeSize == 0) {
                this.notifyListeners(this.currentValue, null, false);
            } else {
                ObservableList<E> oldValue = this.currentValue;
                this.currentValue = (ObservableList)this.observable.getValue();
                if (this.currentValue != oldValue) {
                    NonIterableChange.GenericAddRemoveChange change = null;
                    if (this.listChangeSize > 0) {
                        int safeSize = this.currentValue == null ? 0 : this.currentValue.size();
                        ObservableList safeOldValue = oldValue == null ? FXCollections.emptyObservableList() : FXCollections.unmodifiableObservableList(oldValue);
                        change = new NonIterableChange.GenericAddRemoveChange(0, safeSize, safeOldValue, this.observable);
                    }
                    this.notifyListeners(oldValue, change, false);
                } else {
                    this.notifyListeners(this.currentValue, null, true);
                }
            }
        }

        @Override
        protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
            SourceAdapterChange<? extends E> mappedChange = this.listChangeSize == 0 ? null : new SourceAdapterChange<E>(this.observable, change);
            this.notifyListeners(this.currentValue, mappedChange, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(ObservableList<E> oldValue, ListChangeListener.Change<E> change, boolean noChange) {
            InvalidationListener[] curInvalidationList = this.invalidationListeners;
            int curInvalidationSize = this.invalidationSize;
            ChangeListener<? super ObservableList<E>>[] curChangeList = this.changeListeners;
            int curChangeSize = this.changeSize;
            ListChangeListener<? super E>[] curListChangeList = this.listChangeListeners;
            int curListChangeSize = this.listChangeSize;
            try {
                int i;
                this.locked = true;
                for (i = 0; i < curInvalidationSize; ++i) {
                    curInvalidationList[i].invalidated(this.observable);
                }
                if (!noChange) {
                    for (i = 0; i < curChangeSize; ++i) {
                        curChangeList[i].changed(this.observable, oldValue, this.currentValue);
                    }
                    if (change != null) {
                        for (i = 0; i < curListChangeSize; ++i) {
                            change.reset();
                            curListChangeList[i].onChanged(change);
                        }
                    }
                }
            }
            finally {
                this.locked = false;
            }
        }
    }
}

