/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.ListListenerHelper;
import com.sun.javafx.collections.SourceAdapterChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public abstract class VetoableListDecorator<E>
implements ObservableList<E> {
    private final ObservableList<E> list;
    private int modCount;
    private ListListenerHelper<E> helper;

    protected abstract void onProposedChange(List<E> var1, int ... var2);

    public VetoableListDecorator(ObservableList<E> decorated) {
        this.list = decorated;
        this.list.addListener((ListChangeListener.Change<? super E> c) -> ListListenerHelper.fireValueChangedEvent(this.helper, new SourceAdapterChange(this, c)));
    }

    @Override
    public void addListener(ListChangeListener<? super E> listener) {
        this.helper = ListListenerHelper.addListener(this.helper, listener);
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listener) {
        this.helper = ListListenerHelper.removeListener(this.helper, listener);
    }

    @Override
    public void addListener(InvalidationListener listener) {
        this.helper = ListListenerHelper.addListener(this.helper, listener);
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        this.helper = ListListenerHelper.removeListener(this.helper, listener);
    }

    @Override
    public boolean addAll(E ... elements) {
        return this.addAll((Collection<? extends E>)Arrays.asList(elements));
    }

    @Override
    public boolean setAll(E ... elements) {
        return this.setAll((Collection<? extends E>)Arrays.asList(elements));
    }

    @Override
    public boolean setAll(Collection<? extends E> col) {
        this.onProposedChange(Collections.unmodifiableList(new ArrayList<E>(col)), 0, this.size());
        try {
            ++this.modCount;
            return this.list.setAll(col);
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    private void removeFromList(List<E> backingList, int offset, Collection<?> col, boolean complement) {
        int[] toBeRemoved = new int[2];
        int pointer = -1;
        for (int i = 0; i < backingList.size(); ++i) {
            E el = backingList.get(i);
            if (!(col.contains(el) ^ complement)) continue;
            if (pointer == -1) {
                toBeRemoved[pointer + 1] = offset + i;
                toBeRemoved[pointer + 2] = offset + i + 1;
                pointer += 2;
                continue;
            }
            if (toBeRemoved[pointer - 1] == offset + i) {
                toBeRemoved[pointer - 1] = offset + i + 1;
                continue;
            }
            int[] tmp = new int[toBeRemoved.length + 2];
            System.arraycopy(toBeRemoved, 0, tmp, 0, toBeRemoved.length);
            toBeRemoved = tmp;
            toBeRemoved[pointer + 1] = offset + i;
            toBeRemoved[pointer + 2] = offset + i + 1;
            pointer += 2;
        }
        if (pointer != -1) {
            this.onProposedChange(Collections.emptyList(), toBeRemoved);
        }
    }

    @Override
    public boolean removeAll(E ... elements) {
        return this.removeAll((Collection<?>)Arrays.asList(elements));
    }

    @Override
    public boolean retainAll(E ... elements) {
        return this.retainAll((Collection<?>)Arrays.asList(elements));
    }

    @Override
    public void remove(int from, int to) {
        this.onProposedChange(Collections.emptyList(), from, to);
        try {
            ++this.modCount;
            this.list.remove(from, to);
        }
        catch (Exception e) {
            --this.modCount;
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new VetoableIteratorDecorator(new ModCountAccessorImpl(), this.list.iterator(), 0);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.onProposedChange(Collections.singletonList(e), this.size(), this.size());
        try {
            ++this.modCount;
            this.list.add(e);
            return true;
        }
        catch (Exception ex) {
            --this.modCount;
            throw ex;
        }
    }

    @Override
    public boolean remove(Object o) {
        int i = this.list.indexOf(o);
        if (i != -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.onProposedChange(Collections.unmodifiableList(new ArrayList<E>(c)), this.size(), this.size());
        try {
            ++this.modCount;
            boolean ret = this.list.addAll(c);
            if (!ret) {
                --this.modCount;
            }
            return ret;
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.onProposedChange(Collections.unmodifiableList(new ArrayList<E>(c)), index, index);
        try {
            ++this.modCount;
            boolean ret = this.list.addAll(index, c);
            if (!ret) {
                --this.modCount;
            }
            return ret;
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.removeFromList(this, 0, c, false);
        try {
            ++this.modCount;
            boolean ret = this.list.removeAll(c);
            if (!ret) {
                --this.modCount;
            }
            return ret;
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.removeFromList(this, 0, c, true);
        try {
            ++this.modCount;
            boolean ret = this.list.retainAll(c);
            if (!ret) {
                --this.modCount;
            }
            return ret;
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public void clear() {
        this.onProposedChange(Collections.emptyList(), 0, this.size());
        try {
            ++this.modCount;
            this.list.clear();
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        this.onProposedChange(Collections.singletonList(element), index, index + 1);
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.onProposedChange(Collections.singletonList(element), index, index);
        try {
            ++this.modCount;
            this.list.add(index, element);
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public E remove(int index) {
        this.onProposedChange(Collections.emptyList(), index, index + 1);
        try {
            ++this.modCount;
            Object ret = this.list.remove(index);
            return ret;
        }
        catch (Exception e) {
            --this.modCount;
            throw e;
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new VetoableListIteratorDecorator((ModCountAccessor)new ModCountAccessorImpl(), this.list.listIterator(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new VetoableListIteratorDecorator((ModCountAccessor)new ModCountAccessorImpl(), this.list.listIterator(index), index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new VetoableSubListDecorator(new ModCountAccessorImpl(), this.list.subList(fromIndex, toIndex), fromIndex);
    }

    public String toString() {
        return this.list.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return this.list.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.list.hashCode();
    }

    private class VetoableIteratorDecorator
    implements Iterator<E> {
        private final Iterator<E> it;
        private final ModCountAccessor modCountAccessor;
        private int modCount;
        protected final int offset;
        protected int cursor;
        protected int lastReturned;

        public VetoableIteratorDecorator(ModCountAccessor modCountAccessor, Iterator<E> it, int offset) {
            this.modCountAccessor = modCountAccessor;
            this.modCount = modCountAccessor.get();
            this.it = it;
            this.offset = offset;
        }

        @Override
        public boolean hasNext() {
            this.checkForComodification();
            return this.it.hasNext();
        }

        @Override
        public E next() {
            this.checkForComodification();
            Object e = this.it.next();
            this.lastReturned = this.cursor++;
            return e;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            VetoableListDecorator.this.onProposedChange(Collections.emptyList(), this.offset + this.lastReturned, this.offset + this.lastReturned + 1);
            try {
                this.incrementModCount();
                this.it.remove();
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
            this.lastReturned = -1;
            --this.cursor;
        }

        protected void checkForComodification() {
            if (this.modCount != this.modCountAccessor.get()) {
                throw new ConcurrentModificationException();
            }
        }

        protected void incrementModCount() {
            this.modCount = this.modCountAccessor.incrementAndGet();
        }

        protected void decrementModCount() {
            this.modCount = this.modCountAccessor.decrementAndGet();
        }
    }

    private class ModCountAccessorImpl
    implements ModCountAccessor {
        @Override
        public int get() {
            return VetoableListDecorator.this.modCount;
        }

        @Override
        public int incrementAndGet() {
            return ++VetoableListDecorator.this.modCount;
        }

        @Override
        public int decrementAndGet() {
            return --VetoableListDecorator.this.modCount;
        }
    }

    private static interface ModCountAccessor {
        public int get();

        public int incrementAndGet();

        public int decrementAndGet();
    }

    private class VetoableListIteratorDecorator
    extends VetoableIteratorDecorator
    implements ListIterator<E> {
        private final ListIterator<E> lit;

        public VetoableListIteratorDecorator(ModCountAccessor modCountAccessor, ListIterator<E> it, int offset) {
            super(modCountAccessor, it, offset);
            this.lit = it;
        }

        @Override
        public boolean hasPrevious() {
            this.checkForComodification();
            return this.lit.hasPrevious();
        }

        @Override
        public E previous() {
            this.checkForComodification();
            Object e = this.lit.previous();
            this.lastReturned = --this.cursor;
            return e;
        }

        @Override
        public int nextIndex() {
            this.checkForComodification();
            return this.lit.nextIndex();
        }

        @Override
        public int previousIndex() {
            this.checkForComodification();
            return this.lit.previousIndex();
        }

        @Override
        public void set(E e) {
            this.checkForComodification();
            if (this.lastReturned == -1) {
                throw new IllegalStateException();
            }
            VetoableListDecorator.this.onProposedChange(Collections.singletonList(e), this.offset + this.lastReturned, this.offset + this.lastReturned + 1);
            this.lit.set(e);
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.singletonList(e), this.offset + this.cursor, this.offset + this.cursor);
            try {
                this.incrementModCount();
                this.lit.add(e);
            }
            catch (Exception ex) {
                this.decrementModCount();
                throw ex;
            }
            ++this.cursor;
        }
    }

    private class VetoableSubListDecorator
    implements List<E> {
        private final List<E> subList;
        private final int offset;
        private final ModCountAccessor modCountAccessor;
        private int modCount;

        public VetoableSubListDecorator(ModCountAccessor modCountAccessor, List<E> subList, int offset) {
            this.modCountAccessor = modCountAccessor;
            this.modCount = modCountAccessor.get();
            this.subList = subList;
            this.offset = offset;
        }

        @Override
        public int size() {
            this.checkForComodification();
            return this.subList.size();
        }

        @Override
        public boolean isEmpty() {
            this.checkForComodification();
            return this.subList.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            this.checkForComodification();
            return this.subList.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            this.checkForComodification();
            return new VetoableIteratorDecorator(new ModCountAccessorImplSub(), this.subList.iterator(), this.offset);
        }

        @Override
        public Object[] toArray() {
            this.checkForComodification();
            return this.subList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            this.checkForComodification();
            return this.subList.toArray(a);
        }

        @Override
        public boolean add(E e) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.singletonList(e), this.offset + this.size(), this.offset + this.size());
            try {
                this.incrementModCount();
                this.subList.add(e);
            }
            catch (Exception ex) {
                this.decrementModCount();
                throw ex;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            this.checkForComodification();
            int i = this.indexOf(o);
            if (i != -1) {
                this.remove(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            this.checkForComodification();
            return this.subList.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.unmodifiableList(new ArrayList(c)), this.offset + this.size(), this.offset + this.size());
            try {
                this.incrementModCount();
                boolean res = this.subList.addAll(c);
                if (!res) {
                    this.decrementModCount();
                }
                return res;
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.unmodifiableList(new ArrayList(c)), this.offset + index, this.offset + index);
            try {
                this.incrementModCount();
                boolean res = this.subList.addAll(index, c);
                if (!res) {
                    this.decrementModCount();
                }
                return res;
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            this.checkForComodification();
            VetoableListDecorator.this.removeFromList(this, this.offset, c, false);
            try {
                this.incrementModCount();
                boolean res = this.subList.removeAll(c);
                if (!res) {
                    this.decrementModCount();
                }
                return res;
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            this.checkForComodification();
            VetoableListDecorator.this.removeFromList(this, this.offset, c, true);
            try {
                this.incrementModCount();
                boolean res = this.subList.retainAll(c);
                if (!res) {
                    this.decrementModCount();
                }
                return res;
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public void clear() {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.emptyList(), this.offset, this.offset + this.size());
            try {
                this.incrementModCount();
                this.subList.clear();
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public E get(int index) {
            this.checkForComodification();
            return this.subList.get(index);
        }

        @Override
        public E set(int index, E element) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.singletonList(element), this.offset + index, this.offset + index + 1);
            return this.subList.set(index, element);
        }

        @Override
        public void add(int index, E element) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.singletonList(element), this.offset + index, this.offset + index);
            try {
                this.incrementModCount();
                this.subList.add(index, element);
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public E remove(int index) {
            this.checkForComodification();
            VetoableListDecorator.this.onProposedChange(Collections.emptyList(), this.offset + index, this.offset + index + 1);
            try {
                this.incrementModCount();
                Object res = this.subList.remove(index);
                return res;
            }
            catch (Exception e) {
                this.decrementModCount();
                throw e;
            }
        }

        @Override
        public int indexOf(Object o) {
            this.checkForComodification();
            return this.subList.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            this.checkForComodification();
            return this.subList.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            this.checkForComodification();
            return new VetoableListIteratorDecorator((ModCountAccessor)new ModCountAccessorImplSub(), this.subList.listIterator(), this.offset);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            this.checkForComodification();
            return new VetoableListIteratorDecorator((ModCountAccessor)new ModCountAccessorImplSub(), this.subList.listIterator(index), this.offset + index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            this.checkForComodification();
            return new VetoableSubListDecorator(new ModCountAccessorImplSub(), this.subList.subList(fromIndex, toIndex), this.offset + fromIndex);
        }

        public String toString() {
            this.checkForComodification();
            return this.subList.toString();
        }

        @Override
        public boolean equals(Object obj) {
            this.checkForComodification();
            return this.subList.equals(obj);
        }

        @Override
        public int hashCode() {
            this.checkForComodification();
            return this.subList.hashCode();
        }

        private void checkForComodification() {
            if (this.modCount != this.modCountAccessor.get()) {
                throw new ConcurrentModificationException();
            }
        }

        private void incrementModCount() {
            this.modCount = this.modCountAccessor.incrementAndGet();
        }

        private void decrementModCount() {
            this.modCount = this.modCountAccessor.decrementAndGet();
        }

        private class ModCountAccessorImplSub
        implements ModCountAccessor {
            private ModCountAccessorImplSub() {
            }

            @Override
            public int get() {
                return VetoableSubListDecorator.this.modCount;
            }

            @Override
            public int incrementAndGet() {
                VetoableSubListDecorator.this.modCount = VetoableSubListDecorator.this.modCountAccessor.incrementAndGet();
                return VetoableSubListDecorator.this.modCount;
            }

            @Override
            public int decrementAndGet() {
                VetoableSubListDecorator.this.modCount = VetoableSubListDecorator.this.modCountAccessor.decrementAndGet();
                return VetoableSubListDecorator.this.modCount;
            }
        }
    }
}

