/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;

public class PulseLogger {
    public static final boolean PULSE_LOGGING_ENABLED;
    private static final String[] DEFAULT_LOGGERS;
    private static final Logger[] loggers;

    public static void pulseStart() {
        for (Logger logger : loggers) {
            logger.pulseStart();
        }
    }

    public static void pulseEnd() {
        for (Logger logger : loggers) {
            logger.pulseEnd();
        }
    }

    public static void renderStart() {
        for (Logger logger : loggers) {
            logger.renderStart();
        }
    }

    public static void renderEnd() {
        for (Logger logger : loggers) {
            logger.renderEnd();
        }
    }

    public static void addMessage(String message) {
        for (Logger logger : loggers) {
            logger.addMessage(message);
        }
    }

    public static void incrementCounter(String counter) {
        for (Logger logger : loggers) {
            logger.incrementCounter(counter);
        }
    }

    public static void newPhase(String name) {
        for (Logger logger : loggers) {
            logger.newPhase(name);
        }
    }

    public static void newInput(String name) {
        for (Logger logger : loggers) {
            logger.newInput(name);
        }
    }

    public static boolean isPulseLoggingRequested() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.pulseLogger"));
    }

    private static Logger loadLogger(String className) {
        try {
            Class<?> klass = Class.forName(className);
            if (klass != null) {
                Method method = klass.getDeclaredMethod("createInstance", new Class[0]);
                return (Logger)method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        DEFAULT_LOGGERS = new String[]{"com.sun.javafx.logging.PrintLogger", "com.sun.javafx.logging.jfr.JFRPulseLogger"};
        ArrayList<Logger> list = new ArrayList<Logger>();
        for (String loggerClass : DEFAULT_LOGGERS) {
            Logger logger = PulseLogger.loadLogger(loggerClass);
            if (logger == null) continue;
            list.add(logger);
        }
        loggers = list.toArray(new Logger[list.size()]);
        PULSE_LOGGING_ENABLED = loggers.length > 0;
    }
}

