/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import com.sun.javafx.binding.Subscription;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;

public class FlatMappedBinding<S, T>
extends LazyObjectBinding<T> {
    private final ObservableValue<S> source;
    private final Function<? super S, ? extends ObservableValue<? extends T>> mapper;
    private Subscription indirectSourceSubscription = Subscription.EMPTY;
    private ObservableValue<? extends T> indirectSource;

    public FlatMappedBinding(ObservableValue<S> source, Function<? super S, ? extends ObservableValue<? extends T>> mapper) {
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.mapper = Objects.requireNonNull(mapper, "mapper cannot be null");
    }

    @Override
    protected T computeValue() {
        ObservableValue<? extends T> newIndirectSource;
        S value = this.source.getValue();
        ObservableValue<? extends T> observableValue = newIndirectSource = value == null ? null : this.mapper.apply(value);
        if (this.isObserved() && this.indirectSource != newIndirectSource) {
            this.indirectSourceSubscription.unsubscribe();
            this.indirectSourceSubscription = newIndirectSource == null ? Subscription.EMPTY : Subscription.subscribeInvalidations(newIndirectSource, this::invalidate);
            this.indirectSource = newIndirectSource;
        }
        return newIndirectSource == null ? null : (T)newIndirectSource.getValue();
    }

    @Override
    protected Subscription observeSources() {
        Subscription subscription = Subscription.subscribeInvalidations(this.source, this::invalidateAll);
        return () -> {
            subscription.unsubscribe();
            this.unsubscribeIndirectSource();
        };
    }

    private void invalidateAll() {
        this.unsubscribeIndirectSource();
        this.invalidate();
    }

    private void unsubscribeIndirectSource() {
        this.indirectSourceSubscription.unsubscribe();
        this.indirectSourceSubscription = Subscription.EMPTY;
        this.indirectSource = null;
    }
}

