/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.Subscription;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;

abstract class LazyObjectBinding<T>
extends ObjectBinding<T> {
    private Subscription subscription;
    private boolean wasObserved;

    LazyObjectBinding() {
    }

    @Override
    public void addListener(ChangeListener<? super T> listener) {
        super.addListener(listener);
        this.updateSubscriptionAfterAdd();
    }

    @Override
    public void removeListener(ChangeListener<? super T> listener) {
        super.removeListener(listener);
        this.updateSubscriptionAfterRemove();
    }

    @Override
    public void addListener(InvalidationListener listener) {
        super.addListener(listener);
        this.updateSubscriptionAfterAdd();
    }

    @Override
    public void removeListener(InvalidationListener listener) {
        super.removeListener(listener);
        this.updateSubscriptionAfterRemove();
    }

    @Override
    protected boolean allowValidation() {
        return this.isObserved();
    }

    private void updateSubscriptionAfterAdd() {
        if (!this.wasObserved) {
            this.subscription = this.observeSources();
            this.get();
            this.wasObserved = true;
        }
    }

    private void updateSubscriptionAfterRemove() {
        if (this.wasObserved && !this.isObserved()) {
            this.subscription.unsubscribe();
            this.subscription = null;
            this.invalidate();
            this.wasObserved = false;
        }
    }

    protected abstract Subscription observeSources();
}

