/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.ExpressionHelperBase;
import java.util.Arrays;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableMapValue;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;

public abstract class MapExpressionHelper<K, V>
extends ExpressionHelperBase {
    protected final ObservableMapValue<K, V> observable;

    public static <K, V> MapExpressionHelper<K, V> addListener(MapExpressionHelper<K, V> helper, ObservableMapValue<K, V> observable, InvalidationListener listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        observable.getValue();
        return helper == null ? new SingleInvalidation<K, V>(observable, listener) : helper.addListener(listener);
    }

    public static <K, V> MapExpressionHelper<K, V> removeListener(MapExpressionHelper<K, V> helper, InvalidationListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <K, V> MapExpressionHelper<K, V> addListener(MapExpressionHelper<K, V> helper, ObservableMapValue<K, V> observable, ChangeListener<? super ObservableMap<K, V>> listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? new SingleChange<K, V>(observable, listener) : helper.addListener(listener);
    }

    public static <K, V> MapExpressionHelper<K, V> removeListener(MapExpressionHelper<K, V> helper, ChangeListener<? super ObservableMap<K, V>> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <K, V> MapExpressionHelper<K, V> addListener(MapExpressionHelper<K, V> helper, ObservableMapValue<K, V> observable, MapChangeListener<? super K, ? super V> listener) {
        if (observable == null || listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? new SingleMapChange<K, V>(observable, listener) : helper.addListener(listener);
    }

    public static <K, V> MapExpressionHelper<K, V> removeListener(MapExpressionHelper<K, V> helper, MapChangeListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        return helper == null ? null : helper.removeListener(listener);
    }

    public static <K, V> void fireValueChangedEvent(MapExpressionHelper<K, V> helper) {
        if (helper != null) {
            helper.fireValueChangedEvent();
        }
    }

    public static <K, V> void fireValueChangedEvent(MapExpressionHelper<K, V> helper, MapChangeListener.Change<? extends K, ? extends V> change) {
        if (helper != null) {
            helper.fireValueChangedEvent(change);
        }
    }

    protected MapExpressionHelper(ObservableMapValue<K, V> observable) {
        this.observable = observable;
    }

    protected abstract MapExpressionHelper<K, V> addListener(InvalidationListener var1);

    protected abstract MapExpressionHelper<K, V> removeListener(InvalidationListener var1);

    protected abstract MapExpressionHelper<K, V> addListener(ChangeListener<? super ObservableMap<K, V>> var1);

    protected abstract MapExpressionHelper<K, V> removeListener(ChangeListener<? super ObservableMap<K, V>> var1);

    protected abstract MapExpressionHelper<K, V> addListener(MapChangeListener<? super K, ? super V> var1);

    protected abstract MapExpressionHelper<K, V> removeListener(MapChangeListener<? super K, ? super V> var1);

    protected abstract void fireValueChangedEvent();

    protected abstract void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> var1);

    private static class SingleInvalidation<K, V>
    extends MapExpressionHelper<K, V> {
        private final InvalidationListener listener;

        private SingleInvalidation(ObservableMapValue<K, V> observable, InvalidationListener listener) {
            super(observable);
            this.listener = listener;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(InvalidationListener listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(InvalidationListener listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(MapChangeListener<? super K, ? super V> listener) {
            return new Generic<K, V>(this.observable, this.listener, listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(MapChangeListener<? super K, ? super V> listener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            this.listener.invalidated(this.observable);
        }

        @Override
        protected void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
            this.listener.invalidated(this.observable);
        }
    }

    private static class SingleChange<K, V>
    extends MapExpressionHelper<K, V> {
        private final ChangeListener<? super ObservableMap<K, V>> listener;
        private ObservableMap<K, V> currentValue;

        private SingleChange(ObservableMapValue<K, V> observable, ChangeListener<? super ObservableMap<K, V>> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(InvalidationListener listener) {
            return new Generic(this.observable, listener, this.listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            return new Generic(this.observable, this.listener, listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(MapChangeListener<? super K, ? super V> listener) {
            return new Generic<K, V>(this.observable, this.listener, listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(MapChangeListener<? super K, ? super V> listener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            ObservableMap<K, V> oldValue = this.currentValue;
            this.currentValue = (ObservableMap)this.observable.getValue();
            if (this.currentValue != oldValue) {
                this.listener.changed(this.observable, oldValue, this.currentValue);
            }
        }

        @Override
        protected void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
            this.listener.changed(this.observable, this.currentValue, this.currentValue);
        }
    }

    private static class SingleMapChange<K, V>
    extends MapExpressionHelper<K, V> {
        private final MapChangeListener<? super K, ? super V> listener;
        private ObservableMap<K, V> currentValue;

        private SingleMapChange(ObservableMapValue<K, V> observable, MapChangeListener<? super K, ? super V> listener) {
            super(observable);
            this.listener = listener;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(InvalidationListener listener) {
            return new Generic<K, V>(this.observable, listener, this.listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(InvalidationListener listener) {
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            return new Generic<K, V>(this.observable, listener, this.listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(MapChangeListener<? super K, ? super V> listener) {
            return new Generic<K, V>(this.observable, this.listener, listener);
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(MapChangeListener<? super K, ? super V> listener) {
            return listener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChangedEvent() {
            block9: {
                ObservableMap<K, V> oldValue = this.currentValue;
                this.currentValue = (ObservableMap)this.observable.getValue();
                if (this.currentValue == oldValue) break block9;
                SimpleChange change = new SimpleChange(this.observable);
                if (this.currentValue == null) {
                    for (Map.Entry element : oldValue.entrySet()) {
                        this.listener.onChanged(change.setRemoved(element.getKey(), element.getValue()));
                    }
                } else if (oldValue == null) {
                    for (Map.Entry element : this.currentValue.entrySet()) {
                        this.listener.onChanged(change.setAdded(element.getKey(), element.getValue()));
                    }
                } else {
                    Object key;
                    for (Map.Entry element : oldValue.entrySet()) {
                        key = element.getKey();
                        Object oldEntry = element.getValue();
                        if (this.currentValue.containsKey(key)) {
                            Object newEntry = this.currentValue.get(key);
                            if (!(oldEntry == null ? newEntry != null : !newEntry.equals(oldEntry))) continue;
                            this.listener.onChanged(change.setPut(key, oldEntry, newEntry));
                            continue;
                        }
                        this.listener.onChanged(change.setRemoved(key, oldEntry));
                    }
                    for (Map.Entry element : this.currentValue.entrySet()) {
                        key = element.getKey();
                        if (oldValue.containsKey(key)) continue;
                        this.listener.onChanged(change.setAdded(key, element.getValue()));
                    }
                }
            }
        }

        @Override
        protected void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
            this.listener.onChanged(new SimpleChange<K, V>(this.observable, change));
        }
    }

    public static class SimpleChange<K, V>
    extends MapChangeListener.Change<K, V> {
        private K key;
        private V old;
        private V added;
        private boolean removeOp;
        private boolean addOp;

        public SimpleChange(ObservableMap<K, V> set) {
            super(set);
        }

        public SimpleChange(ObservableMap<K, V> set, MapChangeListener.Change<? extends K, ? extends V> source) {
            super(set);
            this.key = source.getKey();
            this.old = source.getValueRemoved();
            this.added = source.getValueAdded();
            this.addOp = source.wasAdded();
            this.removeOp = source.wasRemoved();
        }

        public SimpleChange<K, V> setRemoved(K key, V old) {
            this.key = key;
            this.old = old;
            this.added = null;
            this.addOp = false;
            this.removeOp = true;
            return this;
        }

        public SimpleChange<K, V> setAdded(K key, V added) {
            this.key = key;
            this.old = null;
            this.added = added;
            this.addOp = true;
            this.removeOp = false;
            return this;
        }

        public SimpleChange<K, V> setPut(K key, V old, V added) {
            this.key = key;
            this.old = old;
            this.added = added;
            this.addOp = true;
            this.removeOp = true;
            return this;
        }

        @Override
        public boolean wasAdded() {
            return this.addOp;
        }

        @Override
        public boolean wasRemoved() {
            return this.removeOp;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValueAdded() {
            return this.added;
        }

        @Override
        public V getValueRemoved() {
            return this.old;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.addOp) {
                if (this.removeOp) {
                    builder.append("replaced ").append(this.old).append(" by ").append(this.added);
                } else {
                    builder.append("added ").append(this.added);
                }
            } else {
                builder.append("removed ").append(this.old);
            }
            builder.append(" at key ").append(this.key);
            return builder.toString();
        }
    }

    private static class Generic<K, V>
    extends MapExpressionHelper<K, V> {
        private InvalidationListener[] invalidationListeners;
        private ChangeListener<? super ObservableMap<K, V>>[] changeListeners;
        private MapChangeListener<? super K, ? super V>[] mapChangeListeners;
        private int invalidationSize;
        private int changeSize;
        private int mapChangeSize;
        private boolean locked;
        private ObservableMap<K, V> currentValue;

        private Generic(ObservableMapValue<K, V> observable, InvalidationListener listener0, InvalidationListener listener1) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{listener0, listener1};
            this.invalidationSize = 2;
        }

        private Generic(ObservableMapValue<K, V> observable, ChangeListener<? super ObservableMap<K, V>> listener0, ChangeListener<? super ObservableMap<K, V>> listener1) {
            super(observable);
            this.changeListeners = new ChangeListener[]{listener0, listener1};
            this.changeSize = 2;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        private Generic(ObservableMapValue<K, V> observable, MapChangeListener<? super K, ? super V> listener0, MapChangeListener<? super K, ? super V> listener1) {
            super(observable);
            this.mapChangeListeners = new MapChangeListener[]{listener0, listener1};
            this.mapChangeSize = 2;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        private Generic(ObservableMapValue<K, V> observable, InvalidationListener invalidationListener, ChangeListener<? super ObservableMap<K, V>> changeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        private Generic(ObservableMapValue<K, V> observable, InvalidationListener invalidationListener, MapChangeListener<? super K, ? super V> listChangeListener) {
            super(observable);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.mapChangeListeners = new MapChangeListener[]{listChangeListener};
            this.mapChangeSize = 1;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        private Generic(ObservableMapValue<K, V> observable, ChangeListener<? super ObservableMap<K, V>> changeListener, MapChangeListener<? super K, ? super V> listChangeListener) {
            super(observable);
            this.changeListeners = new ChangeListener[]{changeListener};
            this.changeSize = 1;
            this.mapChangeListeners = new MapChangeListener[]{listChangeListener};
            this.mapChangeSize = 1;
            this.currentValue = (ObservableMap)observable.getValue();
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(InvalidationListener listener) {
            if (this.invalidationListeners == null) {
                this.invalidationListeners = new InvalidationListener[]{listener};
                this.invalidationSize = 1;
            } else {
                int oldCapacity = this.invalidationListeners.length;
                if (this.locked) {
                    int newCapacity = this.invalidationSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                } else if (this.invalidationSize == oldCapacity) {
                    this.invalidationSize = Generic.trim(this.invalidationSize, this.invalidationListeners);
                    if (this.invalidationSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, newCapacity);
                    }
                }
                this.invalidationListeners[this.invalidationSize++] = listener;
            }
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(InvalidationListener listener) {
            if (this.invalidationListeners != null) {
                for (int index = 0; index < this.invalidationSize; ++index) {
                    if (!listener.equals(this.invalidationListeners[index])) continue;
                    if (this.invalidationSize == 1) {
                        if (this.changeSize == 1 && this.mapChangeSize == 0) {
                            return new SingleChange(this.observable, this.changeListeners[0]);
                        }
                        if (this.changeSize == 0 && this.mapChangeSize == 1) {
                            return new SingleMapChange<K, V>(this.observable, this.mapChangeListeners[0]);
                        }
                        this.invalidationListeners = null;
                        this.invalidationSize = 0;
                        break;
                    }
                    if (this.invalidationSize == 2 && this.changeSize == 0 && this.mapChangeSize == 0) {
                        return new SingleInvalidation(this.observable, this.invalidationListeners[1 - index]);
                    }
                    int numMoved = this.invalidationSize - index - 1;
                    InvalidationListener[] oldListeners = this.invalidationListeners;
                    if (this.locked) {
                        this.invalidationListeners = new InvalidationListener[this.invalidationListeners.length];
                        System.arraycopy(oldListeners, 0, this.invalidationListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.invalidationListeners, index, numMoved);
                    }
                    --this.invalidationSize;
                    if (this.locked) break;
                    this.invalidationListeners[this.invalidationSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            if (this.changeListeners == null) {
                this.changeListeners = new ChangeListener[]{listener};
                this.changeSize = 1;
            } else {
                int oldCapacity = this.changeListeners.length;
                if (this.locked) {
                    int newCapacity = this.changeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                } else if (this.changeSize == oldCapacity) {
                    this.changeSize = Generic.trim(this.changeSize, this.changeListeners);
                    if (this.changeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.changeListeners = Arrays.copyOf(this.changeListeners, newCapacity);
                    }
                }
                this.changeListeners[this.changeSize++] = listener;
            }
            if (this.changeSize == 1) {
                this.currentValue = (ObservableMap)this.observable.getValue();
            }
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(ChangeListener<? super ObservableMap<K, V>> listener) {
            if (this.changeListeners != null) {
                for (int index = 0; index < this.changeSize; ++index) {
                    if (!listener.equals(this.changeListeners[index])) continue;
                    if (this.changeSize == 1) {
                        if (this.invalidationSize == 1 && this.mapChangeSize == 0) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        if (this.invalidationSize == 0 && this.mapChangeSize == 1) {
                            return new SingleMapChange<K, V>(this.observable, this.mapChangeListeners[0]);
                        }
                        this.changeListeners = null;
                        this.changeSize = 0;
                        break;
                    }
                    if (this.changeSize == 2 && this.invalidationSize == 0 && this.mapChangeSize == 0) {
                        return new SingleChange(this.observable, this.changeListeners[1 - index]);
                    }
                    int numMoved = this.changeSize - index - 1;
                    ChangeListener<? super ObservableMap<K, V>>[] oldListeners = this.changeListeners;
                    if (this.locked) {
                        this.changeListeners = new ChangeListener[this.changeListeners.length];
                        System.arraycopy(oldListeners, 0, this.changeListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.changeListeners, index, numMoved);
                    }
                    --this.changeSize;
                    if (this.locked) break;
                    this.changeListeners[this.changeSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> addListener(MapChangeListener<? super K, ? super V> listener) {
            if (this.mapChangeListeners == null) {
                this.mapChangeListeners = new MapChangeListener[]{listener};
                this.mapChangeSize = 1;
            } else {
                int oldCapacity = this.mapChangeListeners.length;
                if (this.locked) {
                    int newCapacity = this.mapChangeSize < oldCapacity ? oldCapacity : oldCapacity * 3 / 2 + 1;
                    this.mapChangeListeners = Arrays.copyOf(this.mapChangeListeners, newCapacity);
                } else if (this.mapChangeSize == oldCapacity) {
                    this.mapChangeSize = Generic.trim(this.mapChangeSize, this.mapChangeListeners);
                    if (this.mapChangeSize == oldCapacity) {
                        int newCapacity = oldCapacity * 3 / 2 + 1;
                        this.mapChangeListeners = Arrays.copyOf(this.mapChangeListeners, newCapacity);
                    }
                }
                this.mapChangeListeners[this.mapChangeSize++] = listener;
            }
            if (this.mapChangeSize == 1) {
                this.currentValue = (ObservableMap)this.observable.getValue();
            }
            return this;
        }

        @Override
        protected MapExpressionHelper<K, V> removeListener(MapChangeListener<? super K, ? super V> listener) {
            if (this.mapChangeListeners != null) {
                for (int index = 0; index < this.mapChangeSize; ++index) {
                    if (!listener.equals(this.mapChangeListeners[index])) continue;
                    if (this.mapChangeSize == 1) {
                        if (this.invalidationSize == 1 && this.changeSize == 0) {
                            return new SingleInvalidation(this.observable, this.invalidationListeners[0]);
                        }
                        if (this.invalidationSize == 0 && this.changeSize == 1) {
                            return new SingleChange(this.observable, this.changeListeners[0]);
                        }
                        this.mapChangeListeners = null;
                        this.mapChangeSize = 0;
                        break;
                    }
                    if (this.mapChangeSize == 2 && this.invalidationSize == 0 && this.changeSize == 0) {
                        return new SingleMapChange<K, V>(this.observable, this.mapChangeListeners[1 - index]);
                    }
                    int numMoved = this.mapChangeSize - index - 1;
                    MapChangeListener<? super K, ? super V>[] oldListeners = this.mapChangeListeners;
                    if (this.locked) {
                        this.mapChangeListeners = new MapChangeListener[this.mapChangeListeners.length];
                        System.arraycopy(oldListeners, 0, this.mapChangeListeners, 0, index + 1);
                    }
                    if (numMoved > 0) {
                        System.arraycopy(oldListeners, index + 1, this.mapChangeListeners, index, numMoved);
                    }
                    --this.mapChangeSize;
                    if (this.locked) break;
                    this.mapChangeListeners[this.mapChangeSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected void fireValueChangedEvent() {
            if (this.changeSize == 0 && this.mapChangeSize == 0) {
                this.notifyListeners(this.currentValue, null);
            } else {
                ObservableMap<K, V> oldValue = this.currentValue;
                this.currentValue = (ObservableMap)this.observable.getValue();
                this.notifyListeners(oldValue, null);
            }
        }

        @Override
        protected void fireValueChangedEvent(MapChangeListener.Change<? extends K, ? extends V> change) {
            SimpleChange<? extends K, ? extends V> mappedChange = this.mapChangeSize == 0 ? null : new SimpleChange<K, V>(this.observable, change);
            this.notifyListeners(this.currentValue, mappedChange);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(ObservableMap<K, V> oldValue, SimpleChange<K, V> change) {
            block19: {
                InvalidationListener[] curInvalidationList = this.invalidationListeners;
                int curInvalidationSize = this.invalidationSize;
                ChangeListener<? super ObservableMap<K, V>>[] curChangeList = this.changeListeners;
                int curChangeSize = this.changeSize;
                MapChangeListener<? super K, ? super V>[] curListChangeList = this.mapChangeListeners;
                int curListChangeSize = this.mapChangeSize;
                try {
                    Object key;
                    int i;
                    this.locked = true;
                    for (i = 0; i < curInvalidationSize; ++i) {
                        curInvalidationList[i].invalidated(this.observable);
                    }
                    if (this.currentValue == oldValue && change == null) break block19;
                    for (i = 0; i < curChangeSize; ++i) {
                        curChangeList[i].changed(this.observable, oldValue, this.currentValue);
                    }
                    if (curListChangeSize <= 0) break block19;
                    if (change != null) {
                        for (i = 0; i < curListChangeSize; ++i) {
                            curListChangeList[i].onChanged(change);
                        }
                        break block19;
                    }
                    change = new SimpleChange(this.observable);
                    if (this.currentValue == null) {
                        for (Map.Entry element : oldValue.entrySet()) {
                            change.setRemoved(element.getKey(), element.getValue());
                            for (int i2 = 0; i2 < curListChangeSize; ++i2) {
                                curListChangeList[i2].onChanged(change);
                            }
                        }
                        break block19;
                    }
                    if (oldValue == null) {
                        for (Map.Entry element : this.currentValue.entrySet()) {
                            change.setAdded(element.getKey(), element.getValue());
                            for (int i3 = 0; i3 < curListChangeSize; ++i3) {
                                curListChangeList[i3].onChanged(change);
                            }
                        }
                        break block19;
                    }
                    for (Map.Entry element : oldValue.entrySet()) {
                        key = element.getKey();
                        Object oldEntry = element.getValue();
                        if (this.currentValue.containsKey(key)) {
                            Object newEntry = this.currentValue.get(key);
                            if (!(oldEntry == null ? newEntry != null : !newEntry.equals(oldEntry))) continue;
                            change.setPut(key, oldEntry, newEntry);
                            for (int i4 = 0; i4 < curListChangeSize; ++i4) {
                                curListChangeList[i4].onChanged(change);
                            }
                            continue;
                        }
                        change.setRemoved(key, oldEntry);
                        for (int i5 = 0; i5 < curListChangeSize; ++i5) {
                            curListChangeList[i5].onChanged(change);
                        }
                    }
                    for (Map.Entry element : this.currentValue.entrySet()) {
                        key = element.getKey();
                        if (oldValue.containsKey(key)) continue;
                        change.setAdded(key, element.getValue());
                        for (int i6 = 0; i6 < curListChangeSize; ++i6) {
                            curListChangeList[i6].onChanged(change);
                        }
                    }
                }
                finally {
                    this.locked = false;
                }
            }
        }
    }
}

