/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import com.sun.javafx.binding.Subscription;
import java.util.Objects;
import java.util.function.Function;
import javafx.beans.value.ObservableValue;

public class MappedBinding<S, T>
extends LazyObjectBinding<T> {
    private final ObservableValue<S> source;
    private final Function<? super S, ? extends T> mapper;

    public MappedBinding(ObservableValue<S> source, Function<? super S, ? extends T> mapper) {
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.mapper = Objects.requireNonNull(mapper, "mapper cannot be null");
    }

    @Override
    protected T computeValue() {
        S value = this.source.getValue();
        return value == null ? null : (T)this.mapper.apply((S)value);
    }

    @Override
    protected Subscription observeSources() {
        return Subscription.subscribeInvalidations(this.source, this::invalidate);
    }
}

