/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.LazyObjectBinding;
import com.sun.javafx.binding.Subscription;
import java.util.Objects;
import javafx.beans.value.ObservableValue;

public class OrElseBinding<T>
extends LazyObjectBinding<T> {
    private final ObservableValue<T> source;
    private final T constant;

    public OrElseBinding(ObservableValue<T> source, T constant) {
        this.source = Objects.requireNonNull(source, "source cannot be null");
        this.constant = constant;
    }

    @Override
    protected T computeValue() {
        T value = this.source.getValue();
        return value == null ? this.constant : value;
    }

    @Override
    protected Subscription observeSources() {
        return Subscription.subscribeInvalidations(this.source, this::invalidate);
    }
}

