/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import java.util.Objects;
import java.util.function.Consumer;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

@FunctionalInterface
public interface Subscription {
    public static final Subscription EMPTY = () -> {};

    public void unsubscribe();

    default public Subscription and(Subscription other) {
        Objects.requireNonNull(other);
        return () -> {
            this.unsubscribe();
            other.unsubscribe();
        };
    }

    public static <T> Subscription subscribe(ObservableValue<T> observableValue, Consumer<? super T> subscriber) {
        Objects.requireNonNull(observableValue);
        Objects.requireNonNull(subscriber);
        ChangeListener<Object> listener = (obs, old, current) -> subscriber.accept(current);
        subscriber.accept(observableValue.getValue());
        observableValue.addListener(listener);
        return () -> observableValue.removeListener(listener);
    }

    public static Subscription subscribeInvalidations(ObservableValue<?> observableValue, Runnable runnable) {
        Objects.requireNonNull(observableValue);
        Objects.requireNonNull(runnable);
        InvalidationListener listener = obs -> runnable.run();
        observableValue.addListener(listener);
        return () -> observableValue.removeListener(listener);
    }
}

