/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ChangeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableListBase;

final class ListChangeBuilder<E> {
    private static final int[] EMPTY_PERM = new int[0];
    private final ObservableListBase<E> list;
    private int changeLock;
    private List<SubChange<E>> addRemoveChanges;
    private List<SubChange<E>> updateChanges;
    private SubChange<E> permutationChange;

    private void checkAddRemoveList() {
        if (this.addRemoveChanges == null) {
            this.addRemoveChanges = new ArrayList<SubChange<E>>();
        }
    }

    private void checkState() {
        if (this.changeLock == 0) {
            throw new IllegalStateException("beginChange was not called on this builder");
        }
    }

    private int findSubChange(int idx, List<SubChange<E>> list) {
        int from = 0;
        int to = list.size() - 1;
        while (from <= to) {
            int changeIdx = (from + to) / 2;
            SubChange<E> change = list.get(changeIdx);
            if (idx >= change.to) {
                from = changeIdx + 1;
                continue;
            }
            if (idx < change.from) {
                to = changeIdx - 1;
                continue;
            }
            return changeIdx;
        }
        return ~from;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insertUpdate(int pos) {
        SubChange<E> change;
        int idx = this.findSubChange(pos, this.updateChanges);
        if (idx >= 0) return;
        if ((idx ^= 0xFFFFFFFF) > 0) {
            change = this.updateChanges.get(idx - 1);
            if (change.to == pos) {
                change.to = pos + 1;
                return;
            }
        }
        if (idx < this.updateChanges.size()) {
            change = this.updateChanges.get(idx);
            if (change.from == pos + 1) {
                change.from = pos;
                return;
            }
        }
        this.updateChanges.add(idx, new SubChange(pos, pos + 1, null, EMPTY_PERM, true));
    }

    /*
     * Unable to fully structure code
     */
    private void insertRemoved(int pos, E removed) {
        block6: {
            block4: {
                block5: {
                    idx = this.findSubChange(pos, this.addRemoveChanges);
                    if (idx >= 0) break block4;
                    if ((idx ^= -1) <= 0) break block5;
                    change = this.addRemoveChanges.get(idx - 1);
                    if (change.to != pos) break block5;
                    change.removed.add(removed);
                    --idx;
                    break block6;
                }
                if (idx >= this.addRemoveChanges.size()) ** GOTO lbl-1000
                change = this.addRemoveChanges.get(idx);
                if (change.from == pos + 1) {
                    --change.from;
                    --change.to;
                    change.removed.add(0, removed);
                } else lbl-1000:
                // 2 sources

                {
                    removedList = new ArrayList<E>();
                    removedList.add(removed);
                    this.addRemoveChanges.add(idx, new SubChange<E>(pos, pos, removedList, ListChangeBuilder.EMPTY_PERM, false));
                }
                break block6;
            }
            change = this.addRemoveChanges.get(idx);
            --change.to;
            if (change.from == change.to && (change.removed == null || change.removed.isEmpty())) {
                this.addRemoveChanges.remove(idx);
            }
        }
        for (i = idx + 1; i < this.addRemoveChanges.size(); ++i) {
            change = this.addRemoveChanges.get(i);
            --change.from;
            --change.to;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void insertAdd(int from, int to) {
        block4: {
            block3: {
                idx = this.findSubChange(from, this.addRemoveChanges);
                numberOfAdded = to - from;
                if (idx >= 0) break block3;
                if ((idx ^= -1) <= 0) ** GOTO lbl-1000
                change = this.addRemoveChanges.get(idx - 1);
                if (change.to == from) {
                    change.to = to;
                    --idx;
                } else lbl-1000:
                // 2 sources

                {
                    this.addRemoveChanges.add(idx, new SubChange<E>(from, to, new ArrayList<E>(), ListChangeBuilder.EMPTY_PERM, false));
                }
                break block4;
            }
            change = this.addRemoveChanges.get(idx);
            change.to += numberOfAdded;
        }
        for (i = idx + 1; i < this.addRemoveChanges.size(); ++i) {
            change = this.addRemoveChanges.get(i);
            change.from += numberOfAdded;
            change.to += numberOfAdded;
        }
    }

    private int compress(List<SubChange<E>> list) {
        int removed = 0;
        SubChange<E> prev = list.get(0);
        int sz = list.size();
        for (int i = 1; i < sz; ++i) {
            SubChange<E> cur = list.get(i);
            if (prev.to == cur.from) {
                prev.to = cur.to;
                if (prev.removed != null || cur.removed != null) {
                    if (prev.removed == null) {
                        prev.removed = new ArrayList();
                    }
                    prev.removed.addAll(cur.removed);
                }
                list.set(i, null);
                ++removed;
                continue;
            }
            prev = cur;
        }
        return removed;
    }

    ListChangeBuilder(ObservableListBase<E> list) {
        this.list = list;
    }

    public void nextRemove(int idx, E removed) {
        SubChange<E> last;
        this.checkState();
        this.checkAddRemoveList();
        SubChange<E> subChange = last = this.addRemoveChanges.isEmpty() ? null : this.addRemoveChanges.get(this.addRemoveChanges.size() - 1);
        if (last != null && last.to == idx) {
            last.removed.add(removed);
        } else if (last != null && last.from == idx + 1) {
            --last.from;
            --last.to;
            last.removed.add(0, removed);
        } else {
            this.insertRemoved(idx, removed);
        }
        if (this.updateChanges != null && !this.updateChanges.isEmpty()) {
            int uPos = this.findSubChange(idx, this.updateChanges);
            if (uPos < 0) {
                uPos ^= 0xFFFFFFFF;
            } else {
                SubChange<E> change = this.updateChanges.get(uPos);
                if (change.from == change.to - 1) {
                    this.updateChanges.remove(uPos);
                } else {
                    --change.to;
                    ++uPos;
                }
            }
            for (int i = uPos; i < this.updateChanges.size(); ++i) {
                --this.updateChanges.get((int)i).from;
                --this.updateChanges.get((int)i).to;
            }
        }
    }

    public void nextRemove(int idx, List<? extends E> removed) {
        this.checkState();
        for (int i = 0; i < removed.size(); ++i) {
            this.nextRemove(idx, removed.get(i));
        }
    }

    public void nextAdd(int from, int to) {
        this.checkState();
        this.checkAddRemoveList();
        SubChange<E> last = this.addRemoveChanges.isEmpty() ? null : this.addRemoveChanges.get(this.addRemoveChanges.size() - 1);
        int numberOfAdded = to - from;
        if (last != null && last.to == from) {
            last.to = to;
        } else if (last != null && from >= last.from && from < last.to) {
            last.to += numberOfAdded;
        } else {
            this.insertAdd(from, to);
        }
        if (this.updateChanges != null && !this.updateChanges.isEmpty()) {
            int uPos = this.findSubChange(from, this.updateChanges);
            if (uPos < 0) {
                uPos ^= 0xFFFFFFFF;
            } else {
                SubChange<E> change = this.updateChanges.get(uPos);
                this.updateChanges.add(uPos + 1, new SubChange(to, change.to + to - from, null, EMPTY_PERM, true));
                change.to = from;
                uPos += 2;
            }
            for (int i = uPos; i < this.updateChanges.size(); ++i) {
                this.updateChanges.get((int)i).from += numberOfAdded;
                this.updateChanges.get((int)i).to += numberOfAdded;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void nextPermutation(int from, int to, int[] perm) {
        this.checkState();
        int prePermFrom = from;
        int prePermTo = to;
        int[] prePerm = perm;
        if (this.addRemoveChanges != null && !this.addRemoveChanges.isEmpty()) {
            int n;
            void var11_25;
            int[] mapToOriginal = new int[this.list.size()];
            TreeSet<Integer> removed = new TreeSet<Integer>();
            int last = 0;
            int offset = 0;
            boolean bl = false;
            int sz = this.addRemoveChanges.size();
            while (var11_25 < sz) {
                int j;
                SubChange<E> change = this.addRemoveChanges.get((int)var11_25);
                for (j = last; j < change.from; ++j) {
                    mapToOriginal[j < from || j >= to ? j : perm[j - from]] = j + offset;
                }
                for (j = change.from; j < change.to; ++j) {
                    mapToOriginal[j < from || j >= to ? j : perm[j - from]] = -1;
                }
                last = change.to;
                int removedSize = change.removed != null ? change.removed.size() : 0;
                int upTo = change.from + offset + removedSize;
                for (int j2 = change.from + offset; j2 < upTo; ++j2) {
                    removed.add(j2);
                }
                offset += removedSize - (change.to - change.from);
                ++var11_25;
            }
            int n2 = last;
            while (n < mapToOriginal.length) {
                mapToOriginal[n < from || n >= to ? n : perm[n - from]] = n + offset;
                ++n;
            }
            int[] nArray = new int[this.list.size() + offset];
            int mapPtr = 0;
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (removed.contains(i2)) {
                    nArray[i2] = i2;
                    continue;
                }
                while (mapToOriginal[mapPtr] == -1) {
                    ++mapPtr;
                }
                nArray[mapToOriginal[mapPtr++]] = i2;
            }
            prePermFrom = 0;
            prePermTo = nArray.length;
            prePerm = nArray;
        }
        if (this.permutationChange != null) {
            if (prePermFrom == this.permutationChange.from && prePermTo == this.permutationChange.to) {
                for (int i = 0; i < prePerm.length; ++i) {
                    this.permutationChange.perm[i] = prePerm[this.permutationChange.perm[i] - prePermFrom];
                }
            } else {
                int newTo = Math.max(this.permutationChange.to, prePermTo);
                int newFrom = Math.min(this.permutationChange.from, prePermFrom);
                int[] newPerm = new int[newTo - newFrom];
                for (int i = newFrom; i < newTo; ++i) {
                    int n;
                    newPerm[i - newFrom] = i < this.permutationChange.from || i >= this.permutationChange.to ? prePerm[i - prePermFrom] : ((n = this.permutationChange.perm[i - this.permutationChange.from]) < prePermFrom || n >= prePermTo ? n : prePerm[n - prePermFrom]);
                }
                this.permutationChange.from = newFrom;
                this.permutationChange.to = newTo;
                this.permutationChange.perm = newPerm;
            }
        } else {
            this.permutationChange = new SubChange(prePermFrom, prePermTo, null, prePerm, false);
        }
        if (this.addRemoveChanges != null && !this.addRemoveChanges.isEmpty()) {
            TreeSet<Integer> newAdded = new TreeSet<Integer>();
            HashMap newRemoved = new HashMap();
            int sz = this.addRemoveChanges.size();
            for (int i = 0; i < sz; ++i) {
                SubChange<E> subChange = this.addRemoveChanges.get(i);
                for (int cIndex = subChange.from; cIndex < subChange.to; ++cIndex) {
                    if (cIndex < from || cIndex >= to) {
                        newAdded.add(cIndex);
                        continue;
                    }
                    newAdded.add(perm[cIndex - from]);
                }
                if (subChange.removed == null) continue;
                if (subChange.from < from || subChange.from >= to) {
                    newRemoved.put(subChange.from, subChange.removed);
                    continue;
                }
                newRemoved.put(perm[subChange.from - from], subChange.removed);
            }
            this.addRemoveChanges.clear();
            SubChange lastChange = null;
            for (Integer n : newAdded) {
                List removed;
                if (lastChange == null || lastChange.to != n) {
                    lastChange = new SubChange(n, n + 1, null, EMPTY_PERM, false);
                    this.addRemoveChanges.add(lastChange);
                } else {
                    lastChange.to = n + 1;
                }
                if ((removed = (List)newRemoved.remove(n)) == null) continue;
                if (lastChange.removed != null) {
                    lastChange.removed.addAll(removed);
                    continue;
                }
                lastChange.removed = removed;
            }
            for (Map.Entry entry : newRemoved.entrySet()) {
                Integer at = (Integer)entry.getKey();
                int idx = this.findSubChange(at, this.addRemoveChanges);
                assert (idx < 0);
                this.addRemoveChanges.add(~idx, new SubChange(at, at, (List)entry.getValue(), new int[0], false));
            }
        }
        if (this.updateChanges != null && !this.updateChanges.isEmpty()) {
            TreeSet<Integer> newUpdated = new TreeSet<Integer>();
            int sz = this.updateChanges.size();
            for (int i = 0; i < sz; ++i) {
                void var11_34;
                SubChange<E> change = this.updateChanges.get(i);
                int n = change.from;
                while (var11_34 < change.to) {
                    if (var11_34 < from || var11_34 >= to) {
                        newUpdated.add((int)var11_34);
                    } else {
                        newUpdated.add(perm[var11_34 - from]);
                    }
                    ++var11_34;
                }
            }
            this.updateChanges.clear();
            SubChange lastUpdateChange = null;
            for (Integer i : newUpdated) {
                if (lastUpdateChange == null || lastUpdateChange.to != i) {
                    lastUpdateChange = new SubChange(i, i + 1, null, EMPTY_PERM, true);
                    this.updateChanges.add(lastUpdateChange);
                    continue;
                }
                lastUpdateChange.to = i + 1;
            }
        }
    }

    public void nextReplace(int from, int to, List<? extends E> removed) {
        this.nextRemove(from, removed);
        this.nextAdd(from, to);
    }

    public void nextSet(int idx, E old) {
        this.nextRemove(idx, old);
        this.nextAdd(idx, idx + 1);
    }

    public void nextUpdate(int idx) {
        SubChange<E> last;
        this.checkState();
        if (this.updateChanges == null) {
            this.updateChanges = new ArrayList<SubChange<E>>();
        }
        SubChange<E> subChange = last = this.updateChanges.isEmpty() ? null : this.updateChanges.get(this.updateChanges.size() - 1);
        if (last != null && last.to == idx) {
            last.to = idx + 1;
        } else {
            this.insertUpdate(idx);
        }
    }

    private void commit() {
        boolean updateNotEmpty;
        boolean addRemoveNotEmpty = this.addRemoveChanges != null && !this.addRemoveChanges.isEmpty();
        boolean bl = updateNotEmpty = this.updateChanges != null && !this.updateChanges.isEmpty();
        if (this.changeLock == 0 && (addRemoveNotEmpty || updateNotEmpty || this.permutationChange != null)) {
            int totalSize = (this.updateChanges != null ? this.updateChanges.size() : 0) + (this.addRemoveChanges != null ? this.addRemoveChanges.size() : 0) + (this.permutationChange != null ? 1 : 0);
            if (totalSize == 1) {
                if (addRemoveNotEmpty) {
                    this.list.fireChange(new SingleChange<E>(ListChangeBuilder.finalizeSubChange(this.addRemoveChanges.get(0)), this.list));
                    this.addRemoveChanges.clear();
                } else if (updateNotEmpty) {
                    this.list.fireChange(new SingleChange<E>(ListChangeBuilder.finalizeSubChange(this.updateChanges.get(0)), this.list));
                    this.updateChanges.clear();
                } else {
                    this.list.fireChange(new SingleChange<E>(ListChangeBuilder.finalizeSubChange(this.permutationChange), this.list));
                    this.permutationChange = null;
                }
            } else {
                SubChange<E> change;
                int i;
                int sz;
                int removed;
                if (updateNotEmpty) {
                    removed = this.compress(this.updateChanges);
                    totalSize -= removed;
                }
                if (addRemoveNotEmpty) {
                    removed = this.compress(this.addRemoveChanges);
                    totalSize -= removed;
                }
                SubChange[] array = new SubChange[totalSize];
                int ptr = 0;
                if (this.permutationChange != null) {
                    array[ptr++] = this.permutationChange;
                }
                if (addRemoveNotEmpty) {
                    sz = this.addRemoveChanges.size();
                    for (i = 0; i < sz; ++i) {
                        change = this.addRemoveChanges.get(i);
                        if (change == null) continue;
                        array[ptr++] = change;
                    }
                }
                if (updateNotEmpty) {
                    sz = this.updateChanges.size();
                    for (i = 0; i < sz; ++i) {
                        change = this.updateChanges.get(i);
                        if (change == null) continue;
                        array[ptr++] = change;
                    }
                }
                this.list.fireChange(new IterableChange<E>(ListChangeBuilder.finalizeSubChangeArray(array), this.list));
                if (this.addRemoveChanges != null) {
                    this.addRemoveChanges.clear();
                }
                if (this.updateChanges != null) {
                    this.updateChanges.clear();
                }
                this.permutationChange = null;
            }
        }
    }

    public void beginChange() {
        ++this.changeLock;
    }

    public void endChange() {
        if (this.changeLock <= 0) {
            throw new IllegalStateException("Called endChange before beginChange");
        }
        --this.changeLock;
        this.commit();
    }

    private static <E> SubChange<E>[] finalizeSubChangeArray(SubChange<E>[] changes) {
        for (SubChange<E> c : changes) {
            ListChangeBuilder.finalizeSubChange(c);
        }
        return changes;
    }

    private static <E> SubChange<E> finalizeSubChange(SubChange<E> c) {
        if (c.perm == null) {
            c.perm = EMPTY_PERM;
        }
        c.removed = c.removed == null ? Collections.emptyList() : Collections.unmodifiableList(c.removed);
        return c;
    }

    private static class SubChange<E> {
        int from;
        int to;
        List<E> removed;
        int[] perm;
        boolean updated;

        public SubChange(int from, int to, List<E> removed, int[] perm, boolean updated) {
            this.from = from;
            this.to = to;
            this.removed = removed;
            this.perm = perm;
            this.updated = updated;
        }
    }

    private static class SingleChange<E>
    extends ListChangeListener.Change<E> {
        private final SubChange<E> change;
        private boolean onChange;

        public SingleChange(SubChange<E> change, ObservableListBase<E> list) {
            super(list);
            this.change = change;
        }

        @Override
        public boolean next() {
            if (this.onChange) {
                return false;
            }
            this.onChange = true;
            return true;
        }

        @Override
        public void reset() {
            this.onChange = false;
        }

        @Override
        public int getFrom() {
            this.checkState();
            return this.change.from;
        }

        @Override
        public int getTo() {
            this.checkState();
            return this.change.to;
        }

        @Override
        public List<E> getRemoved() {
            this.checkState();
            return this.change.removed;
        }

        @Override
        protected int[] getPermutation() {
            this.checkState();
            return this.change.perm;
        }

        @Override
        public boolean wasUpdated() {
            this.checkState();
            return this.change.updated;
        }

        private void checkState() {
            if (!this.onChange) {
                throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
            }
        }

        public String toString() {
            String ret = this.change.perm.length != 0 ? ChangeHelper.permChangeToString(this.change.perm) : (this.change.updated ? ChangeHelper.updateChangeToString(this.change.from, this.change.to) : ChangeHelper.addRemoveChangeToString(this.change.from, this.change.to, this.getList(), this.change.removed));
            return "{ " + ret + " }";
        }
    }

    private static class IterableChange<E>
    extends ListChangeListener.Change<E> {
        private SubChange[] changes;
        private int cursor = -1;

        private IterableChange(SubChange[] changes, ObservableList<E> list) {
            super(list);
            this.changes = changes;
        }

        @Override
        public boolean next() {
            if (this.cursor + 1 < this.changes.length) {
                ++this.cursor;
                return true;
            }
            return false;
        }

        @Override
        public void reset() {
            this.cursor = -1;
        }

        @Override
        public int getFrom() {
            this.checkState();
            return this.changes[this.cursor].from;
        }

        @Override
        public int getTo() {
            this.checkState();
            return this.changes[this.cursor].to;
        }

        @Override
        public List<E> getRemoved() {
            this.checkState();
            return this.changes[this.cursor].removed;
        }

        @Override
        protected int[] getPermutation() {
            this.checkState();
            return this.changes[this.cursor].perm;
        }

        @Override
        public boolean wasUpdated() {
            this.checkState();
            return this.changes[this.cursor].updated;
        }

        private void checkState() {
            if (this.cursor == -1) {
                throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            b.append("{ ");
            for (int c = 0; c < this.changes.length; ++c) {
                if (this.changes[c].perm.length != 0) {
                    b.append(ChangeHelper.permChangeToString(this.changes[c].perm));
                } else if (this.changes[c].updated) {
                    b.append(ChangeHelper.updateChangeToString(this.changes[c].from, this.changes[c].to));
                } else {
                    b.append(ChangeHelper.addRemoveChangeToString(this.changes[c].from, this.changes[c].to, this.getList(), this.changes[c].removed));
                }
                if (c == this.changes.length - 1) continue;
                b.append(", ");
            }
            b.append(" }");
            return b.toString();
        }
    }
}

