/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.builder;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.shape.VertexFormat;
import javafx.util.Builder;

public class TriangleMeshBuilder
extends TreeMap<String, Object>
implements Builder<TriangleMesh> {
    private static final String VALUE_SEPARATOR_REGEX = "[,\\s]+";
    private float[] points;
    private float[] texCoords;
    private float[] normals;
    private int[] faces;
    private int[] faceSmoothingGroups;
    private VertexFormat vertexFormat;

    public TriangleMesh build() {
        TriangleMesh mesh = new TriangleMesh();
        if (this.points != null) {
            mesh.getPoints().setAll(this.points);
        }
        if (this.texCoords != null) {
            mesh.getTexCoords().setAll(this.texCoords);
        }
        if (this.faces != null) {
            mesh.getFaces().setAll(this.faces);
        }
        if (this.faceSmoothingGroups != null) {
            mesh.getFaceSmoothingGroups().setAll(this.faceSmoothingGroups);
        }
        if (this.normals != null) {
            mesh.getNormals().setAll(this.normals);
        }
        if (this.vertexFormat != null) {
            mesh.setVertexFormat(this.vertexFormat);
        }
        return mesh;
    }

    @Override
    public Object put(String key, Object value) {
        if ("points".equalsIgnoreCase(key)) {
            String[] split = ((String)value).split(VALUE_SEPARATOR_REGEX);
            this.points = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.points[i] = Float.parseFloat(split[i]);
            }
        } else if ("texcoords".equalsIgnoreCase(key)) {
            String[] split = ((String)value).split(VALUE_SEPARATOR_REGEX);
            this.texCoords = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.texCoords[i] = Float.parseFloat(split[i]);
            }
        } else if ("faces".equalsIgnoreCase(key)) {
            String[] split = ((String)value).split(VALUE_SEPARATOR_REGEX);
            this.faces = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.faces[i] = Integer.parseInt(split[i]);
            }
        } else if ("facesmoothinggroups".equalsIgnoreCase(key)) {
            String[] split = ((String)value).split(VALUE_SEPARATOR_REGEX);
            this.faceSmoothingGroups = new int[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.faceSmoothingGroups[i] = Integer.parseInt(split[i]);
            }
        } else if ("normals".equalsIgnoreCase(key)) {
            String[] split = ((String)value).split(VALUE_SEPARATOR_REGEX);
            this.normals = new float[split.length];
            for (int i = 0; i < split.length; ++i) {
                this.normals[i] = Float.parseFloat(split[i]);
            }
        } else if ("vertexformat".equalsIgnoreCase(key)) {
            if (value instanceof VertexFormat) {
                this.vertexFormat = (VertexFormat)value;
            } else if ("point_texcoord".equalsIgnoreCase((String)value)) {
                this.vertexFormat = VertexFormat.POINT_TEXCOORD;
            } else if ("point_normal_texcoord".equalsIgnoreCase((String)value)) {
                this.vertexFormat = VertexFormat.POINT_NORMAL_TEXCOORD;
            }
        }
        return super.put(key.toLowerCase(Locale.ROOT), value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return super.entrySet();
    }
}

