/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.KeyPath;
import java.util.List;
import java.util.function.Function;

public final class UnaryExpression<U, T>
extends Expression<T> {
    private final Expression<U> operand;
    private final Function<U, T> evaluator;

    public UnaryExpression(Expression<U> operand, Function<U, T> evaluator) {
        if (operand == null) {
            throw new NullPointerException();
        }
        this.operand = operand;
        this.evaluator = evaluator;
    }

    @Override
    public T evaluate(Object namespace) {
        return this.evaluator.apply(this.operand.evaluate(namespace));
    }

    @Override
    public void update(Object namespace, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isDefined(Object namespace) {
        return this.operand.isDefined(namespace);
    }

    @Override
    public boolean isLValue() {
        return false;
    }

    @Override
    protected void getArguments(List<KeyPath> arguments) {
        this.operand.getArguments(arguments);
    }
}

