/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.builder;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.util.Builder;

public final class JavaFXFontBuilder
extends AbstractMap<String, Object>
implements Builder<Font> {
    private String name = null;
    private double size = 12.0;
    private FontWeight weight = null;
    private FontPosture posture = null;
    private URL url = null;

    public Font build() {
        Font f;
        if (this.url != null) {
            InputStream in = null;
            try {
                in = this.url.openStream();
                f = Font.loadFont((InputStream)in, (double)this.size);
            }
            catch (Exception e) {
                throw new RuntimeException("Load of font file failed from " + this.url, e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.weight == null && this.posture == null) {
            f = new Font(this.name, this.size);
        } else {
            if (this.weight == null) {
                this.weight = FontWeight.NORMAL;
            }
            if (this.posture == null) {
                this.posture = FontPosture.REGULAR;
            }
            f = Font.font((String)this.name, (FontWeight)this.weight, (FontPosture)this.posture, (double)this.size);
        }
        return f;
    }

    @Override
    public Object put(String key, Object value) {
        if ("name".equals(key)) {
            if (value instanceof URL) {
                this.url = (URL)value;
            } else {
                this.name = (String)value;
            }
        } else if ("size".equals(key)) {
            this.size = Double.parseDouble((String)value);
        } else if ("style".equals(key)) {
            String style = (String)value;
            if (style != null && style.length() > 0) {
                boolean isWeightSet = false;
                StringTokenizer st = new StringTokenizer(style, " ");
                while (st.hasMoreTokens()) {
                    FontWeight fw;
                    String stylePart = st.nextToken();
                    if (!isWeightSet && (fw = FontWeight.findByName((String)stylePart)) != null) {
                        this.weight = fw;
                        isWeightSet = true;
                        continue;
                    }
                    FontPosture fp = FontPosture.findByName((String)stylePart);
                    if (fp == null) continue;
                    this.posture = fp;
                }
            }
        } else if ("url".equals(key)) {
            if (value instanceof URL) {
                this.url = (URL)value;
            } else {
                try {
                    this.url = new URL(value.toString());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Invalid url " + value.toString(), e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown Font property: " + key);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public Object get(Object key) {
        return null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

