/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml;

import com.sun.javafx.fxml.MethodHelper;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;

public class ModuleHelper {
    private static final Method getModuleMethod;
    private static final Method getResourceAsStreamMethod;
    private static final boolean verbose;

    public static Object getModule(Class clazz) {
        if (getModuleMethod != null) {
            try {
                return getModuleMethod.invoke((Object)clazz, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public static InputStream getResourceAsStream(Object thisModule, String name) {
        if (getResourceAsStreamMethod != null) {
            try {
                return (InputStream)getResourceAsStreamMethod.invoke(thisModule, name);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public static Object invoke(Method m, Object obj, Object[] params) throws InvocationTargetException, IllegalAccessException {
        Object thisModule = ModuleHelper.getModule(ModuleHelper.class);
        Object methodModule = ModuleHelper.getModule(m.getDeclaringClass());
        if (verbose) {
            System.out.println("thisModule = " + thisModule);
            System.out.println("methodModule = " + methodModule);
            System.out.println("m = " + m);
        }
        if (methodModule != thisModule) {
            return MethodHelper.invoke(m, obj, params);
        }
        return m.invoke(obj, params);
    }

    static {
        boolean tmp = AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.verbose"));
        verbose = tmp;
        if (verbose) {
            System.err.println(ModuleHelper.class.getName() + " : <clinit>");
        }
        Method mGetModule = null;
        Method mGetResourceAsStream = null;
        try {
            mGetModule = Class.class.getMethod("getModule", new Class[0]);
            Class<?> moduleClass = mGetModule.getReturnType();
            mGetResourceAsStream = moduleClass.getMethod("getResourceAsStream", String.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getModuleMethod = mGetModule;
        getResourceAsStreamMethod = mGetResourceAsStream;
        if (verbose) {
            System.err.println("getModuleMethod = " + getModuleMethod);
            System.err.println("getResourceAsStreamMethod = " + getResourceAsStreamMethod);
        }
    }
}

