/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Pixels;
import com.sun.javafx.image.PixelUtils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Objects;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;
import javafx.stage.Screen;

public abstract class GlassRobot {
    public static final int MOUSE_LEFT_BTN = 1;
    public static final int MOUSE_RIGHT_BTN = 2;
    public static final int MOUSE_MIDDLE_BTN = 4;
    public static final int MOUSE_BACK_BTN = 8;
    public static final int MOUSE_FORWARD_BTN = 16;

    public abstract void create();

    public abstract void destroy();

    public abstract void keyPress(KeyCode var1);

    public abstract void keyRelease(KeyCode var1);

    public abstract double getMouseX();

    public abstract double getMouseY();

    public abstract void mouseMove(double var1, double var3);

    public abstract void mousePress(MouseButton ... var1);

    public abstract void mouseRelease(MouseButton ... var1);

    public abstract void mouseWheel(int var1);

    public abstract Color getPixelColor(double var1, double var3);

    public void getScreenCapture(int x, int y, int width, int height, int[] data, boolean scaleToFit) {
        throw new InternalError("not implemented");
    }

    public WritableImage getScreenCapture(WritableImage image, double x, double y, double width, double height, boolean scaleToFit) {
        int dh;
        int dw;
        int[] data;
        if (width <= 0.0) {
            throw new IllegalArgumentException("width must be > 0");
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("height must be > 0");
        }
        Screen primaryScreen = Screen.getPrimary();
        Objects.requireNonNull(primaryScreen);
        double outputScaleX = primaryScreen.getOutputScaleX();
        double outputScaleY = primaryScreen.getOutputScaleY();
        if (outputScaleX == 1.0 && outputScaleY == 1.0) {
            data = new int[(int)(width * height)];
            this.getScreenCapture((int)x, (int)y, (int)width, (int)height, data, scaleToFit);
            dw = (int)width;
            dh = (int)height;
        } else {
            int pminx = (int)Math.floor(x * outputScaleX);
            int pminy = (int)Math.floor(y * outputScaleY);
            int pmaxx = (int)Math.ceil((x + width) * outputScaleX);
            int pmaxy = (int)Math.ceil((y + height) * outputScaleY);
            int pwidth = pmaxx - pminx;
            int pheight = pmaxy - pminy;
            int[] tmpdata = new int[pwidth * pheight];
            this.getScreenCapture(pminx, pminy, pwidth, pheight, tmpdata, scaleToFit);
            dw = pwidth;
            dh = pheight;
            if (!scaleToFit) {
                data = tmpdata;
            } else {
                data = new int[(int)(width * height)];
                int index = 0;
                int iy = 0;
                while ((double)iy < height) {
                    double rely = (y + (double)iy + 0.5) * outputScaleY - (double)((float)pminy + 0.5f);
                    int irely = (int)Math.floor(rely);
                    int fracty = (int)((rely - (double)irely) * 256.0);
                    int ix = 0;
                    while ((double)ix < width) {
                        double relx = (x + (double)ix + 0.5) * outputScaleX - (double)((float)pminx + 0.5f);
                        int irelx = (int)Math.floor(relx);
                        int fractx = (int)((relx - (double)irelx) * 256.0);
                        data[index++] = GlassRobot.interp(tmpdata, irelx, irely, pwidth, pheight, fractx, fracty);
                        ++ix;
                    }
                    ++iy;
                }
                dw = (int)width;
                dh = (int)height;
            }
        }
        return GlassRobot.convertFromPixels(image, Application.GetApplication().createPixels(dw, dh, IntBuffer.wrap(data)));
    }

    public static int convertToRobotMouseButton(MouseButton[] buttons) {
        int ret = 0;
        block7: for (MouseButton button : buttons) {
            switch (button) {
                case PRIMARY: {
                    ret |= 1;
                    continue block7;
                }
                case SECONDARY: {
                    ret |= 2;
                    continue block7;
                }
                case MIDDLE: {
                    ret |= 4;
                    continue block7;
                }
                case BACK: {
                    ret |= 8;
                    continue block7;
                }
                case FORWARD: {
                    ret |= 0x10;
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("MouseButton: " + button + " not supported by Robot");
                }
            }
        }
        return ret;
    }

    public static Color convertFromIntArgb(int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new Color((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, (double)alpha / 255.0);
    }

    protected static WritableImage convertFromPixels(WritableImage image, Pixels pixels) {
        int bytesPerComponent;
        Objects.requireNonNull(pixels);
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        if (image == null || image.getWidth() != (double)width || image.getHeight() != (double)height) {
            image = new WritableImage(width, height);
        }
        if ((bytesPerComponent = pixels.getBytesPerComponent()) == 4) {
            IntBuffer intBuffer = (IntBuffer)pixels.getPixels();
            GlassRobot.writeIntBufferToImage(intBuffer, image);
        } else if (bytesPerComponent == 1) {
            ByteBuffer byteBuffer = (ByteBuffer)pixels.getPixels();
            GlassRobot.writeByteBufferToImage(byteBuffer, image);
        } else {
            throw new IllegalArgumentException("bytesPerComponent must be either 4 or 1 but was: " + bytesPerComponent);
        }
        return image;
    }

    private static void writeIntBufferToImage(IntBuffer intBuffer, WritableImage image) {
        Objects.requireNonNull(image);
        PixelWriter pixelWriter = image.getPixelWriter();
        double width = image.getWidth();
        double height = image.getHeight();
        int y = 0;
        while ((double)y < height) {
            int x = 0;
            while ((double)x < width) {
                int argb = intBuffer.get();
                pixelWriter.setArgb(x, y, argb);
                ++x;
            }
            ++y;
        }
    }

    private static void writeByteBufferToImage(ByteBuffer byteBuffer, WritableImage image) {
        Objects.requireNonNull(image);
        PixelWriter pixelWriter = image.getPixelWriter();
        double width = image.getWidth();
        double height = image.getHeight();
        int format = Pixels.getNativeFormat();
        int y = 0;
        while ((double)y < height) {
            int x = 0;
            while ((double)x < width) {
                if (format == 1) {
                    pixelWriter.setArgb(x, y, PixelUtils.PretoNonPre(GlassRobot.bgraPreToRgbaPre(byteBuffer.getInt())));
                } else if (format == 2) {
                    pixelWriter.setArgb(x, y, byteBuffer.getInt());
                } else {
                    throw new IllegalArgumentException("format must be either BYTE_BGRA_PRE or BYTE_ARGB");
                }
                ++x;
            }
            ++y;
        }
    }

    private static int bgraPreToRgbaPre(int bgraPre) {
        return Integer.reverseBytes(bgraPre);
    }

    private static int interp(int[] pixels, int x, int y, int w, int h, int fractx1, int fracty1) {
        int rgb00;
        int fractx0 = 256 - fractx1;
        int fracty0 = 256 - fracty1;
        int i = y * w + x;
        int n = rgb00 = x < 0 || y < 0 || x >= w || y >= h ? 0 : pixels[i];
        if (fracty1 == 0) {
            if (fractx1 == 0) {
                return rgb00;
            }
            int rgb10 = y < 0 || x + 1 >= w || y >= h ? 0 : pixels[i + 1];
            return GlassRobot.interp(rgb00, rgb10, fractx0, fractx1);
        }
        if (fractx1 == 0) {
            int rgb01 = x < 0 || x >= w || y + 1 >= h ? 0 : pixels[i + w];
            return GlassRobot.interp(rgb00, rgb01, fracty0, fracty1);
        }
        int rgb10 = y < 0 || x + 1 >= w || y >= h ? 0 : pixels[i + 1];
        int rgb01 = x < 0 || x >= w || y + 1 >= h ? 0 : pixels[i + w];
        int rgb11 = x + 1 >= w || y + 1 >= h ? 0 : pixels[i + w + 1];
        return GlassRobot.interp(GlassRobot.interp(rgb00, rgb10, fractx0, fractx1), GlassRobot.interp(rgb01, rgb11, fractx0, fractx1), fracty0, fracty1);
    }

    private static int interp(int rgb0, int rgb1, int fract0, int fract1) {
        int a0 = rgb0 >> 24 & 0xFF;
        int r0 = rgb0 >> 16 & 0xFF;
        int g0 = rgb0 >> 8 & 0xFF;
        int b0 = rgb0 & 0xFF;
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int a = a0 * fract0 + a1 * fract1 >> 8;
        int r = r0 * fract0 + r1 * fract1 >> 8;
        int g = g0 * fract0 + g1 * fract1 >> 8;
        int b = b0 * fract0 + b1 * fract1 >> 8;
        return a << 24 | r << 16 | g << 8 | b;
    }
}

