/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean verbose = false;
    private static boolean usingModules = false;
    private static File libDir = null;
    private static String libPrefix = "";
    private static String libSuffix = "";

    public static synchronized void loadLibrary(String libname) {
        if (!loaded.contains(libname)) {
            StackWalker walker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
            Class<?> caller = walker.getCallerClass();
            NativeLibLoader.loadLibraryInternal(libname, null, caller);
            loaded.add(libname);
        }
    }

    public static synchronized void loadLibrary(String libname, List<String> dependencies) {
        if (!loaded.contains(libname)) {
            StackWalker walker = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));
            Class<?> caller = walker.getCallerClass();
            NativeLibLoader.loadLibraryInternal(libname, dependencies, caller);
            loaded.add(libname);
        }
    }

    private static String[] initializePath(String propname) {
        String ldpath = System.getProperty(propname, "");
        String ps = File.pathSeparator;
        int ldlen = ldpath.length();
        int i = ldpath.indexOf(ps);
        int n = 0;
        while (i >= 0) {
            ++n;
            i = ldpath.indexOf(ps, i + 1);
        }
        String[] paths = new String[n + 1];
        i = 0;
        n = 0;
        int j = ldpath.indexOf(ps);
        while (j >= 0) {
            if (j - i > 0) {
                paths[n++] = ldpath.substring(i, j);
            } else if (j - i == 0) {
                paths[n++] = ".";
            }
            i = j + 1;
            j = ldpath.indexOf(ps, i);
        }
        paths[n] = ldpath.substring(i, ldlen);
        return paths;
    }

    private static void loadLibraryInternal(String libraryName, List<String> dependencies, Class caller) {
        try {
            NativeLibLoader.loadLibraryFullPath(libraryName);
        }
        catch (UnsatisfiedLinkError ex) {
            if (verbose && !usingModules) {
                System.err.println("WARNING: " + ex);
            }
            if (NativeLibLoader.loadLibraryFromResource(libraryName, dependencies, caller)) {
                return;
            }
            String[] libPath = NativeLibLoader.initializePath("java.library.path");
            for (int i = 0; i < libPath.length; ++i) {
                try {
                    Object path = libPath[i];
                    if (!((String)path).endsWith(File.separator)) {
                        path = (String)path + File.separator;
                    }
                    String fileName = System.mapLibraryName(libraryName);
                    File libFile = new File((String)path + fileName);
                    System.load(libFile.getAbsolutePath());
                    if (verbose) {
                        System.err.println("Loaded " + libFile.getAbsolutePath() + " from java.library.path");
                    }
                    return;
                }
                catch (UnsatisfiedLinkError path) {
                    continue;
                }
            }
            try {
                System.loadLibrary(libraryName);
                if (verbose) {
                    System.err.println("System.loadLibrary(" + libraryName + ") succeeded");
                }
            }
            catch (UnsatisfiedLinkError ex2) {
                if ("ios".equals(System.getProperty("os.name").toLowerCase(Locale.ROOT)) && libraryName.contains("-")) {
                    libraryName = libraryName.replace("-", "_");
                    System.loadLibrary(libraryName);
                    return;
                }
                throw ex2;
            }
        }
    }

    private static boolean loadLibraryFromResource(String libraryName, List<String> dependencies, Class caller) {
        return NativeLibLoader.installLibraryFromResource(libraryName, dependencies, caller, true);
    }

    private static boolean installLibraryFromResource(String libraryName, List<String> dependencies, Class caller, boolean load) {
        try {
            String reallib;
            InputStream is;
            if (dependencies != null) {
                for (String dep : dependencies) {
                    boolean bl = NativeLibLoader.installLibraryFromResource(dep, null, caller, false);
                }
            }
            if ((is = caller.getResourceAsStream(reallib = "/" + System.mapLibraryName(libraryName))) != null) {
                String fp = NativeLibLoader.cacheLibrary(is, reallib, caller);
                if (load) {
                    System.load(fp);
                    if (verbose) {
                        System.err.println("Loaded library " + reallib + " from resource");
                    }
                } else if (verbose) {
                    System.err.println("Unpacked library " + reallib + " from resource");
                }
                return true;
            }
        }
        catch (Throwable t) {
            System.err.println("Loading library " + libraryName + " from resource failed: " + t);
            t.printStackTrace();
        }
        return false;
    }

    private static String cacheLibrary(InputStream is, String name, Class caller) throws IOException {
        String jfxVersion = System.getProperty("javafx.version", "versionless");
        Object userCache = System.getProperty("javafx.cachedir", "");
        if (((String)userCache).isEmpty()) {
            userCache = System.getProperty("user.home") + "/.openjfx/cache/" + jfxVersion;
        }
        File cacheDir = new File((String)userCache);
        boolean cacheDirOk = true;
        if (cacheDir.exists()) {
            if (!cacheDir.isDirectory()) {
                System.err.println("Cache exists but is not a directory: " + cacheDir);
                cacheDirOk = false;
            }
        } else if (!cacheDir.mkdirs()) {
            System.err.println("Can not create cache at " + cacheDir);
            cacheDirOk = false;
        }
        if (!cacheDir.canRead()) {
            cacheDirOk = false;
        }
        if (!cacheDirOk) {
            String username = System.getProperty("user.name", "anonymous");
            String tmpCache = System.getProperty("java.io.tmpdir") + "/.openjfx_" + username + "/cache/" + jfxVersion;
            cacheDir = new File(tmpCache);
            if (cacheDir.exists()) {
                if (!cacheDir.isDirectory()) {
                    throw new IOException("Cache exists but is not a directory: " + cacheDir);
                }
            } else if (!cacheDir.mkdirs()) {
                throw new IOException("Can not create cache at " + cacheDir);
            }
        }
        File f = new File(cacheDir, name);
        boolean write = true;
        if (f.exists()) {
            byte[] isHash;
            try {
                DigestInputStream dis = new DigestInputStream(is, MessageDigest.getInstance("MD5"));
                dis.getMessageDigest().reset();
                byte[] buffer = new byte[4096];
                while (dis.read(buffer) != -1) {
                }
                isHash = dis.getMessageDigest().digest();
                is.close();
                is = caller.getResourceAsStream(name);
            }
            catch (NoSuchAlgorithmException nsa) {
                isHash = new byte[1];
            }
            byte[] fileHash = NativeLibLoader.calculateCheckSum(f);
            if (!Arrays.equals(isHash, fileHash)) {
                Files.delete(f.toPath());
            } else {
                write = false;
            }
        }
        if (write) {
            Path path = f.toPath();
            Files.copy(is, path, new CopyOption[0]);
        }
        String fp = f.getAbsolutePath();
        return fp;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static byte[] calculateCheckSum(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            byte[] byArray;
            try (DigestInputStream dis = new DigestInputStream(stream, MessageDigest.getInstance("MD5"));){
                dis.getMessageDigest().reset();
                byte[] buffer = new byte[4096];
                while (dis.read(buffer) != -1) {
                }
                byArray = dis.getMessageDigest().digest();
            }
            return byArray;
        }
        catch (IOException | IllegalArgumentException | SecurityException | NoSuchAlgorithmException exception) {
            return new byte[0];
        }
    }

    private static void loadLibraryFullPath(String libraryName) {
        try {
            if (usingModules) {
                throw new UnsatisfiedLinkError("ignored");
            }
            if (libDir == null) {
                Class<NativeLibLoader> theClass = NativeLibLoader.class;
                String theClassFile = "NativeLibLoader.class";
                String classUrlString = theClass.getResource(theClassFile).toString();
                if (classUrlString.startsWith("jrt:")) {
                    usingModules = true;
                    throw new UnsatisfiedLinkError("ignored");
                }
                if (!classUrlString.startsWith("jar:file:") || classUrlString.indexOf(33) == -1) {
                    throw new UnsatisfiedLinkError("Invalid URL for class: " + classUrlString);
                }
                String tmpStr = classUrlString.substring(4, classUrlString.lastIndexOf(33));
                int lastIndexOfSlash = Math.max(tmpStr.lastIndexOf(47), tmpStr.lastIndexOf(92));
                String osName = System.getProperty("os.name");
                String relativeDir = null;
                if (osName.startsWith("Windows")) {
                    relativeDir = "../bin";
                } else if (osName.startsWith("Mac")) {
                    relativeDir = ".";
                } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
                    relativeDir = ".";
                }
                String libDirUrlString = tmpStr.substring(0, lastIndexOfSlash) + "/" + relativeDir;
                libDir = new File(new URI(libDirUrlString).getPath());
                if (osName.startsWith("Windows")) {
                    libPrefix = "";
                    libSuffix = ".dll";
                } else if (osName.startsWith("Mac")) {
                    libPrefix = "lib";
                    libSuffix = ".dylib";
                } else if (osName.startsWith("Linux") || osName.startsWith("FreeBSD")) {
                    libPrefix = "lib";
                    libSuffix = ".so";
                }
            }
            File libFile = new File(libDir, libPrefix + libraryName + libSuffix);
            String libFileName = libFile.getCanonicalPath();
            System.load(libFileName);
            if (verbose) {
                System.err.println("Loaded " + libFile.getAbsolutePath() + " from relative path");
            }
        }
        catch (Exception e) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
        }
    }

    static {
        AccessController.doPrivileged(() -> {
            verbose = Boolean.getBoolean("javafx.verbose");
            return null;
        });
    }
}

