/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.directwrite;

import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.font.directwrite.D2D1_COLOR_F;
import com.sun.javafx.font.directwrite.D2D1_MATRIX_3X2_F;
import com.sun.javafx.font.directwrite.D2D1_POINT_2F;
import com.sun.javafx.font.directwrite.D2D1_RENDER_TARGET_PROPERTIES;
import com.sun.javafx.font.directwrite.DWFactory;
import com.sun.javafx.font.directwrite.DWFontStrike;
import com.sun.javafx.font.directwrite.DWRITE_GLYPH_METRICS;
import com.sun.javafx.font.directwrite.DWRITE_GLYPH_RUN;
import com.sun.javafx.font.directwrite.DWRITE_MATRIX;
import com.sun.javafx.font.directwrite.ID2D1Brush;
import com.sun.javafx.font.directwrite.ID2D1Factory;
import com.sun.javafx.font.directwrite.ID2D1RenderTarget;
import com.sun.javafx.font.directwrite.IDWriteFactory;
import com.sun.javafx.font.directwrite.IDWriteFontFace;
import com.sun.javafx.font.directwrite.IDWriteGlyphRunAnalysis;
import com.sun.javafx.font.directwrite.IWICBitmap;
import com.sun.javafx.font.directwrite.IWICBitmapLock;
import com.sun.javafx.font.directwrite.IWICImagingFactory;
import com.sun.javafx.font.directwrite.RECT;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;

public class DWGlyph
implements Glyph {
    private DWFontStrike strike;
    private DWRITE_GLYPH_METRICS metrics;
    private DWRITE_GLYPH_RUN run;
    private float pixelXAdvance;
    private float pixelYAdvance;
    private RECT rect;
    private boolean drawShapes;
    private byte[][] pixelData;
    private RECT[] rects;
    private static final boolean CACHE_TARGET = true;
    private static IWICBitmap cachedBitmap;
    private static ID2D1RenderTarget cachedTarget;
    private static final int BITMAP_WIDTH = 256;
    private static final int BITMAP_HEIGHT = 256;
    private static final int BITMAP_PIXEL_FORMAT = 8;
    private static D2D1_COLOR_F BLACK;
    private static D2D1_COLOR_F WHITE;
    private static D2D1_MATRIX_3X2_F D2D2_MATRIX_IDENTITY;
    public static final int SHORTMASK = 65535;

    DWGlyph(DWFontStrike strike, int glyphCode, boolean drawShapes) {
        this.strike = strike;
        this.drawShapes = drawShapes;
        int size = DWFontStrike.SUBPIXEL_Y ? 9 : 3;
        this.pixelData = new byte[size][];
        this.rects = new RECT[size];
        IDWriteFontFace face = strike.getFontFace();
        this.run = new DWRITE_GLYPH_RUN();
        this.run.fontFace = face != null ? face.ptr : 0L;
        this.run.fontEmSize = strike.getSize();
        this.run.glyphIndices = (short)glyphCode;
        this.run.glyphAdvances = 0.0f;
        this.run.advanceOffset = 0.0f;
        this.run.ascenderOffset = 0.0f;
        this.run.bidiLevel = 0;
        this.run.isSideways = false;
    }

    void checkMetrics() {
        if (this.metrics != null) {
            return;
        }
        IDWriteFontFace face = this.strike.getFontFace();
        if (face == null) {
            return;
        }
        this.metrics = face.GetDesignGlyphMetrics(this.run.glyphIndices, false);
        if (this.metrics != null) {
            float upem = this.strike.getUpem();
            this.pixelXAdvance = (float)this.metrics.advanceWidth * this.strike.getSize() / upem;
            this.pixelYAdvance = 0.0f;
            if (this.strike.matrix != null) {
                Point2D pt = new Point2D(this.pixelXAdvance, this.pixelYAdvance);
                this.strike.getTransform().transform(pt, pt);
                this.pixelXAdvance = pt.x;
                this.pixelYAdvance = pt.y;
            }
        }
    }

    void checkBounds() {
        if (this.rect != null) {
            return;
        }
        int textureType = 1;
        IDWriteGlyphRunAnalysis runAnalysis = this.createAnalysis(0.0f, 0.0f);
        if (runAnalysis != null) {
            this.rect = runAnalysis.GetAlphaTextureBounds(textureType);
            if (this.rect == null || this.rect.right - this.rect.left == 0 || this.rect.bottom - this.rect.top == 0) {
                this.rect = runAnalysis.GetAlphaTextureBounds(0);
            }
            runAnalysis.Release();
        }
        if (this.rect == null) {
            this.rect = new RECT();
        } else {
            --this.rect.left;
            --this.rect.top;
            ++this.rect.right;
            ++this.rect.bottom;
        }
    }

    byte[] getLCDMask(float subPixelX, float subPixelY) {
        IDWriteGlyphRunAnalysis runAnalysis = this.createAnalysis(subPixelX, subPixelY);
        byte[] buffer = null;
        if (runAnalysis != null) {
            int textureType = 1;
            this.rect = runAnalysis.GetAlphaTextureBounds(textureType);
            if (this.rect != null && this.rect.right - this.rect.left != 0 && this.rect.bottom - this.rect.top != 0) {
                buffer = runAnalysis.CreateAlphaTexture(textureType, this.rect);
            } else {
                this.rect = runAnalysis.GetAlphaTextureBounds(0);
                if (this.rect != null && this.rect.right - this.rect.left != 0 && this.rect.bottom - this.rect.top != 0) {
                    buffer = this.getD2DMask(subPixelX, subPixelY, true);
                }
            }
            runAnalysis.Release();
        }
        if (buffer == null) {
            buffer = new byte[]{};
            this.rect = new RECT();
        }
        return buffer;
    }

    byte[] getD2DMask(float subPixelX, float subPixelY, boolean lcd) {
        D2D1_MATRIX_3X2_F transform;
        ID2D1RenderTarget target;
        IWICBitmap bitmap;
        boolean cache;
        this.checkBounds();
        if (this.getWidth() == 0 || this.getHeight() == 0 || this.run.fontFace == 0L) {
            return new byte[0];
        }
        float glyphX = this.rect.left;
        float glyphY = this.rect.top;
        int w = this.rect.right - this.rect.left;
        int h = this.rect.bottom - this.rect.top;
        boolean bl = cache = 256 >= w && 256 >= h;
        if (cache) {
            bitmap = this.getCachedBitmap();
            target = this.getCachedRenderingTarget();
        } else {
            bitmap = this.createBitmap(w, h);
            target = this.createRenderingTarget(bitmap);
        }
        if (bitmap == null || target == null) {
            return new byte[0];
        }
        DWRITE_MATRIX matrix = this.strike.matrix;
        if (matrix != null) {
            transform = new D2D1_MATRIX_3X2_F(matrix.m11, matrix.m12, matrix.m21, matrix.m22, -glyphX + subPixelX, -glyphY + subPixelY);
            glyphY = 0.0f;
            glyphX = 0.0f;
        } else {
            transform = D2D2_MATRIX_IDENTITY;
            glyphX -= subPixelX;
            glyphY -= subPixelY;
        }
        target.BeginDraw();
        target.SetTransform(transform);
        target.Clear(WHITE);
        D2D1_POINT_2F pt = new D2D1_POINT_2F(-glyphX, -glyphY);
        ID2D1Brush brush = target.CreateSolidColorBrush(BLACK);
        if (!lcd) {
            target.SetTextAntialiasMode(2);
        }
        target.DrawGlyphRun(pt, this.run, brush, 0);
        int hr = target.EndDraw();
        brush.Release();
        if (hr != 0) {
            bitmap.Release();
            cachedBitmap = null;
            target.Release();
            cachedTarget = null;
            if (PrismFontFactory.debugFonts) {
                System.err.println("Rendering failed=" + hr);
            }
            this.rect.bottom = 0;
            this.rect.right = 0;
            this.rect.top = 0;
            this.rect.left = 0;
            return null;
        }
        byte[] result = null;
        IWICBitmapLock lock = bitmap.Lock(0, 0, w, h, 1);
        if (lock != null) {
            byte[] buffer = lock.GetDataPointer();
            if (buffer != null) {
                int stride = lock.GetStride();
                int i = 0;
                int j = 0;
                int one = -1;
                if (lcd) {
                    result = new byte[w * h * 3];
                    for (int y = 0; y < h; ++y) {
                        int row = j;
                        for (int x = 0; x < w; ++x) {
                            result[i++] = (byte)(one - buffer[row++]);
                            result[i++] = (byte)(one - buffer[row++]);
                            result[i++] = (byte)(one - buffer[row++]);
                            ++row;
                        }
                        j += stride;
                    }
                } else {
                    result = new byte[w * h];
                    for (int y = 0; y < h; ++y) {
                        int row = j;
                        for (int x = 0; x < w; ++x) {
                            result[i++] = (byte)(one - buffer[row]);
                            row += 4;
                        }
                        j += stride;
                    }
                }
            }
            lock.Release();
        }
        if (!cache) {
            bitmap.Release();
            target.Release();
        }
        return result;
    }

    IDWriteGlyphRunAnalysis createAnalysis(float x, float y) {
        if (this.run.fontFace == 0L) {
            return null;
        }
        IDWriteFactory factory = DWFactory.getDWriteFactory();
        int renderingMode = DWFontStrike.SUBPIXEL_Y ? 5 : 4;
        int measuringMode = 0;
        DWRITE_MATRIX matrix = this.strike.matrix;
        float dpi = 1.0f;
        return factory.CreateGlyphRunAnalysis(this.run, dpi, matrix, renderingMode, measuringMode, x, y);
    }

    IWICBitmap getCachedBitmap() {
        if (cachedBitmap == null) {
            cachedBitmap = this.createBitmap(256, 256);
        }
        return cachedBitmap;
    }

    ID2D1RenderTarget getCachedRenderingTarget() {
        if (cachedTarget == null) {
            cachedTarget = this.createRenderingTarget(this.getCachedBitmap());
        }
        return cachedTarget;
    }

    IWICBitmap createBitmap(int width, int height) {
        IWICImagingFactory factory = DWFactory.getWICFactory();
        return factory.CreateBitmap(width, height, 8, 1);
    }

    ID2D1RenderTarget createRenderingTarget(IWICBitmap bitmap) {
        D2D1_RENDER_TARGET_PROPERTIES prop = new D2D1_RENDER_TARGET_PROPERTIES();
        prop.type = 0;
        prop.pixelFormat.format = 0;
        prop.pixelFormat.alphaMode = 0;
        prop.dpiX = 0.0f;
        prop.dpiY = 0.0f;
        prop.usage = 0;
        prop.minLevel = 0;
        ID2D1Factory factory = DWFactory.getD2DFactory();
        return factory.CreateWicBitmapRenderTarget(bitmap, prop);
    }

    @Override
    public int getGlyphCode() {
        return this.run.glyphIndices & 0xFFFF;
    }

    @Override
    public RectBounds getBBox() {
        return this.strike.getBBox(this.run.glyphIndices & 0xFFFF);
    }

    @Override
    public float getAdvance() {
        this.checkMetrics();
        if (this.metrics == null) {
            return 0.0f;
        }
        float upem = this.strike.getUpem();
        return (float)this.metrics.advanceWidth * this.strike.getSize() / upem;
    }

    @Override
    public Shape getShape() {
        return this.strike.createGlyphOutline(this.run.glyphIndices & 0xFFFF);
    }

    @Override
    public byte[] getPixelData() {
        return this.getPixelData(0);
    }

    @Override
    public byte[] getPixelData(int subPixel) {
        byte[] data = this.pixelData[subPixel];
        if (data == null) {
            float x = 0.0f;
            float y = 0.0f;
            int index = subPixel;
            if (index >= 6) {
                index -= 6;
                y = 0.66f;
            } else if (index >= 3) {
                index -= 3;
                y = 0.33f;
            }
            if (index == 1) {
                x = 0.33f;
            }
            if (index == 2) {
                x = 0.66f;
            }
            data = this.isLCDGlyph() ? this.getLCDMask(x, y) : this.getD2DMask(x, y, false);
            this.pixelData[subPixel] = data;
            this.rects[subPixel] = this.rect;
        } else {
            this.rect = this.rects[subPixel];
        }
        return data;
    }

    @Override
    public float getPixelXAdvance() {
        this.checkMetrics();
        return this.pixelXAdvance;
    }

    @Override
    public float getPixelYAdvance() {
        this.checkMetrics();
        return this.pixelYAdvance;
    }

    @Override
    public int getWidth() {
        this.checkBounds();
        return (this.rect.right - this.rect.left) * (this.isLCDGlyph() ? 3 : 1);
    }

    @Override
    public int getHeight() {
        this.checkBounds();
        return this.rect.bottom - this.rect.top;
    }

    @Override
    public int getOriginX() {
        this.checkBounds();
        return this.rect.left;
    }

    @Override
    public int getOriginY() {
        this.checkBounds();
        return this.rect.top;
    }

    @Override
    public boolean isLCDGlyph() {
        return this.strike.getAAMode() == 1;
    }

    static {
        BLACK = new D2D1_COLOR_F(0.0f, 0.0f, 0.0f, 1.0f);
        WHITE = new D2D1_COLOR_F(1.0f, 1.0f, 1.0f, 1.0f);
        D2D2_MATRIX_IDENTITY = new D2D1_MATRIX_3X2_F(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }
}

