/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.layout.region;

import com.sun.javafx.css.ParsedValueImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.StyleConverter;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.scene.shape.StrokeType;
import javafx.scene.text.Font;

public class BorderStyleConverter
extends StyleConverter<ParsedValue[], BorderStrokeStyle> {
    public static final ParsedValueImpl<ParsedValue[], Number[]> NONE = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> HIDDEN = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> DOTTED = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> DASHED = new ParsedValueImpl(null, null);
    public static final ParsedValueImpl<ParsedValue[], Number[]> SOLID = new ParsedValueImpl(null, null);
    private static final BorderStyleConverter BORDER_STYLE_CONVERTER = new BorderStyleConverter();

    public static BorderStyleConverter getInstance() {
        return BORDER_STYLE_CONVERTER;
    }

    private BorderStyleConverter() {
    }

    @Override
    public BorderStrokeStyle convert(ParsedValue<ParsedValue[], BorderStrokeStyle> value, Font font) {
        double miter_limit;
        List<Double> dashes;
        boolean onlyNamed;
        ParsedValue[] values = value.getValue();
        ParsedValue v = values[0];
        boolean bl = onlyNamed = values[1] == null && values[2] == null && values[3] == null && values[4] == null && values[5] == null;
        if (NONE == v) {
            return BorderStrokeStyle.NONE;
        }
        if (DOTTED == v && onlyNamed) {
            return BorderStrokeStyle.DOTTED;
        }
        if (DASHED == v && onlyNamed) {
            return BorderStrokeStyle.DASHED;
        }
        if (SOLID == v && onlyNamed) {
            return BorderStrokeStyle.SOLID;
        }
        ParsedValue[] dash_vals = (ParsedValue[])values[0].getValue();
        if (dash_vals == null) {
            dashes = DOTTED == v ? BorderStrokeStyle.DOTTED.getDashArray() : (DASHED == v ? BorderStrokeStyle.DASHED.getDashArray() : (SOLID == v ? BorderStrokeStyle.SOLID.getDashArray() : Collections.emptyList()));
        } else {
            dashes = new ArrayList<Double>(dash_vals.length);
            for (int dash = 0; dash < dash_vals.length; ++dash) {
                Size size = (Size)dash_vals[dash].convert(font);
                dashes.add(size.pixels(font));
            }
        }
        double dash_phase = values[1] != null ? (Double)values[1].convert(font) : 0.0;
        StrokeType stroke_type = values[2] != null ? (StrokeType)((Object)values[2].convert(font)) : StrokeType.INSIDE;
        StrokeLineJoin line_join = values[3] != null ? (StrokeLineJoin)((Object)values[3].convert(font)) : StrokeLineJoin.MITER;
        double d = miter_limit = values[4] != null ? (Double)values[4].convert(font) : 10.0;
        StrokeLineCap line_cap = values[5] != null ? (StrokeLineCap)((Object)values[5].convert(font)) : (DOTTED == v ? StrokeLineCap.ROUND : StrokeLineCap.BUTT);
        BorderStrokeStyle borderStyle = new BorderStrokeStyle(stroke_type, line_join, line_cap, miter_limit, dash_phase, dashes);
        if (BorderStrokeStyle.SOLID.equals(borderStyle)) {
            return BorderStrokeStyle.SOLID;
        }
        return borderStyle;
    }

    public String toString() {
        return "BorderStyleConverter";
    }
}

