/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.stage;

import com.sun.javafx.stage.FocusUngrabEvent;
import com.sun.javafx.stage.WindowHelper;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKStageListener;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class WindowPeerListener
implements TKStageListener {
    private final Window window;

    public WindowPeerListener(Window window) {
        this.window = window;
    }

    @Override
    public void changedLocation(float x, float y) {
        WindowHelper.notifyLocationChanged(this.window, x, y);
    }

    @Override
    public void changedSize(float width, float height) {
        WindowHelper.notifySizeChanged(this.window, width, height);
    }

    @Override
    public void changedScale(float xScale, float yScale) {
        WindowHelper.notifyScaleChanged(this.window, xScale, yScale);
    }

    @Override
    public void changedFocused(boolean focused, FocusCause cause) {
        WindowHelper.setFocused(this.window, focused);
    }

    @Override
    public void changedIconified(boolean iconified) {
    }

    @Override
    public void changedMaximized(boolean maximized) {
    }

    @Override
    public void changedResizable(boolean resizable) {
    }

    @Override
    public void changedFullscreen(boolean fs) {
    }

    @Override
    public void changedAlwaysOnTop(boolean aot) {
    }

    @Override
    public void changedScreen(Object from, Object to) {
        WindowHelper.getWindowAccessor().notifyScreenChanged(this.window, from, to);
    }

    @Override
    public void closing() {
        Event.fireEvent((EventTarget)this.window, (Event)new WindowEvent(this.window, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @Override
    public void closed() {
        if (this.window.isShowing()) {
            this.window.hide();
        }
    }

    @Override
    public void focusUngrab() {
        Event.fireEvent((EventTarget)this.window, (Event)new FocusUngrabEvent());
    }
}

