/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.text;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.Metrics;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.Translate2D;
import com.sun.javafx.scene.text.GlyphList;
import com.sun.javafx.scene.text.TextLayout;
import com.sun.javafx.scene.text.TextSpan;
import com.sun.javafx.text.CharArrayIterator;
import com.sun.javafx.text.GlyphLayout;
import com.sun.javafx.text.LayoutCache;
import com.sun.javafx.text.TextLine;
import com.sun.javafx.text.TextRun;
import java.text.Bidi;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.PathElement;

public class PrismTextLayout
implements TextLayout {
    private static final BaseTransform IDENTITY = BaseTransform.IDENTITY_TRANSFORM;
    private static final int X_MIN_INDEX = 0;
    private static final int Y_MIN_INDEX = 1;
    private static final int X_MAX_INDEX = 2;
    private static final int Y_MAX_INDEX = 3;
    private static final Hashtable<Integer, LayoutCache> stringCache = new Hashtable();
    private static final Object CACHE_SIZE_LOCK = new Object();
    private static int cacheSize = 0;
    private static final int MAX_STRING_SIZE = 256;
    private static final int MAX_CACHE_SIZE = PrismFontFactory.cacheLayoutSize;
    private char[] text;
    private TextSpan[] spans;
    private PGFont font;
    private FontStrike strike;
    private Integer cacheKey;
    private TextLine[] lines;
    private TextRun[] runs;
    private int runCount;
    private BaseBounds logicalBounds = new RectBounds();
    private RectBounds visualBounds;
    private float layoutWidth;
    private float layoutHeight;
    private float wrapWidth;
    private float spacing;
    private LayoutCache layoutCache;
    private Shape shape;
    private int flags = 262144;
    private int tabSize = 8;

    private void reset() {
        this.layoutCache = null;
        this.runs = null;
        this.flags &= 0xFFFFF800;
        this.relayout();
    }

    private void relayout() {
        this.logicalBounds.makeEmpty();
        this.visualBounds = null;
        this.layoutHeight = 0.0f;
        this.layoutWidth = 0.0f;
        this.flags &= 0xFFFFF97F;
        this.lines = null;
        this.shape = null;
    }

    @Override
    public boolean setContent(TextSpan[] spans) {
        if (spans == null && this.spans == null) {
            return false;
        }
        if (spans != null && this.spans != null && spans.length == this.spans.length) {
            int i;
            for (i = 0; i < spans.length && spans[i] == this.spans[i]; ++i) {
            }
            if (i == spans.length) {
                return false;
            }
        }
        this.reset();
        this.spans = spans;
        this.font = null;
        this.strike = null;
        this.text = null;
        this.cacheKey = null;
        return true;
    }

    @Override
    public boolean setContent(String text, Object font) {
        int length;
        this.reset();
        this.spans = null;
        this.font = (PGFont)font;
        this.strike = ((PGFont)font).getStrike(IDENTITY);
        this.text = text.toCharArray();
        if (MAX_CACHE_SIZE > 0 && 0 < (length = text.length()) && length <= 256) {
            this.cacheKey = text.hashCode() * this.strike.hashCode();
        }
        return true;
    }

    @Override
    public boolean setDirection(int direction) {
        if ((this.flags & 0x3C00) == direction) {
            return false;
        }
        this.flags &= 0xFFFFC3FF;
        this.flags |= direction & 0x3C00;
        this.reset();
        return true;
    }

    @Override
    public boolean setBoundsType(int type) {
        if ((this.flags & 0x4000) == type) {
            return false;
        }
        this.flags &= 0xFFFFBFFF;
        this.flags |= type & 0x4000;
        this.reset();
        return true;
    }

    @Override
    public boolean setAlignment(int alignment) {
        int align = 262144;
        switch (alignment) {
            case 0: {
                align = 262144;
                break;
            }
            case 1: {
                align = 524288;
                break;
            }
            case 2: {
                align = 0x100000;
                break;
            }
            case 3: {
                align = 0x200000;
            }
        }
        if ((this.flags & 0x3C0000) == align) {
            return false;
        }
        if (align == 0x200000 || (this.flags & 0x200000) != 0) {
            this.reset();
        }
        this.flags &= 0xFFC3FFFF;
        this.flags |= align;
        this.relayout();
        return true;
    }

    @Override
    public boolean setWrapWidth(float newWidth) {
        if (Float.isInfinite(newWidth)) {
            newWidth = 0.0f;
        }
        if (Float.isNaN(newWidth)) {
            newWidth = 0.0f;
        }
        float oldWidth = this.wrapWidth;
        this.wrapWidth = Math.max(0.0f, newWidth);
        boolean needsLayout = true;
        if (this.lines != null && oldWidth != 0.0f && newWidth != 0.0f && (this.flags & 0x40000) != 0) {
            if (newWidth > oldWidth) {
                if ((this.flags & 0x80) == 0) {
                    needsLayout = false;
                }
            } else if (newWidth >= this.layoutWidth) {
                needsLayout = false;
            }
        }
        if (needsLayout) {
            this.relayout();
        }
        return needsLayout;
    }

    @Override
    public boolean setLineSpacing(float spacing) {
        if (this.spacing == spacing) {
            return false;
        }
        this.spacing = spacing;
        this.relayout();
        return true;
    }

    private void ensureLayout() {
        if (this.lines == null) {
            this.layout();
        }
    }

    @Override
    public com.sun.javafx.scene.text.TextLine[] getLines() {
        this.ensureLayout();
        return this.lines;
    }

    @Override
    public GlyphList[] getRuns() {
        this.ensureLayout();
        GlyphList[] result = new GlyphList[this.runCount];
        int count = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            TextRun[] lineRuns = this.lines[i].getRuns();
            int length = lineRuns.length;
            System.arraycopy(lineRuns, 0, result, count, length);
            count += length;
        }
        return result;
    }

    @Override
    public BaseBounds getBounds() {
        this.ensureLayout();
        return this.logicalBounds;
    }

    @Override
    public BaseBounds getBounds(TextSpan filter, BaseBounds bounds) {
        this.ensureLayout();
        float left = Float.POSITIVE_INFINITY;
        float top = Float.POSITIVE_INFINITY;
        float right = Float.NEGATIVE_INFINITY;
        float bottom = Float.NEGATIVE_INFINITY;
        if (filter != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                TextLine line = this.lines[i];
                TextRun[] lineRuns = line.getRuns();
                for (int j = 0; j < lineRuns.length; ++j) {
                    TextRun run = lineRuns[j];
                    TextSpan span = run.getTextSpan();
                    if (span != filter) continue;
                    Point2D location = run.getLocation();
                    float runLeft = location.x;
                    if (run.isLeftBearing()) {
                        runLeft += line.getLeftSideBearing();
                    }
                    float runRight = location.x + run.getWidth();
                    if (run.isRightBearing()) {
                        runRight += line.getRightSideBearing();
                    }
                    float runTop = location.y;
                    float runBottom = location.y + line.getBounds().getHeight() + this.spacing;
                    if (runLeft < left) {
                        left = runLeft;
                    }
                    if (runTop < top) {
                        top = runTop;
                    }
                    if (runRight > right) {
                        right = runRight;
                    }
                    if (!(runBottom > bottom)) continue;
                    bottom = runBottom;
                }
            }
        } else {
            bottom = 0.0f;
            top = 0.0f;
            for (int i = 0; i < this.lines.length; ++i) {
                float lineRight;
                TextLine line = this.lines[i];
                RectBounds lineBounds = line.getBounds();
                float lineLeft = lineBounds.getMinX() + line.getLeftSideBearing();
                if (lineLeft < left) {
                    left = lineLeft;
                }
                if ((lineRight = lineBounds.getMaxX() + line.getRightSideBearing()) > right) {
                    right = lineRight;
                }
                bottom += lineBounds.getHeight();
            }
            if (this.isMirrored()) {
                float width = this.getMirroringWidth();
                float bearing = left;
                left = width - right;
                right = width - bearing;
            }
        }
        return bounds.deriveWithNewBounds(left, top, 0.0f, right, bottom, 0.0f);
    }

    @Override
    public PathElement[] getCaretShape(int offset, boolean isLeading, float x, float y) {
        Point2D location;
        int runEnd;
        TextLine line;
        int lineEnd;
        int lineIndex;
        this.ensureLayout();
        int lineCount = this.getLineCount();
        for (lineIndex = 0; lineIndex < lineCount - 1 && (lineEnd = (line = this.lines[lineIndex]).getStart() + line.getLength()) <= offset; ++lineIndex) {
        }
        int sliptCaretOffset = -1;
        byte level = 0;
        float lineX = 0.0f;
        float lineY = 0.0f;
        float lineHeight = 0.0f;
        TextLine line2 = this.lines[lineIndex];
        TextRun[] runs = line2.getRuns();
        int runCount = runs.length;
        int runIndex = -1;
        for (int i = 0; i < runCount; ++i) {
            TextRun run = runs[i];
            int runStart = run.getStart();
            runEnd = run.getEnd();
            if (runStart > offset || offset >= runEnd) continue;
            if (run.isLinebreak()) break;
            runIndex = i;
            break;
        }
        if (runIndex != -1) {
            TextRun run = runs[runIndex];
            int runStart = run.getStart();
            location = run.getLocation();
            lineX = location.x + run.getXAtOffset(offset - runStart, isLeading);
            lineY = location.y;
            lineHeight = line2.getBounds().getHeight();
            if (isLeading) {
                if (runIndex > 0 && offset == runStart) {
                    level = run.getLevel();
                    sliptCaretOffset = offset - 1;
                }
            } else {
                runEnd = run.getEnd();
                if (runIndex + 1 < runs.length && offset + 1 == runEnd) {
                    level = run.getLevel();
                    sliptCaretOffset = offset + 1;
                }
            }
        } else {
            int maxOffset = 0;
            runIndex = 0;
            for (int i = 0; i < runCount; ++i) {
                TextRun run = runs[i];
                if (run.getStart() < maxOffset || run.isLinebreak()) continue;
                maxOffset = run.getStart();
                runIndex = i;
            }
            TextRun run = runs[runIndex];
            location = run.getLocation();
            lineX = location.x + (run.isLeftToRight() ? run.getWidth() : 0.0f);
            lineY = location.y;
            lineHeight = line2.getBounds().getHeight();
        }
        if (this.isMirrored()) {
            lineX = this.getMirroringWidth() - lineX;
        }
        lineX += x;
        lineY += y;
        if (sliptCaretOffset != -1) {
            for (int i = 0; i < runs.length; ++i) {
                TextRun run = runs[i];
                int runStart = run.getStart();
                runEnd = run.getEnd();
                if (runStart > sliptCaretOffset || sliptCaretOffset >= runEnd || (run.getLevel() & 1) == (level & 1)) continue;
                Point2D location2 = run.getLocation();
                float lineX2 = location2.x;
                if (isLeading) {
                    if ((level & 1) != 0) {
                        lineX2 += run.getWidth();
                    }
                } else if ((level & 1) == 0) {
                    lineX2 += run.getWidth();
                }
                if (this.isMirrored()) {
                    lineX2 = this.getMirroringWidth() - lineX2;
                }
                PathElement[] result = new PathElement[]{new MoveTo(lineX, lineY), new LineTo(lineX, lineY + lineHeight / 2.0f), new MoveTo(lineX2 += x, lineY + lineHeight / 2.0f), new LineTo(lineX2, lineY + lineHeight)};
                return result;
            }
        }
        PathElement[] result = new PathElement[]{new MoveTo(lineX, lineY), new LineTo(lineX, lineY + lineHeight)};
        return result;
    }

    @Override
    public TextLayout.Hit getHitInfo(float x, float y) {
        int charIndex = -1;
        boolean leading = false;
        this.ensureLayout();
        int lineIndex = this.getLineIndex(y);
        if (lineIndex >= this.getLineCount()) {
            charIndex = this.getCharCount();
        } else {
            if (this.isMirrored()) {
                x = this.getMirroringWidth() - x;
            }
            TextLine line = this.lines[lineIndex];
            TextRun[] runs = line.getRuns();
            RectBounds bounds = line.getBounds();
            TextRun run = null;
            x -= bounds.getMinX();
            for (int i = 0; i < runs.length && !(x < (run = runs[i]).getWidth()); ++i) {
                if (i + 1 >= runs.length) continue;
                if (runs[i + 1].isLinebreak()) break;
                x -= run.getWidth();
            }
            if (run != null) {
                int[] trailing = new int[1];
                charIndex = run.getStart() + run.getOffsetAtX(x, trailing);
                leading = trailing[0] == 0;
            } else {
                charIndex = line.getStart();
                leading = true;
            }
        }
        return new TextLayout.Hit(charIndex, -1, leading);
    }

    @Override
    public PathElement[] getRange(int start, int end, int type, float x, float y) {
        this.ensureLayout();
        int lineCount = this.getLineCount();
        ArrayList<PathElement> result = new ArrayList<PathElement>();
        float lineY = 0.0f;
        for (int lineIndex = 0; lineIndex < lineCount; ++lineIndex) {
            TextLine line = this.lines[lineIndex];
            RectBounds lineBounds = line.getBounds();
            int lineStart = line.getStart();
            if (lineStart >= end) break;
            int lineEnd = lineStart + line.getLength();
            if (start > lineEnd) {
                lineY += lineBounds.getHeight() + this.spacing;
                continue;
            }
            TextRun[] runs = line.getRuns();
            int count = Math.min(lineEnd, end) - Math.max(lineStart, start);
            float left = -1.0f;
            float right = -1.0f;
            float lineX = lineBounds.getMinX();
            for (int runIndex = 0; count > 0 && runIndex < runs.length; ++runIndex) {
                TextRun run = runs[runIndex];
                int runStart = run.getStart();
                int runEnd = run.getEnd();
                float runWidth = run.getWidth();
                int clmapStart = Math.max(runStart, Math.min(start, runEnd));
                int clampEnd = Math.max(runStart, Math.min(end, runEnd));
                int runCount = clampEnd - clmapStart;
                if (runCount != 0) {
                    float runRight;
                    boolean ltr = run.isLeftToRight();
                    float runLeft = runStart > start ? (ltr ? lineX : lineX + runWidth) : lineX + run.getXAtOffset(start - runStart, true);
                    if (runLeft > (runRight = runEnd < end ? (ltr ? lineX + runWidth : lineX) : lineX + run.getXAtOffset(end - runStart, true))) {
                        float tmp = runLeft;
                        runLeft = runRight;
                        runRight = tmp;
                    }
                    count -= runCount;
                    float top = 0.0f;
                    float bottom = 0.0f;
                    switch (type) {
                        case 1: {
                            top = lineY;
                            bottom = lineY + lineBounds.getHeight();
                            break;
                        }
                        case 2: 
                        case 4: {
                            FontStrike fontStrike = null;
                            if (this.spans != null) {
                                TextSpan span = run.getTextSpan();
                                PGFont font = (PGFont)span.getFont();
                                if (font == null) break;
                                fontStrike = font.getStrike(IDENTITY);
                            } else {
                                fontStrike = this.strike;
                            }
                            top = lineY - run.getAscent();
                            Metrics metrics = fontStrike.getMetrics();
                            bottom = type == 2 ? (top += metrics.getUnderLineOffset()) + metrics.getUnderLineThickness() : (top += metrics.getStrikethroughOffset()) + metrics.getStrikethroughThickness();
                        }
                    }
                    if (runLeft != right) {
                        if (left != -1.0f && right != -1.0f) {
                            float l = left;
                            float r = right;
                            if (this.isMirrored()) {
                                float width = this.getMirroringWidth();
                                l = width - l;
                                r = width - r;
                            }
                            result.add(new MoveTo(x + l, y + top));
                            result.add(new LineTo(x + r, y + top));
                            result.add(new LineTo(x + r, y + bottom));
                            result.add(new LineTo(x + l, y + bottom));
                            result.add(new LineTo(x + l, y + top));
                        }
                        left = runLeft;
                        right = runRight;
                    }
                    right = runRight;
                    if (count == 0) {
                        float l = left;
                        float r = right;
                        if (this.isMirrored()) {
                            float width = this.getMirroringWidth();
                            l = width - l;
                            r = width - r;
                        }
                        result.add(new MoveTo(x + l, y + top));
                        result.add(new LineTo(x + r, y + top));
                        result.add(new LineTo(x + r, y + bottom));
                        result.add(new LineTo(x + l, y + bottom));
                        result.add(new LineTo(x + l, y + top));
                    }
                }
                lineX += runWidth;
            }
            lineY += lineBounds.getHeight() + this.spacing;
        }
        return result.toArray(new PathElement[result.size()]);
    }

    @Override
    public Shape getShape(int type, TextSpan filter) {
        boolean baselineType;
        this.ensureLayout();
        boolean text = (type & 1) != 0;
        boolean underline = (type & 2) != 0;
        boolean strikethrough = (type & 4) != 0;
        boolean bl = baselineType = (type & 8) != 0;
        if (this.shape != null && text && !underline && !strikethrough && baselineType) {
            return this.shape;
        }
        Path2D outline = new Path2D();
        Translate2D tx = new Translate2D(0.0, 0.0);
        float firstBaseline = 0.0f;
        if (baselineType) {
            firstBaseline = -this.lines[0].getBounds().getMinY();
        }
        for (int i = 0; i < this.lines.length; ++i) {
            TextLine line = this.lines[i];
            TextRun[] runs = line.getRuns();
            RectBounds bounds = line.getBounds();
            float baseline = -bounds.getMinY();
            for (int j = 0; j < runs.length; ++j) {
                RoundRectangle2D rect;
                TextRun run = runs[j];
                FontStrike fontStrike = null;
                if (this.spans != null) {
                    PGFont font;
                    TextSpan span = run.getTextSpan();
                    if (filter != null && span != filter || (font = (PGFont)span.getFont()) == null) continue;
                    fontStrike = font.getStrike(IDENTITY);
                } else {
                    fontStrike = this.strike;
                }
                Point2D location = run.getLocation();
                float runX = location.x;
                float runY = location.y + baseline - firstBaseline;
                Metrics metrics = null;
                if (underline || strikethrough) {
                    metrics = fontStrike.getMetrics();
                }
                if (underline) {
                    rect = new RoundRectangle2D();
                    rect.x = runX;
                    rect.y = runY + metrics.getUnderLineOffset();
                    rect.width = run.getWidth();
                    rect.height = metrics.getUnderLineThickness();
                    outline.append(rect, false);
                }
                if (strikethrough) {
                    rect = new RoundRectangle2D();
                    rect.x = runX;
                    rect.y = runY + metrics.getStrikethroughOffset();
                    rect.width = run.getWidth();
                    rect.height = metrics.getStrikethroughThickness();
                    outline.append(rect, false);
                }
                if (!text || run.getGlyphCount() <= 0) continue;
                ((BaseTransform)tx).restoreTransform(1.0, 0.0, 0.0, 1.0, runX, runY);
                Path2D path = (Path2D)fontStrike.getOutline(run, tx);
                outline.append(path, false);
            }
        }
        if (text && !underline && !strikethrough) {
            this.shape = outline;
        }
        return outline;
    }

    @Override
    public boolean setTabSize(int spaces) {
        if (spaces < 1) {
            spaces = 1;
        }
        if (this.tabSize != spaces) {
            this.tabSize = spaces;
            this.relayout();
            return true;
        }
        return false;
    }

    private int getLineIndex(float y) {
        int index;
        float bottom = 0.0f;
        int lineCount = this.getLineCount();
        for (index = 0; index < lineCount; ++index) {
            bottom += this.lines[index].getBounds().getHeight() + this.spacing;
            if (index + 1 == lineCount) {
                bottom -= this.lines[index].getLeading();
            }
            if (bottom > y) break;
        }
        return index;
    }

    private boolean copyCache() {
        int align = this.flags & 0x3C0000;
        int boundsType = this.flags & 0x4000;
        return this.wrapWidth != 0.0f || align != 262144 || boundsType == 0 || this.isMirrored();
    }

    private void initCache() {
        if (this.cacheKey != null) {
            LayoutCache cache;
            if (this.layoutCache == null && (cache = stringCache.get(this.cacheKey)) != null && cache.font.equals(this.font) && Arrays.equals(cache.text, this.text)) {
                this.layoutCache = cache;
                this.runs = cache.runs;
                this.runCount = cache.runCount;
                this.flags |= cache.analysis;
            }
            if (this.layoutCache != null) {
                if (this.copyCache()) {
                    if (this.layoutCache.runs == this.runs) {
                        this.runs = new TextRun[this.runCount];
                        System.arraycopy(this.layoutCache.runs, 0, this.runs, 0, this.runCount);
                    }
                } else if (this.layoutCache.lines != null) {
                    this.runs = this.layoutCache.runs;
                    this.runCount = this.layoutCache.runCount;
                    this.flags |= this.layoutCache.analysis;
                    this.lines = this.layoutCache.lines;
                    this.layoutWidth = this.layoutCache.layoutWidth;
                    this.layoutHeight = this.layoutCache.layoutHeight;
                    float ascent = this.lines[0].getBounds().getMinY();
                    this.logicalBounds = this.logicalBounds.deriveWithNewBounds(0.0f, ascent, 0.0f, this.layoutWidth, this.layoutHeight + ascent, 0.0f);
                }
            }
        }
    }

    private int getLineCount() {
        return this.lines.length;
    }

    private int getCharCount() {
        if (this.text != null) {
            return this.text.length;
        }
        int count = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            count += this.lines[i].getLength();
        }
        return count;
    }

    public TextSpan[] getTextSpans() {
        return this.spans;
    }

    public PGFont getFont() {
        return this.font;
    }

    public int getDirection() {
        if ((this.flags & 0x400) != 0) {
            return 0;
        }
        if ((this.flags & 0x800) != 0) {
            return 1;
        }
        if ((this.flags & 0x1000) != 0) {
            return -2;
        }
        if ((this.flags & 0x2000) != 0) {
            return -1;
        }
        return -2;
    }

    public void addTextRun(TextRun run) {
        if (this.runCount + 1 > this.runs.length) {
            TextRun[] newRuns = new TextRun[this.runs.length + 64];
            System.arraycopy(this.runs, 0, newRuns, 0, this.runs.length);
            this.runs = newRuns;
        }
        this.runs[this.runCount++] = run;
    }

    private void buildRuns(char[] chars) {
        this.runCount = 0;
        if (this.runs == null) {
            int count = Math.max(4, Math.min(chars.length / 16, 16));
            this.runs = new TextRun[count];
        }
        GlyphLayout layout = GlyphLayout.getInstance();
        this.flags = layout.breakRuns(this, chars, this.flags);
        layout.dispose();
        for (int j = this.runCount; j < this.runs.length; ++j) {
            this.runs[j] = null;
        }
    }

    private void shape(TextRun run, char[] chars, GlyphLayout layout) {
        FontStrike strike;
        PGFont font;
        if (this.spans != null) {
            if (this.spans.length == 0) {
                return;
            }
            TextSpan span = run.getTextSpan();
            font = (PGFont)span.getFont();
            if (font == null) {
                RectBounds bounds = span.getBounds();
                run.setEmbedded(bounds, span.getText().length());
                return;
            }
            strike = font.getStrike(IDENTITY);
        } else {
            font = this.font;
            strike = this.strike;
        }
        if (run.getAscent() == 0.0f) {
            Metrics m = strike.getMetrics();
            if ((this.flags & 0x4000) == 16384) {
                float ascent = m.getAscent();
                if (font.getFamilyName().equals("Segoe UI")) {
                    ascent = (float)((double)ascent * 0.8);
                }
                ascent = (int)((double)ascent - 0.75);
                float descent = (int)((double)m.getDescent() + 0.75);
                float leading = (int)((double)m.getLineGap() + 0.75);
                float capHeight = (int)((double)m.getCapHeight() + 0.75);
                float topPadding = -ascent - capHeight;
                if (topPadding > descent) {
                    descent = topPadding;
                } else {
                    ascent += topPadding - descent;
                }
                run.setMetrics(ascent, descent, leading);
            } else {
                run.setMetrics(m.getAscent(), m.getDescent(), m.getLineGap());
            }
        }
        if (run.isTab()) {
            return;
        }
        if (run.isLinebreak()) {
            return;
        }
        if (run.getGlyphCount() > 0) {
            return;
        }
        if (run.isComplex()) {
            layout.layout(run, font, strike, chars);
        } else {
            float fontSize;
            FontResource fr = strike.getFontResource();
            int start = run.getStart();
            int length = run.getLength();
            if (this.layoutCache == null) {
                fontSize = strike.getSize();
                CharToGlyphMapper mapper = fr.getGlyphMapper();
                int[] glyphs = new int[length];
                mapper.charsToGlyphs(start, length, chars, glyphs);
                float[] positions = new float[length + 1 << 1];
                float xadvance = 0.0f;
                for (int i = 0; i < length; ++i) {
                    float width = fr.getAdvance(glyphs[i], fontSize);
                    positions[i << 1] = xadvance;
                    xadvance += width;
                }
                positions[length << 1] = xadvance;
                run.shape(length, glyphs, positions, null);
            } else {
                if (!this.layoutCache.valid) {
                    fontSize = strike.getSize();
                    CharToGlyphMapper mapper = fr.getGlyphMapper();
                    mapper.charsToGlyphs(start, length, chars, this.layoutCache.glyphs, start);
                    int end = start + length;
                    float width = 0.0f;
                    for (int i = start; i < end; ++i) {
                        float adv;
                        this.layoutCache.advances[i] = adv = fr.getAdvance(this.layoutCache.glyphs[i], fontSize);
                        width += adv;
                    }
                    run.setWidth(width);
                }
                run.shape(length, this.layoutCache.glyphs, this.layoutCache.advances);
            }
        }
    }

    private TextLine createLine(int start, int end, int startOffset) {
        int count = end - start + 1;
        TextRun[] lineRuns = new TextRun[count];
        if (start < this.runCount) {
            System.arraycopy(this.runs, start, lineRuns, 0, count);
        }
        float width = 0.0f;
        float ascent = 0.0f;
        float descent = 0.0f;
        float leading = 0.0f;
        int length = 0;
        for (int i = 0; i < lineRuns.length; ++i) {
            TextRun run = lineRuns[i];
            width += run.getWidth();
            ascent = Math.min(ascent, run.getAscent());
            descent = Math.max(descent, run.getDescent());
            leading = Math.max(leading, run.getLeading());
            length += run.getLength();
        }
        if (width > this.layoutWidth) {
            this.layoutWidth = width;
        }
        return new TextLine(startOffset, length, lineRuns, width, ascent, descent, leading);
    }

    private void reorderLine(TextLine line) {
        Object[] runs = line.getRuns();
        int length = runs.length;
        if (length > 0 && runs[length - 1].isLinebreak()) {
            --length;
        }
        if (length < 2) {
            return;
        }
        byte[] levels = new byte[length];
        for (int i = 0; i < length; ++i) {
            levels[i] = runs[i].getLevel();
        }
        Bidi.reorderVisually(levels, 0, runs, 0, length);
    }

    private char[] getText() {
        if (this.text == null) {
            int count = 0;
            for (int i = 0; i < this.spans.length; ++i) {
                count += this.spans[i].getText().length();
            }
            this.text = new char[count];
            int offset = 0;
            for (int i = 0; i < this.spans.length; ++i) {
                String string = this.spans[i].getText();
                int length = string.length();
                string.getChars(0, length, this.text, offset);
                offset += length;
            }
        }
        return this.text;
    }

    private boolean isSimpleLayout() {
        int textAlignment = this.flags & 0x3C0000;
        boolean justify = this.wrapWidth > 0.0f && textAlignment == 0x200000;
        int mask = 24;
        return (this.flags & mask) == 0 && !justify;
    }

    private boolean isMirrored() {
        boolean mirrored = false;
        switch (this.flags & 0x3C00) {
            case 2048: {
                mirrored = true;
                break;
            }
            case 1024: {
                mirrored = false;
                break;
            }
            case 4096: 
            case 8192: {
                mirrored = (this.flags & 0x100) != 0;
            }
        }
        return mirrored;
    }

    private float getMirroringWidth() {
        return this.wrapWidth != 0.0f ? this.wrapWidth : this.layoutWidth;
    }

    private void reuseRuns() {
        TextRun run;
        this.runCount = 0;
        int index = 0;
        block0: while (index < this.runs.length && (run = this.runs[index]) != null) {
            TextRun nextRun;
            this.runs[index] = null;
            ++index;
            this.runs[this.runCount++] = run = run.unwrap();
            if (!run.isSplit()) continue;
            run.merge(null);
            while (index < this.runs.length && (nextRun = this.runs[index]) != null) {
                run.merge(nextRun);
                this.runs[index] = null;
                ++index;
                if (!nextRun.isSplitLast()) continue;
                continue block0;
            }
        }
    }

    private float getTabAdvance() {
        float spaceAdvance = 0.0f;
        if (this.spans != null) {
            for (int i = 0; i < this.spans.length; ++i) {
                TextSpan span = this.spans[i];
                PGFont font = (PGFont)span.getFont();
                if (font == null) continue;
                FontStrike strike = font.getStrike(IDENTITY);
                spaceAdvance = strike.getCharAdvance(' ');
                break;
            }
        } else {
            spaceAdvance = this.strike.getCharAdvance(' ');
        }
        return (float)this.tabSize * spaceAdvance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layout() {
        float align;
        this.initCache();
        if (this.lines != null) {
            return;
        }
        char[] chars = this.getText();
        if ((this.flags & 2) != 0 && this.isSimpleLayout()) {
            this.reuseRuns();
        } else {
            this.buildRuns(chars);
        }
        GlyphLayout layout = null;
        if ((this.flags & 0x10) != 0) {
            layout = GlyphLayout.getInstance();
        }
        float tabAdvance = 0.0f;
        if ((this.flags & 4) != 0) {
            tabAdvance = this.getTabAdvance();
        }
        BreakIterator boundary = null;
        if (this.wrapWidth > 0.0f && (this.flags & 0x50) != 0) {
            boundary = BreakIterator.getLineInstance();
            boundary.setText(new CharArrayIterator(chars));
        }
        int textAlignment = this.flags & 0x3C0000;
        if (this.isSimpleLayout()) {
            if (this.layoutCache == null) {
                this.layoutCache = new LayoutCache();
                this.layoutCache.glyphs = new int[chars.length];
                this.layoutCache.advances = new float[chars.length];
            }
        } else {
            this.layoutCache = null;
        }
        float lineWidth = 0.0f;
        int startIndex = 0;
        int startOffset = 0;
        ArrayList<TextLine> linesList = new ArrayList<TextLine>();
        for (int i = 0; i < this.runCount; ++i) {
            TextRun run = this.runs[i];
            this.shape(run, chars, layout);
            if (run.isTab()) {
                float tabStop = (float)((int)(lineWidth / tabAdvance) + 1) * tabAdvance;
                run.setWidth(tabStop - lineWidth);
            }
            float runWidth = run.getWidth();
            if (this.wrapWidth > 0.0f && lineWidth + runWidth > this.wrapWidth && !run.isLinebreak()) {
                int breakOffsetInRun;
                int breakRunIndex;
                int breakOffset;
                int runEnd;
                int hitOffset = run.getStart() + run.getWrapIndex(this.wrapWidth - lineWidth);
                int offset = hitOffset;
                if (offset + 1 >= (runEnd = run.getEnd()) || chars[offset] == ' ') {
                    // empty if block
                }
                if (boundary != null) {
                    breakOffset = boundary.isBoundary(offset) || chars[offset] == '\t' ? offset : boundary.preceding(offset);
                } else {
                    boolean currentChar = Character.isWhitespace(chars[breakOffset]);
                    for (breakOffset = ++offset; breakOffset > startOffset; --breakOffset) {
                        boolean previousChar = Character.isWhitespace(chars[breakOffset - 1]);
                        if (!currentChar && previousChar) break;
                        currentChar = previousChar;
                    }
                }
                if (breakOffset < startOffset) {
                    breakOffset = startOffset;
                }
                TextRun breakRun = null;
                for (breakRunIndex = startIndex; breakRunIndex < this.runCount && (breakRun = this.runs[breakRunIndex]).getEnd() <= breakOffset; ++breakRunIndex) {
                }
                if (breakOffset == startOffset) {
                    breakRun = run;
                    breakRunIndex = i;
                    breakOffset = hitOffset;
                }
                if ((breakOffsetInRun = breakOffset - breakRun.getStart()) == 0 && breakRunIndex != startIndex) {
                    i = breakRunIndex - 1;
                } else {
                    i = breakRunIndex;
                    if (breakOffsetInRun == 0) {
                        ++breakOffsetInRun;
                    }
                    if (breakOffsetInRun < breakRun.getLength()) {
                        if (this.runCount >= this.runs.length) {
                            TextRun[] newRuns = new TextRun[this.runs.length + 64];
                            System.arraycopy(this.runs, 0, newRuns, 0, i + 1);
                            System.arraycopy(this.runs, i + 1, newRuns, i + 2, this.runs.length - i - 1);
                            this.runs = newRuns;
                        } else {
                            System.arraycopy(this.runs, i + 1, this.runs, i + 2, this.runCount - i - 1);
                        }
                        this.runs[i + 1] = breakRun.split(breakOffsetInRun);
                        if (breakRun.isComplex()) {
                            this.shape(breakRun, chars, layout);
                        }
                        ++this.runCount;
                    }
                }
                if (i + 1 < this.runCount && !this.runs[i + 1].isLinebreak()) {
                    run = this.runs[i];
                    run.setSoftbreak();
                    this.flags |= 0x80;
                }
            }
            lineWidth += runWidth;
            if (!run.isBreak()) continue;
            TextLine line = this.createLine(startIndex, i, startOffset);
            linesList.add(line);
            startIndex = i + 1;
            startOffset += line.getLength();
            lineWidth = 0.0f;
        }
        if (layout != null) {
            layout.dispose();
        }
        linesList.add(this.createLine(startIndex, this.runCount - 1, startOffset));
        this.lines = new TextLine[linesList.size()];
        linesList.toArray(this.lines);
        float fullWidth = Math.max(this.wrapWidth, this.layoutWidth);
        float lineY = 0.0f;
        if (this.isMirrored()) {
            align = 1.0f;
            if (textAlignment == 0x100000) {
                align = 0.0f;
            }
        } else {
            align = 0.0f;
            if (textAlignment == 0x100000) {
                align = 1.0f;
            }
        }
        if (textAlignment == 524288) {
            align = 0.5f;
        }
        for (int i = 0; i < this.lines.length; ++i) {
            TextRun[] lineRuns;
            int lineRunCount;
            boolean justify;
            TextLine line = this.lines[i];
            int lineStart = line.getStart();
            RectBounds bounds = line.getBounds();
            float lineX = (fullWidth - bounds.getWidth()) * align;
            line.setAlignment(lineX);
            boolean bl = justify = this.wrapWidth > 0.0f && textAlignment == 0x200000;
            if (justify && (lineRunCount = (lineRuns = line.getRuns()).length) > 0 && lineRuns[lineRunCount - 1].isSoftbreak()) {
                int lineEnd = lineStart + line.getLength();
                int wsCount = 0;
                boolean hitChar = false;
                for (int j = lineEnd - 1; j >= lineStart; --j) {
                    if (!hitChar && chars[j] != ' ') {
                        hitChar = true;
                    }
                    if (!hitChar || chars[j] != ' ') continue;
                    ++wsCount;
                }
                if (wsCount != 0) {
                    float inc = (fullWidth - bounds.getWidth()) / (float)wsCount;
                    block8: for (int j = 0; j < lineRunCount; ++j) {
                        TextRun textRun = lineRuns[j];
                        int runStart = textRun.getStart();
                        int runEnd = textRun.getEnd();
                        for (int k = runStart; k < runEnd; ++k) {
                            if (chars[k] != ' ') continue;
                            textRun.justify(k - runStart, inc);
                            if (--wsCount == 0) break block8;
                        }
                    }
                    lineX = 0.0f;
                    line.setAlignment(lineX);
                    line.setWidth(fullWidth);
                }
            }
            if ((this.flags & 8) != 0) {
                this.reorderLine(line);
            }
            this.computeSideBearings(line);
            float runX = lineX;
            TextRun[] lineRuns2 = line.getRuns();
            for (int j = 0; j < lineRuns2.length; ++j) {
                TextRun run = lineRuns2[j];
                run.setLocation(runX, lineY);
                run.setLine(line);
                runX += run.getWidth();
            }
            if (i + 1 < this.lines.length) {
                lineY = Math.max(lineY, lineY + bounds.getHeight() + this.spacing);
                continue;
            }
            lineY += bounds.getHeight() - line.getLeading();
        }
        float ascent = this.lines[0].getBounds().getMinY();
        this.layoutHeight = lineY;
        this.logicalBounds = this.logicalBounds.deriveWithNewBounds(0.0f, ascent, 0.0f, this.layoutWidth, this.layoutHeight + ascent, 0.0f);
        if (this.layoutCache != null) {
            if (this.cacheKey != null && !this.layoutCache.valid && !this.copyCache()) {
                this.layoutCache.font = this.font;
                this.layoutCache.text = this.text;
                this.layoutCache.runs = this.runs;
                this.layoutCache.runCount = this.runCount;
                this.layoutCache.lines = this.lines;
                this.layoutCache.layoutWidth = this.layoutWidth;
                this.layoutCache.layoutHeight = this.layoutHeight;
                this.layoutCache.analysis = this.flags & 0x7FF;
                Object object = CACHE_SIZE_LOCK;
                synchronized (object) {
                    int charCount = chars.length;
                    if (cacheSize + charCount > MAX_CACHE_SIZE) {
                        stringCache.clear();
                        cacheSize = 0;
                    }
                    stringCache.put(this.cacheKey, this.layoutCache);
                    cacheSize += charCount;
                }
            }
            this.layoutCache.valid = true;
        }
    }

    @Override
    public BaseBounds getVisualBounds(int type) {
        boolean hasStrikethrough;
        this.ensureLayout();
        if (this.strike == null) {
            return null;
        }
        boolean underline = (type & 2) != 0;
        boolean hasUnderline = (this.flags & 0x200) != 0;
        boolean strikethrough = (type & 4) != 0;
        boolean bl = hasStrikethrough = (this.flags & 0x400) != 0;
        if (this.visualBounds != null && underline == hasUnderline && strikethrough == hasStrikethrough) {
            return this.visualBounds;
        }
        this.flags &= 0xFFFFF9FF;
        if (underline) {
            this.flags |= 0x200;
        }
        if (strikethrough) {
            this.flags |= 0x400;
        }
        this.visualBounds = new RectBounds();
        float xMin = Float.POSITIVE_INFINITY;
        float yMin = Float.POSITIVE_INFINITY;
        float xMax = Float.NEGATIVE_INFINITY;
        float yMax = Float.NEGATIVE_INFINITY;
        float[] bounds = new float[4];
        FontResource fr = this.strike.getFontResource();
        Metrics metrics = this.strike.getMetrics();
        float size = this.strike.getSize();
        for (int i = 0; i < this.lines.length; ++i) {
            TextLine line = this.lines[i];
            TextRun[] runs = line.getRuns();
            for (int j = 0; j < runs.length; ++j) {
                TextRun run = runs[j];
                Point2D pt = run.getLocation();
                if (run.isLinebreak()) continue;
                int glyphCount = run.getGlyphCount();
                for (int gi = 0; gi < glyphCount; ++gi) {
                    int gc = run.getGlyphCode(gi);
                    if (gc == 65535) continue;
                    fr.getGlyphBoundingBox(run.getGlyphCode(gi), size, bounds);
                    if (bounds[0] == bounds[2]) continue;
                    float glyphX = pt.x + run.getPosX(gi);
                    float glyphY = pt.y + run.getPosY(gi);
                    float glyphMinX = glyphX + bounds[0];
                    float glyphMinY = glyphY - bounds[3];
                    float glyphMaxX = glyphX + bounds[2];
                    float glyphMaxY = glyphY - bounds[1];
                    if (glyphMinX < xMin) {
                        xMin = glyphMinX;
                    }
                    if (glyphMinY < yMin) {
                        yMin = glyphMinY;
                    }
                    if (glyphMaxX > xMax) {
                        xMax = glyphMaxX;
                    }
                    if (!(glyphMaxY > yMax)) continue;
                    yMax = glyphMaxY;
                }
                if (underline) {
                    float underlineMinX = pt.x;
                    float underlineMinY = pt.y + metrics.getUnderLineOffset();
                    float underlineMaxX = underlineMinX + run.getWidth();
                    float underlineMaxY = underlineMinY + metrics.getUnderLineThickness();
                    if (underlineMinX < xMin) {
                        xMin = underlineMinX;
                    }
                    if (underlineMinY < yMin) {
                        yMin = underlineMinY;
                    }
                    if (underlineMaxX > xMax) {
                        xMax = underlineMaxX;
                    }
                    if (underlineMaxY > yMax) {
                        yMax = underlineMaxY;
                    }
                }
                if (!strikethrough) continue;
                float strikethroughMinX = pt.x;
                float strikethroughMinY = pt.y + metrics.getStrikethroughOffset();
                float strikethroughMaxX = strikethroughMinX + run.getWidth();
                float strikethroughMaxY = strikethroughMinY + metrics.getStrikethroughThickness();
                if (strikethroughMinX < xMin) {
                    xMin = strikethroughMinX;
                }
                if (strikethroughMinY < yMin) {
                    yMin = strikethroughMinY;
                }
                if (strikethroughMaxX > xMax) {
                    xMax = strikethroughMaxX;
                }
                if (!(strikethroughMaxY > yMax)) continue;
                yMax = strikethroughMaxY;
            }
        }
        if (xMin < xMax && yMin < yMax) {
            this.visualBounds.setBounds(xMin, yMin, xMax, yMax);
        }
        return this.visualBounds;
    }

    private void computeSideBearings(TextLine line) {
        TextRun[] runs = line.getRuns();
        if (runs.length == 0) {
            return;
        }
        float[] bounds = new float[4];
        FontResource defaultFontResource = null;
        float size = 0.0f;
        if (this.strike != null) {
            defaultFontResource = this.strike.getFontResource();
            size = this.strike.getSize();
        }
        float lsb = 0.0f;
        float width = 0.0f;
        block0: for (int i = 0; i < runs.length; ++i) {
            TextRun run = runs[i];
            int glyphCount = run.getGlyphCount();
            for (int gi = 0; gi < glyphCount; ++gi) {
                int gc;
                float advance = run.getAdvance(gi);
                if (advance != 0.0f && (gc = run.getGlyphCode(gi)) != 65535) {
                    FontResource fr = defaultFontResource;
                    if (fr == null) {
                        TextSpan span = run.getTextSpan();
                        PGFont font = (PGFont)span.getFont();
                        size = font.getSize();
                        fr = font.getFontResource();
                    }
                    fr.getGlyphBoundingBox(gc, size, bounds);
                    float glyphLsb = bounds[0];
                    lsb = Math.min(0.0f, glyphLsb + width);
                    run.setLeftBearing();
                    break block0;
                }
                width += advance;
            }
            if (glyphCount != 0) continue;
            width += run.getWidth();
        }
        float rsb = 0.0f;
        width = 0.0f;
        block2: for (int i = runs.length - 1; i >= 0; --i) {
            TextRun run = runs[i];
            int glyphCount = run.getGlyphCount();
            for (int gi = glyphCount - 1; gi >= 0; --gi) {
                int gc;
                float advance = run.getAdvance(gi);
                if (advance != 0.0f && (gc = run.getGlyphCode(gi)) != 65535) {
                    FontResource fr = defaultFontResource;
                    if (fr == null) {
                        TextSpan span = run.getTextSpan();
                        PGFont font = (PGFont)span.getFont();
                        size = font.getSize();
                        fr = font.getFontResource();
                    }
                    fr.getGlyphBoundingBox(gc, size, bounds);
                    float glyphRsb = bounds[2] - advance;
                    rsb = Math.max(0.0f, glyphRsb - width);
                    run.setRightBearing();
                    break block2;
                }
                width += advance;
            }
            if (glyphCount != 0) continue;
            width += run.getWidth();
        }
        line.setSideBearings(lsb, rsb);
    }
}

