/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk;

import com.sun.javafx.FXPermissions;
import java.lang.reflect.Constructor;
import java.security.AccessControlContext;
import java.security.AccessControlException;
import java.security.Permission;

public class PermissionHelper {
    private static boolean awtInitialized = false;
    private static Permission awtClipboardPermission;

    private static synchronized Permission getAWTClipboardPermission() {
        if (!awtInitialized) {
            try {
                Class<?> clazz = Class.forName("java.awt.AWTPermission", false, PermissionHelper.class.getClassLoader());
                Constructor<?> c = clazz.getConstructor(String.class);
                awtClipboardPermission = (Permission)c.newInstance("accessClipboard");
            }
            catch (Exception ex) {
                awtClipboardPermission = null;
            }
            awtInitialized = true;
        }
        return awtClipboardPermission;
    }

    public static void checkClipboardPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        try {
            securityManager.checkPermission((Permission)FXPermissions.ACCESS_CLIPBOARD_PERMISSION);
        }
        catch (SecurityException ex) {
            Permission perm = PermissionHelper.getAWTClipboardPermission();
            if (perm == null) {
                throw ex;
            }
            try {
                securityManager.checkPermission(perm);
            }
            catch (SecurityException ex2) {
                throw ex;
            }
        }
    }

    public static void checkClipboardPermission(AccessControlContext context) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        if (context == null) {
            throw new AccessControlException("AccessControlContext is null");
        }
        try {
            securityManager.checkPermission((Permission)FXPermissions.ACCESS_CLIPBOARD_PERMISSION, context);
        }
        catch (SecurityException ex) {
            Permission perm = PermissionHelper.getAWTClipboardPermission();
            if (perm == null) {
                throw ex;
            }
            try {
                securityManager.checkPermission(perm, context);
            }
            catch (SecurityException ex2) {
                throw ex;
            }
        }
    }

    private PermissionHelper() {
    }
}

