/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.Screen;
import com.sun.glass.ui.View;
import com.sun.javafx.FXPermissions;
import com.sun.javafx.PlatformUtil;
import com.sun.javafx.iio.common.PushbroomScaler;
import com.sun.javafx.iio.common.ScalerFactory;
import com.sun.javafx.tk.FocusCause;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.quantum.GlassAppletWindow;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.GlassStage;
import com.sun.javafx.tk.quantum.GlassSystemMenu;
import com.sun.javafx.tk.quantum.GlassWindowEventHandler;
import com.sun.javafx.tk.quantum.OverlayWarning;
import com.sun.javafx.tk.quantum.PixelUtils;
import com.sun.javafx.tk.quantum.QuantumRenderer;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Image;
import com.sun.prism.PixelFormat;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.scene.input.KeyCombination;
import javafx.scene.paint.Color;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

class WindowStage
extends GlassStage {
    protected com.sun.glass.ui.Window platformWindow;
    protected Stage fxStage;
    private StageStyle style;
    private GlassStage owner = null;
    private Modality modality = Modality.NONE;
    private final boolean securityDialog;
    private OverlayWarning warning = null;
    private boolean rtl = false;
    private boolean transparent = false;
    private boolean isPrimaryStage = false;
    private boolean isAppletStage = false;
    private boolean isPopupStage = false;
    private boolean isInFullScreen = false;
    private boolean isAlwaysOnTop = false;
    private boolean inAllowedEventHandler = false;
    private static List<WindowStage> activeWindows = new LinkedList<WindowStage>();
    private static Map<com.sun.glass.ui.Window, WindowStage> platformWindows = new HashMap<com.sun.glass.ui.Window, WindowStage>();
    private static GlassAppletWindow appletWindow = null;
    private static final Locale LOCALE = Locale.getDefault();
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(WindowStage.class.getPackage().getName() + ".QuantumMessagesBundle", LOCALE);
    private boolean fullScreenFromUserEvent = false;
    private KeyCombination savedFullScreenExitKey = null;
    private boolean isClosePostponed = false;
    private com.sun.glass.ui.Window deadWindow = null;

    static void setAppletWindow(GlassAppletWindow aw) {
        appletWindow = aw;
    }

    static GlassAppletWindow getAppletWindow() {
        return appletWindow;
    }

    public WindowStage(Window peerWindow, boolean securityDialog, StageStyle stageStyle, Modality modality, TKStage owner) {
        this.style = stageStyle;
        this.owner = (GlassStage)owner;
        this.modality = modality;
        this.securityDialog = securityDialog;
        this.fxStage = peerWindow instanceof Stage ? (Stage)peerWindow : null;
        boolean bl = this.transparent = stageStyle == StageStyle.TRANSPARENT;
        if (owner == null && this.modality == Modality.WINDOW_MODAL) {
            this.modality = Modality.NONE;
        }
    }

    final void setIsPrimary() {
        this.isPrimaryStage = true;
        if (appletWindow != null) {
            this.isAppletStage = true;
        }
    }

    final void setIsPopup() {
        this.isPopupStage = true;
    }

    final boolean isSecurityDialog() {
        return this.securityDialog;
    }

    public final WindowStage init(GlassSystemMenu sysmenu) {
        this.initPlatformWindow();
        this.platformWindow.setEventHandler(new GlassWindowEventHandler(this));
        if (sysmenu.isSupported()) {
            sysmenu.createMenuBar();
            this.platformWindow.setMenuBar(sysmenu.getMenuBar());
        }
        return this;
    }

    private void initPlatformWindow() {
        if (this.platformWindow == null) {
            Application app = Application.GetApplication();
            if (this.isPrimaryStage && null != appletWindow) {
                this.platformWindow = app.createWindow(appletWindow.getGlassWindow().getNativeWindow());
            } else {
                int windowMask;
                com.sun.glass.ui.Window ownerWindow = null;
                if (this.owner instanceof WindowStage) {
                    ownerWindow = ((WindowStage)this.owner).platformWindow;
                }
                boolean resizable = false;
                boolean focusable = true;
                int n = windowMask = this.rtl ? 128 : 0;
                if (this.isPopupStage) {
                    windowMask |= 8;
                    if (this.style == StageStyle.TRANSPARENT) {
                        windowMask |= 2;
                    }
                    focusable = false;
                } else {
                    switch (this.style) {
                        case UNIFIED: {
                            if (app.supportsUnifiedWindows()) {
                                windowMask |= 0x100;
                            }
                        }
                        case DECORATED: {
                            windowMask |= 0x71;
                            if (ownerWindow != null || this.modality != Modality.NONE) {
                                windowMask &= 0xFFFFFF9F;
                            }
                            resizable = true;
                            break;
                        }
                        case UTILITY: {
                            windowMask |= 0x15;
                            break;
                        }
                        default: {
                            windowMask |= (this.transparent ? 2 : 0) | 0x10;
                        }
                    }
                }
                if (this.modality != Modality.NONE) {
                    windowMask |= 0x200;
                }
                this.platformWindow = app.createWindow(ownerWindow, Screen.getMainScreen(), windowMask);
                this.platformWindow.setResizable(resizable);
                this.platformWindow.setFocusable(focusable);
                if (this.securityDialog) {
                    this.platformWindow.setLevel(2);
                }
                if (this.fxStage != null && this.fxStage.getScene() != null) {
                    Paint paint = this.fxStage.getScene().getFill();
                    if (paint instanceof Color) {
                        Color color = (Color)paint;
                        this.platformWindow.setBackground((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
                    } else if (paint instanceof LinearGradient) {
                        LinearGradient lgradient = (LinearGradient)paint;
                        this.computeAndSetBackground(lgradient.getStops());
                    } else if (paint instanceof RadialGradient) {
                        RadialGradient rgradient = (RadialGradient)paint;
                        this.computeAndSetBackground(rgradient.getStops());
                    }
                }
            }
        }
        platformWindows.put(this.platformWindow, this);
    }

    private void computeAndSetBackground(List<Stop> stops) {
        if (stops.size() == 1) {
            Color color = stops.get(0).getColor();
            this.platformWindow.setBackground((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
        } else if (stops.size() > 1) {
            Color color = stops.get(0).getColor();
            Color color2 = stops.get(stops.size() - 1).getColor();
            this.platformWindow.setBackground((float)((color.getRed() + color2.getRed()) / 2.0), (float)((color.getGreen() + color2.getGreen()) / 2.0), (float)((color.getBlue() + color2.getBlue()) / 2.0));
        }
    }

    final com.sun.glass.ui.Window getPlatformWindow() {
        return this.platformWindow;
    }

    static WindowStage findWindowStage(com.sun.glass.ui.Window platformWindow) {
        return platformWindows.get(platformWindow);
    }

    protected GlassStage getOwner() {
        return this.owner;
    }

    protected ViewScene getViewScene() {
        return (ViewScene)this.getScene();
    }

    StageStyle getStyle() {
        return this.style;
    }

    @Override
    public TKScene createTKScene(boolean depthBuffer, boolean msaa, AccessControlContext acc) {
        ViewScene scene = new ViewScene(depthBuffer, msaa);
        scene.setSecurityContext(acc);
        return scene;
    }

    @Override
    public void setScene(TKScene scene) {
        GlassScene oldScene = this.getScene();
        if (oldScene == scene) {
            return;
        }
        this.exitFullScreen();
        super.setScene(scene);
        if (scene != null) {
            ViewScene newScene = this.getViewScene();
            View view = ((GlassScene)newScene).getPlatformView();
            QuantumToolkit.runWithRenderLock(() -> {
                this.platformWindow.setView(view);
                if (oldScene != null) {
                    oldScene.updateSceneState();
                }
                newScene.updateSceneState();
                return null;
            });
            this.requestFocus();
        } else {
            QuantumToolkit.runWithRenderLock(() -> {
                if (this.platformWindow != null) {
                    this.platformWindow.setView(null);
                }
                if (oldScene != null) {
                    oldScene.updateSceneState();
                }
                return null;
            });
        }
        if (oldScene != null) {
            ViewPainter painter = ((ViewScene)oldScene).getPainter();
            QuantumRenderer.getInstance().disposePresentable(painter.presentable);
        }
    }

    @Override
    public void setBounds(float x, float y, boolean xSet, boolean ySet, float w, float h, float cw, float ch, float xGravity, float yGravity, float renderScaleX, float renderScaleY) {
        if ((double)renderScaleX > 0.0 || (double)renderScaleY > 0.0) {
            ViewScene vscene;
            if ((double)renderScaleX > 0.0) {
                this.platformWindow.setRenderScaleX(renderScaleX);
            }
            if ((double)renderScaleY > 0.0) {
                this.platformWindow.setRenderScaleY(renderScaleY);
            }
            if ((vscene = this.getViewScene()) != null) {
                vscene.updateSceneState();
                vscene.entireSceneNeedsRepaint();
            }
        }
        if (this.isAppletStage) {
            ySet = false;
            xSet = false;
        }
        if (xSet || ySet || w > 0.0f || h > 0.0f || cw > 0.0f || ch > 0.0f) {
            this.platformWindow.setBounds(x, y, xSet, ySet, w, h, cw, ch, xGravity, yGravity);
        }
    }

    @Override
    public float getPlatformScaleX() {
        return this.platformWindow.getPlatformScaleX();
    }

    @Override
    public float getPlatformScaleY() {
        return this.platformWindow.getPlatformScaleY();
    }

    @Override
    public float getOutputScaleX() {
        return this.platformWindow.getOutputScaleX();
    }

    @Override
    public float getOutputScaleY() {
        return this.platformWindow.getOutputScaleY();
    }

    @Override
    public void setMinimumSize(int minWidth, int minHeight) {
        minWidth = (int)Math.ceil((float)minWidth * this.getPlatformScaleX());
        minHeight = (int)Math.ceil((float)minHeight * this.getPlatformScaleY());
        this.platformWindow.setMinimumSize(minWidth, minHeight);
    }

    @Override
    public void setMaximumSize(int maxWidth, int maxHeight) {
        maxWidth = (int)Math.ceil((float)maxWidth * this.getPlatformScaleX());
        maxHeight = (int)Math.ceil((float)maxHeight * this.getPlatformScaleY());
        this.platformWindow.setMaximumSize(maxWidth, maxHeight);
    }

    static Image findBestImage(List icons, int width, int height) {
        Image image = null;
        double bestSimilarity = 3.0;
        for (Object icon : icons) {
            int adjh;
            int adjw;
            Image im = (Image)icon;
            if (im == null || im.getPixelFormat() != PixelFormat.BYTE_RGB && im.getPixelFormat() != PixelFormat.BYTE_BGRA_PRE && im.getPixelFormat() != PixelFormat.BYTE_GRAY) continue;
            int iw = im.getWidth();
            int ih = im.getHeight();
            if (iw <= 0 || ih <= 0) continue;
            double scaleFactor = Math.min((double)width / (double)iw, (double)height / (double)ih);
            double scaleMeasure = 1.0;
            if (scaleFactor >= 2.0) {
                scaleFactor = Math.floor(scaleFactor);
                adjw = iw * (int)scaleFactor;
                adjh = ih * (int)scaleFactor;
                scaleMeasure = 1.0 - 0.5 / scaleFactor;
            } else if (scaleFactor >= 1.0) {
                scaleFactor = 1.0;
                adjw = iw;
                adjh = ih;
                scaleMeasure = 0.0;
            } else if (scaleFactor >= 0.75) {
                scaleFactor = 0.75;
                adjw = iw * 3 / 4;
                adjh = ih * 3 / 4;
                scaleMeasure = 0.3;
            } else if (scaleFactor >= 0.6666) {
                scaleFactor = 0.6666;
                adjw = iw * 2 / 3;
                adjh = ih * 2 / 3;
                scaleMeasure = 0.33;
            } else {
                double scaleDivider = Math.ceil(1.0 / scaleFactor);
                scaleFactor = 1.0 / scaleDivider;
                adjw = (int)Math.round((double)iw / scaleDivider);
                adjh = (int)Math.round((double)ih / scaleDivider);
                scaleMeasure = 1.0 - 1.0 / scaleDivider;
            }
            double similarity = ((double)width - (double)adjw) / (double)width + ((double)height - (double)adjh) / (double)height + scaleMeasure;
            if (similarity < bestSimilarity) {
                bestSimilarity = similarity;
                image = im;
            }
            if (similarity != 0.0) continue;
            break;
        }
        return image;
    }

    @Override
    public void setIcons(List icons) {
        int SMALL_ICON_HEIGHT = 32;
        int SMALL_ICON_WIDTH = 32;
        if (PlatformUtil.isMac()) {
            SMALL_ICON_HEIGHT = 128;
            SMALL_ICON_WIDTH = 128;
        } else if (PlatformUtil.isWindows()) {
            SMALL_ICON_HEIGHT = 32;
            SMALL_ICON_WIDTH = 32;
        } else if (PlatformUtil.isLinux() || PlatformUtil.isFreeBSD()) {
            SMALL_ICON_HEIGHT = 128;
            SMALL_ICON_WIDTH = 128;
        }
        if (icons == null || icons.size() < 1) {
            this.platformWindow.setIcon(null);
            return;
        }
        Image image = WindowStage.findBestImage(icons, SMALL_ICON_WIDTH, SMALL_ICON_HEIGHT);
        if (image == null) {
            return;
        }
        PushbroomScaler scaler = ScalerFactory.createScaler(image.getWidth(), image.getHeight(), image.getBytesPerPixelUnit(), SMALL_ICON_WIDTH, SMALL_ICON_HEIGHT, true);
        ByteBuffer buf = (ByteBuffer)image.getPixelBuffer();
        byte[] bytes = new byte[buf.limit()];
        int iheight = image.getHeight();
        for (int z = 0; z < iheight; ++z) {
            buf.position(z * image.getScanlineStride());
            buf.get(bytes, 0, image.getScanlineStride());
            scaler.putSourceScanline(bytes, 0);
        }
        buf.rewind();
        Image img = image.iconify(scaler.getDestination(), SMALL_ICON_WIDTH, SMALL_ICON_HEIGHT);
        this.platformWindow.setIcon(PixelUtils.imageToPixels(img));
    }

    @Override
    public void setTitle(String title) {
        this.platformWindow.setTitle(title);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            WindowStage.removeActiveWindow(this);
            if (this.modality == Modality.WINDOW_MODAL) {
                if (this.owner != null && this.owner instanceof WindowStage) {
                    ((WindowStage)this.owner).setEnabled(true);
                }
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(true);
            }
            if (!this.isPopupStage && this.owner != null && this.owner instanceof WindowStage) {
                WindowStage ownerStage = (WindowStage)this.owner;
                ownerStage.requestToFront();
            }
        }
        QuantumToolkit.runWithRenderLock(() -> {
            if (this.platformWindow != null) {
                this.platformWindow.setVisible(visible);
            }
            super.setVisible(visible);
            return null;
        });
        if (visible) {
            if (this.modality == Modality.WINDOW_MODAL) {
                if (this.owner != null && this.owner instanceof WindowStage) {
                    ((WindowStage)this.owner).setEnabled(false);
                }
            } else if (this.modality == Modality.APPLICATION_MODAL) {
                this.windowsSetEnabled(false);
            }
            if (this.isAppletStage && null != appletWindow) {
                appletWindow.assertStageOrder();
            }
        }
        this.applyFullScreen();
    }

    @Override
    boolean isVisible() {
        return this.platformWindow.isVisible();
    }

    @Override
    public void setOpacity(float opacity) {
        this.platformWindow.setAlpha(opacity);
        GlassScene gs = this.getScene();
        if (gs != null) {
            gs.entireSceneNeedsRepaint();
        }
    }

    public boolean needsUpdateWindow() {
        return this.transparent && Application.GetApplication().shouldUpdateWindow();
    }

    @Override
    public void setIconified(boolean iconified) {
        if (this.platformWindow.isMinimized() == iconified) {
            return;
        }
        this.platformWindow.minimize(iconified);
    }

    @Override
    public void setMaximized(boolean maximized) {
        if (this.platformWindow.isMaximized() == maximized) {
            return;
        }
        this.platformWindow.maximize(maximized);
    }

    @Override
    public void setAlwaysOnTop(boolean alwaysOnTop) {
        if (this.securityDialog) {
            return;
        }
        if (this.isAlwaysOnTop == alwaysOnTop) {
            return;
        }
        if (alwaysOnTop) {
            if (this.hasPermission((Permission)FXPermissions.SET_WINDOW_ALWAYS_ON_TOP_PERMISSION)) {
                this.platformWindow.setLevel(2);
            } else {
                alwaysOnTop = false;
                if (this.stageListener != null) {
                    this.stageListener.changedAlwaysOnTop(alwaysOnTop);
                }
            }
        } else {
            this.platformWindow.setLevel(1);
        }
        this.isAlwaysOnTop = alwaysOnTop;
    }

    @Override
    public void setResizable(boolean resizable) {
        this.platformWindow.setResizable(resizable);
    }

    boolean isTrustedFullScreen() {
        return this.hasPermission((Permission)FXPermissions.UNRESTRICTED_FULL_SCREEN_PERMISSION);
    }

    void exitFullScreen() {
        this.setFullScreen(false);
    }

    boolean isApplet() {
        return this.isPrimaryStage && null != appletWindow;
    }

    private boolean hasPermission(Permission perm) {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(perm, this.getAccessControlContext());
            }
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public final KeyCombination getSavedFullScreenExitKey() {
        return this.savedFullScreenExitKey;
    }

    private void applyFullScreen() {
        if (this.platformWindow == null) {
            return;
        }
        View v = this.platformWindow.getView();
        if (this.isVisible() && v != null && v.isInFullscreen() != this.isInFullScreen) {
            if (this.isInFullScreen) {
                boolean isTrusted = this.isTrustedFullScreen();
                if (!isTrusted && !this.fullScreenFromUserEvent) {
                    this.exitFullScreen();
                    this.fullscreenChanged(false);
                } else {
                    v.enterFullscreen(false, false, false);
                    if (this.warning != null && this.warning.inWarningTransition()) {
                        this.warning.setView(this.getViewScene());
                    } else {
                        boolean showWarning = true;
                        KeyCombination key = null;
                        String exitMessage = null;
                        if (isTrusted && this.fxStage != null) {
                            key = this.fxStage.getFullScreenExitKeyCombination();
                            exitMessage = this.fxStage.getFullScreenExitHint();
                        }
                        KeyCombination keyCombination = this.savedFullScreenExitKey = key == null ? defaultFullScreenExitKeycombo : key;
                        if ("".equals(exitMessage) || this.savedFullScreenExitKey.equals(KeyCombination.NO_MATCH)) {
                            showWarning = false;
                        }
                        if (showWarning && exitMessage == null) {
                            if (key == null) {
                                exitMessage = RESOURCES.getString("OverlayWarningESC");
                            } else {
                                String f = RESOURCES.getString("OverlayWarningKey");
                                exitMessage = String.format(f, this.savedFullScreenExitKey.toString());
                            }
                        }
                        if (showWarning && this.warning == null) {
                            this.setWarning(new OverlayWarning(this.getViewScene()));
                        }
                        if (showWarning && this.warning != null) {
                            this.warning.warn(exitMessage);
                        }
                    }
                }
            } else {
                if (this.warning != null) {
                    this.warning.cancel();
                    this.setWarning(null);
                }
                v.exitFullscreen(false);
            }
            this.fullScreenFromUserEvent = false;
        } else if (!this.isVisible() && this.warning != null) {
            this.warning.cancel();
            this.setWarning(null);
        }
    }

    void setWarning(OverlayWarning newWarning) {
        this.warning = newWarning;
        this.getViewScene().synchroniseOverlayWarning();
    }

    OverlayWarning getWarning() {
        return this.warning;
    }

    @Override
    public void setFullScreen(boolean fullScreen) {
        if (this.isInFullScreen == fullScreen) {
            return;
        }
        if (this.isInAllowedEventHandler()) {
            this.fullScreenFromUserEvent = true;
        }
        GlassStage fsWindow = (GlassStage)activeFSWindow.get();
        if (fullScreen && fsWindow != null) {
            fsWindow.setFullScreen(false);
        }
        this.isInFullScreen = fullScreen;
        this.applyFullScreen();
        if (fullScreen) {
            activeFSWindow.set(this);
        }
    }

    void fullscreenChanged(boolean fs) {
        if (!fs) {
            if (activeFSWindow.compareAndSet(this, null)) {
                this.isInFullScreen = false;
            }
        } else {
            this.isInFullScreen = true;
            activeFSWindow.set(this);
        }
        AccessController.doPrivileged(() -> {
            if (this.stageListener != null) {
                this.stageListener.changedFullscreen(fs);
            }
            return null;
        }, this.getAccessControlContext());
    }

    @Override
    public void toBack() {
        this.platformWindow.toBack();
        if (this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public void toFront() {
        this.platformWindow.requestFocus();
        this.platformWindow.toFront();
        if (this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public void postponeClose() {
        this.isClosePostponed = true;
    }

    @Override
    public void closePostponed() {
        if (this.deadWindow != null) {
            this.deadWindow.close();
            this.deadWindow = null;
        }
    }

    @Override
    public void close() {
        super.close();
        QuantumToolkit.runWithRenderLock(() -> {
            ViewScene oldScene;
            if (this.platformWindow != null) {
                platformWindows.remove(this.platformWindow);
                if (this.isClosePostponed) {
                    this.deadWindow = this.platformWindow;
                } else {
                    this.platformWindow.close();
                }
                this.platformWindow = null;
            }
            if ((oldScene = this.getViewScene()) != null) {
                oldScene.updateSceneState();
            }
            return null;
        });
    }

    void setPlatformWindowClosed() {
        if (this.platformWindow != null) {
            platformWindows.remove(this.platformWindow);
            this.platformWindow = null;
        }
    }

    static void addActiveWindow(WindowStage window) {
        activeWindows.remove(window);
        activeWindows.add(window);
    }

    static void removeActiveWindow(WindowStage window) {
        activeWindows.remove(window);
    }

    final void handleFocusDisabled() {
        if (activeWindows.isEmpty()) {
            return;
        }
        WindowStage window = activeWindows.get(activeWindows.size() - 1);
        window.setIconified(false);
        window.requestToFront();
        window.requestFocus();
    }

    @Override
    public boolean grabFocus() {
        return this.platformWindow.grabFocus();
    }

    @Override
    public void ungrabFocus() {
        this.platformWindow.ungrabFocus();
    }

    @Override
    public void requestFocus() {
        this.platformWindow.requestFocus();
    }

    @Override
    public void requestFocus(FocusCause cause) {
        switch (cause) {
            case TRAVERSED_FORWARD: {
                this.platformWindow.requestFocus(543);
                break;
            }
            case TRAVERSED_BACKWARD: {
                this.platformWindow.requestFocus(544);
                break;
            }
            case ACTIVATED: {
                this.platformWindow.requestFocus(542);
                break;
            }
            case DEACTIVATED: {
                this.platformWindow.requestFocus(541);
            }
        }
    }

    @Override
    protected void setPlatformEnabled(boolean enabled) {
        super.setPlatformEnabled(enabled);
        if (this.platformWindow != null) {
            this.platformWindow.setEnabled(enabled);
        }
        if (!enabled) {
            WindowStage.removeActiveWindow(this);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.owner != null && this.owner instanceof WindowStage) {
            ((WindowStage)this.owner).setEnabled(enabled);
        }
        if (enabled && (this.platformWindow == null || this.platformWindow.isClosed())) {
            return;
        }
        this.setPlatformEnabled(enabled);
        if (enabled && this.isAppletStage && null != appletWindow) {
            appletWindow.assertStageOrder();
        }
    }

    @Override
    public long getRawHandle() {
        return this.platformWindow.getRawHandle();
    }

    protected void requestToFront() {
        if (this.platformWindow != null) {
            this.platformWindow.toFront();
            this.platformWindow.requestFocus();
        }
    }

    public void setInAllowedEventHandler(boolean inAllowedEventHandler) {
        this.inAllowedEventHandler = inAllowedEventHandler;
    }

    private boolean isInAllowedEventHandler() {
        return this.inAllowedEventHandler;
    }

    @Override
    public void requestInput(String text, int type, double width, double height, double Mxx, double Mxy, double Mxz, double Mxt, double Myx, double Myy, double Myz, double Myt, double Mzx, double Mzy, double Mzz, double Mzt) {
        this.platformWindow.requestInput(text, type, width, height, Mxx, Mxy, Mxz, Mxt, Myx, Myy, Myz, Myt, Mzx, Mzy, Mzz, Mzt);
    }

    @Override
    public void releaseInput() {
        this.platformWindow.releaseInput();
    }

    @Override
    public void setRTL(boolean b) {
        this.rtl = b;
    }
}

