/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.marlin.Helpers;

final class Curve {
    float ax;
    float ay;
    float bx;
    float by;
    float cx;
    float cy;
    float dx;
    float dy;
    float dax;
    float day;
    float dbx;
    float dby;

    Curve() {
    }

    void set(float[] points, int type) {
        if (type == 8) {
            this.set(points[0], points[1], points[2], points[3], points[4], points[5], points[6], points[7]);
        } else if (type == 4) {
            this.set(points[0], points[1], points[2], points[3]);
        } else {
            this.set(points[0], points[1], points[2], points[3], points[4], points[5]);
        }
    }

    void set(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        float dx32 = 3.0f * (x3 - x2);
        float dy32 = 3.0f * (y3 - y2);
        float dx21 = 3.0f * (x2 - x1);
        float dy21 = 3.0f * (y2 - y1);
        this.ax = x4 - x1 - dx32;
        this.ay = y4 - y1 - dy32;
        this.bx = dx32 - dx21;
        this.by = dy32 - dy21;
        this.cx = dx21;
        this.cy = dy21;
        this.dx = x1;
        this.dy = y1;
        this.dax = 3.0f * this.ax;
        this.day = 3.0f * this.ay;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    void set(float x1, float y1, float x2, float y2, float x3, float y3) {
        float dx21 = x2 - x1;
        float dy21 = y2 - y1;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.bx = x3 - x2 - dx21;
        this.by = y3 - y2 - dy21;
        this.cx = 2.0f * dx21;
        this.cy = 2.0f * dy21;
        this.dx = x1;
        this.dy = y1;
        this.dax = 0.0f;
        this.day = 0.0f;
        this.dbx = 2.0f * this.bx;
        this.dby = 2.0f * this.by;
    }

    void set(float x1, float y1, float x2, float y2) {
        float dx21 = x2 - x1;
        float dy21 = y2 - y1;
        this.ax = 0.0f;
        this.ay = 0.0f;
        this.bx = 0.0f;
        this.by = 0.0f;
        this.cx = dx21;
        this.cy = dy21;
        this.dx = x1;
        this.dy = y1;
        this.dax = 0.0f;
        this.day = 0.0f;
        this.dbx = 0.0f;
        this.dby = 0.0f;
    }

    int dxRoots(float[] roots, int off) {
        return Helpers.quadraticRoots(this.dax, this.dbx, this.cx, roots, off);
    }

    int dyRoots(float[] roots, int off) {
        return Helpers.quadraticRoots(this.day, this.dby, this.cy, roots, off);
    }

    int infPoints(float[] pts, int off) {
        float a = this.dax * this.dby - this.dbx * this.day;
        float b = 2.0f * (this.cy * this.dax - this.day * this.cx);
        float c = this.cy * this.dbx - this.cx * this.dby;
        return Helpers.quadraticRoots(a, b, c, pts, off);
    }

    int xPoints(float[] ts, int off, float x) {
        return Helpers.cubicRootsInAB(this.ax, this.bx, this.cx, this.dx - x, ts, off, 0.0f, 1.0f);
    }

    int yPoints(float[] ts, int off, float y) {
        return Helpers.cubicRootsInAB(this.ay, this.by, this.cy, this.dy - y, ts, off, 0.0f, 1.0f);
    }

    private int perpendiculardfddf(float[] pts, int off) {
        assert (pts.length >= off + 4);
        float a = 2.0f * (this.dax * this.dax + this.day * this.day);
        float b = 3.0f * (this.dax * this.dbx + this.day * this.dby);
        float c = 2.0f * (this.dax * this.cx + this.day * this.cy) + this.dbx * this.dbx + this.dby * this.dby;
        float d = this.dbx * this.cx + this.dby * this.cy;
        return Helpers.cubicRootsInAB(a, b, c, d, pts, off, 0.0f, 1.0f);
    }

    int rootsOfROCMinusW(float[] roots, int off, float w2, float err) {
        assert (off <= 6 && roots.length >= 10);
        int ret = off;
        int end = off + this.perpendiculardfddf(roots, off);
        roots[end] = 1.0f;
        float t0 = 0.0f;
        float ft0 = this.ROCsq(t0) - w2;
        for (int i = off; i <= end; ++i) {
            float t1 = roots[i];
            float ft1 = this.ROCsq(t1) - w2;
            if (ft0 == 0.0f) {
                roots[ret++] = t0;
            } else if (ft1 * ft0 < 0.0f) {
                roots[ret++] = this.falsePositionROCsqMinusX(t0, t1, w2, err);
            }
            t0 = t1;
            ft0 = ft1;
        }
        return ret - off;
    }

    private static float eliminateInf(float x) {
        return x == Float.POSITIVE_INFINITY ? Float.MAX_VALUE : (x == Float.NEGATIVE_INFINITY ? Float.MIN_VALUE : x);
    }

    private float falsePositionROCsqMinusX(float t0, float t1, float w2, float err) {
        int iterLimit = 100;
        int side = 0;
        float t = t1;
        float ft = Curve.eliminateInf(this.ROCsq(t) - w2);
        float s = t0;
        float fs = Curve.eliminateInf(this.ROCsq(s) - w2);
        float r = s;
        for (int i = 0; i < 100 && Math.abs(t - s) > err * Math.abs(t + s); ++i) {
            r = (fs * t - ft * s) / (fs - ft);
            float fr = this.ROCsq(r) - w2;
            if (Curve.sameSign(fr, ft)) {
                ft = fr;
                t = r;
                if (side < 0) {
                    fs /= (float)(1 << -side);
                    --side;
                    continue;
                }
                side = -1;
                continue;
            }
            if (!(fr * fs > 0.0f)) break;
            fs = fr;
            s = r;
            if (side > 0) {
                ft /= (float)(1 << side);
                ++side;
                continue;
            }
            side = 1;
        }
        return r;
    }

    private static boolean sameSign(float x, float y) {
        return x < 0.0f && y < 0.0f || x > 0.0f && y > 0.0f;
    }

    private float ROCsq(float t) {
        float dx = t * (t * this.dax + this.dbx) + this.cx;
        float dy = t * (t * this.day + this.dby) + this.cy;
        float ddx = 2.0f * this.dax * t + this.dbx;
        float ddy = 2.0f * this.day * t + this.dby;
        float dx2dy2 = dx * dx + dy * dy;
        float ddx2ddy2 = ddx * ddx + ddy * ddy;
        float ddxdxddydy = ddx * dx + ddy * dy;
        return dx2dy2 * (dx2dy2 * dx2dy2 / (dx2dy2 * ddx2ddy2 - ddxdxddydy * ddxdxddydy));
    }
}

