/*
 * Decompiled with CFR 0.152.
 */
package com.sun.marlin;

import com.sun.javafx.geom.PathConsumer2D;
import com.sun.marlin.Curve;
import com.sun.marlin.Helpers;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D;
import java.util.Arrays;

public final class Stroker
implements PathConsumer2D,
MarlinConst {
    private static final int MOVE_TO = 0;
    private static final int DRAWING_OP_TO = 1;
    private static final int CLOSE = 2;
    private static final float ERR_JOIN = 1.0f / MIN_SUBPIXELS;
    private static final float ROUND_JOIN_THRESHOLD = ERR_JOIN * ERR_JOIN;
    private static final float C = (float)(4.0 * (Math.sqrt(2.0) - 1.0) / 3.0);
    private static final float SQRT_2 = (float)Math.sqrt(2.0);
    private PathConsumer2D out;
    private int capStyle;
    private int joinStyle;
    private float lineWidth2;
    private float invHalfLineWidth2Sq;
    private final float[] offset0 = new float[2];
    private final float[] offset1 = new float[2];
    private final float[] offset2 = new float[2];
    private final float[] miter = new float[2];
    private float miterLimitSq;
    private int prev;
    private float sx0;
    private float sy0;
    private float sdx;
    private float sdy;
    private float cx0;
    private float cy0;
    private float cdx;
    private float cdy;
    private float smx;
    private float smy;
    private float cmx;
    private float cmy;
    private final Helpers.PolyStack reverse;
    private final float[] lp = new float[8];
    private final float[] rp = new float[8];
    final RendererContext rdrCtx;
    final Curve curve;
    private float[] clipRect;
    private int cOutCode = 0;
    private int sOutCode = 0;
    private boolean opened = false;
    private boolean capStart = false;
    private boolean monotonize;
    private boolean subdivide = DO_CLIP_SUBDIVIDER;
    private final TransformingPathConsumer2D.CurveClipSplitter curveSplitter;

    Stroker(RendererContext rdrCtx) {
        this.rdrCtx = rdrCtx;
        this.reverse = rdrCtx.stats != null ? new Helpers.PolyStack(rdrCtx, rdrCtx.stats.stat_str_polystack_types, rdrCtx.stats.stat_str_polystack_curves, rdrCtx.stats.hist_str_polystack_curves, rdrCtx.stats.stat_array_str_polystack_curves, rdrCtx.stats.stat_array_str_polystack_types) : new Helpers.PolyStack(rdrCtx);
        this.curve = rdrCtx.curve;
        this.curveSplitter = rdrCtx.curveClipSplitter;
    }

    public Stroker init(PathConsumer2D pc2d, float lineWidth, int capStyle, int joinStyle, float miterLimit, boolean subdivideCurves) {
        this.out = pc2d;
        this.lineWidth2 = lineWidth / 2.0f;
        this.invHalfLineWidth2Sq = 1.0f / (2.0f * this.lineWidth2 * this.lineWidth2);
        this.monotonize = subdivideCurves;
        this.capStyle = capStyle;
        this.joinStyle = joinStyle;
        float limit = miterLimit * this.lineWidth2;
        this.miterLimitSq = limit * limit;
        this.prev = 2;
        this.rdrCtx.stroking = 1;
        if (this.rdrCtx.doClip) {
            float margin = this.lineWidth2;
            if (capStyle == 2) {
                margin *= SQRT_2;
            }
            if (joinStyle == 0 && margin < limit) {
                margin = limit;
            }
            float[] _clipRect = this.rdrCtx.clipRect;
            _clipRect[0] = _clipRect[0] - margin;
            _clipRect[1] = _clipRect[1] + margin;
            _clipRect[2] = _clipRect[2] - margin;
            _clipRect[3] = _clipRect[3] + margin;
            this.clipRect = _clipRect;
            if (MarlinConst.DO_LOG_CLIP) {
                MarlinUtils.logInfo("clipRect (stroker): " + Arrays.toString(this.rdrCtx.clipRect));
            }
            if (DO_CLIP_SUBDIVIDER) {
                this.subdivide = subdivideCurves;
                this.curveSplitter.init();
            } else {
                this.subdivide = false;
            }
        } else {
            this.clipRect = null;
            this.cOutCode = 0;
            this.sOutCode = 0;
        }
        return this;
    }

    public void disableClipping() {
        this.clipRect = null;
        this.cOutCode = 0;
        this.sOutCode = 0;
    }

    void dispose() {
        this.reverse.dispose();
        this.opened = false;
        this.capStart = false;
    }

    private static void computeOffset(float lx, float ly, float w, float[] m) {
        float len = lx * lx + ly * ly;
        if (len == 0.0f) {
            m[0] = 0.0f;
            m[1] = 0.0f;
        } else {
            len = (float)Math.sqrt(len);
            m[0] = ly * w / len;
            m[1] = -(lx * w) / len;
        }
    }

    private static boolean isCW(float dx1, float dy1, float dx2, float dy2) {
        return dx1 * dy2 <= dy1 * dx2;
    }

    private void mayDrawRoundJoin(float cx, float cy, float omx, float omy, float mx, float my, boolean rev) {
        if (omx == 0.0f && omy == 0.0f || mx == 0.0f && my == 0.0f) {
            return;
        }
        float domx = omx - mx;
        float domy = omy - my;
        float lenSq = domx * domx + domy * domy;
        if (lenSq < ROUND_JOIN_THRESHOLD) {
            return;
        }
        if (rev) {
            omx = -omx;
            omy = -omy;
            mx = -mx;
            my = -my;
        }
        this.drawRoundJoin(cx, cy, omx, omy, mx, my, rev);
    }

    private void drawRoundJoin(float cx, float cy, float omx, float omy, float mx, float my, boolean rev) {
        float cosext = omx * mx + omy * my;
        if (cosext >= 0.0f) {
            this.drawBezApproxForArc(cx, cy, omx, omy, mx, my, rev);
        } else {
            float nx = my - omy;
            float ny = omx - mx;
            float nlen = (float)Math.sqrt(nx * nx + ny * ny);
            float scale = this.lineWidth2 / nlen;
            float mmx = nx * scale;
            float mmy = ny * scale;
            if (rev) {
                mmx = -mmx;
                mmy = -mmy;
            }
            this.drawBezApproxForArc(cx, cy, omx, omy, mmx, mmy, rev);
            this.drawBezApproxForArc(cx, cy, mmx, mmy, mx, my, rev);
        }
    }

    private void drawBezApproxForArc(float cx, float cy, float omx, float omy, float mx, float my, boolean rev) {
        float cosext2 = (omx * mx + omy * my) * this.invHalfLineWidth2Sq;
        if (cosext2 >= 0.5f) {
            return;
        }
        float cv = (float)(1.3333333333333333 * Math.sqrt(0.5 - (double)cosext2) / (1.0 + Math.sqrt((double)cosext2 + 0.5)));
        if (rev) {
            cv = -cv;
        }
        float x1 = cx + omx;
        float y1 = cy + omy;
        float x2 = x1 - cv * omy;
        float y2 = y1 + cv * omx;
        float x4 = cx + mx;
        float y4 = cy + my;
        float x3 = x4 + cv * my;
        float y3 = y4 - cv * mx;
        this.emitCurveTo(x1, y1, x2, y2, x3, y3, x4, y4, rev);
    }

    private void drawRoundCap(float cx, float cy, float mx, float my) {
        float Cmx = C * mx;
        float Cmy = C * my;
        this.emitCurveTo(cx + mx - Cmy, cy + my + Cmx, cx - my + Cmx, cy + mx + Cmy, cx - my, cy + mx);
        this.emitCurveTo(cx - my - Cmx, cy + mx - Cmy, cx - mx - Cmy, cy - my + Cmx, cx - mx, cy - my);
    }

    private static void computeMiter(float x0, float y0, float x1, float y1, float x0p, float y0p, float x1p, float y1p, float[] m) {
        float x10 = x1 - x0;
        float y10 = y1 - y0;
        float x10p = x1p - x0p;
        float y10p = y1p - y0p;
        float den = x10 * y10p - x10p * y10;
        float t = x10p * (y0 - y0p) - y10p * (x0 - x0p);
        m[0] = x0 + (t /= den) * x10;
        m[1] = y0 + t * y10;
    }

    private static void safeComputeMiter(float x0, float y0, float x1, float y1, float x0p, float y0p, float x1p, float y1p, float[] m) {
        float x10 = x1 - x0;
        float y10p = y1p - y0p;
        float x10p = x1p - x0p;
        float y10 = y1 - y0;
        float den = x10 * y10p - x10p * y10;
        if (den == 0.0f) {
            m[2] = (x0 + x0p) / 2.0f;
            m[3] = (y0 + y0p) / 2.0f;
        } else {
            float t = x10p * (y0 - y0p) - y10p * (x0 - x0p);
            m[2] = x0 + (t /= den) * x10;
            m[3] = y0 + t * y10;
        }
    }

    private void drawMiter(float pdx, float pdy, float x0, float y0, float dx, float dy, float omx, float omy, float mx, float my, boolean rev) {
        if (mx == omx && my == omy || pdx == 0.0f && pdy == 0.0f || dx == 0.0f && dy == 0.0f) {
            return;
        }
        if (rev) {
            omx = -omx;
            omy = -omy;
            mx = -mx;
            my = -my;
        }
        Stroker.computeMiter(x0 - pdx + omx, y0 - pdy + omy, x0 + omx, y0 + omy, dx + x0 + mx, dy + y0 + my, x0 + mx, y0 + my, this.miter);
        float miterX = this.miter[0];
        float miterY = this.miter[1];
        float lenSq = (miterX - x0) * (miterX - x0) + (miterY - y0) * (miterY - y0);
        if (lenSq < this.miterLimitSq) {
            this.emitLineTo(miterX, miterY, rev);
        }
    }

    @Override
    public void moveTo(float x0, float y0) {
        this._moveTo(x0, y0, this.cOutCode);
        this.sx0 = x0;
        this.sy0 = y0;
        this.sdx = 1.0f;
        this.sdy = 0.0f;
        this.opened = false;
        this.capStart = false;
        if (this.clipRect != null) {
            int outcode;
            this.cOutCode = outcode = Helpers.outcode(x0, y0, this.clipRect);
            this.sOutCode = outcode;
        }
    }

    private void _moveTo(float x0, float y0, int outcode) {
        if (this.prev == 0) {
            this.cx0 = x0;
            this.cy0 = y0;
        } else {
            if (this.prev == 1) {
                this.finish(outcode);
            }
            this.prev = 0;
            this.cx0 = x0;
            this.cy0 = y0;
            this.cdx = 1.0f;
            this.cdy = 0.0f;
        }
    }

    @Override
    public void lineTo(float x1, float y1) {
        this.lineTo(x1, y1, false);
    }

    private void lineTo(float x1, float y1, boolean force) {
        int outcode0 = this.cOutCode;
        if (!force && this.clipRect != null) {
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1;
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.curveSplitter.splitLine(this.cx0, this.cy0, x1, y1, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode1;
                    this._moveTo(x1, y1, outcode0);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = outcode1;
        }
        float dx = x1 - this.cx0;
        float dy = y1 - this.cy0;
        if (dx == 0.0f && dy == 0.0f) {
            dx = 1.0f;
        }
        Stroker.computeOffset(dx, dy, this.lineWidth2, this.offset0);
        float mx = this.offset0[0];
        float my = this.offset0[1];
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, dx, dy, this.cmx, this.cmy, mx, my, outcode0);
        this.emitLineTo(this.cx0 + mx, this.cy0 + my);
        this.emitLineTo(x1 + mx, y1 + my);
        this.emitLineToRev(this.cx0 - mx, this.cy0 - my);
        this.emitLineToRev(x1 - mx, y1 - my);
        this.prev = 1;
        this.cx0 = x1;
        this.cy0 = y1;
        this.cdx = dx;
        this.cdy = dy;
        this.cmx = mx;
        this.cmy = my;
    }

    @Override
    public void closePath() {
        if (this.prev != 1 && !this.opened) {
            if (this.prev == 2) {
                return;
            }
            this.emitMoveTo(this.cx0, this.cy0 - this.lineWidth2);
            this.sdx = 1.0f;
            this.sdy = 0.0f;
            this.cdx = 1.0f;
            this.cdy = 0.0f;
            this.smx = 0.0f;
            this.smy = -this.lineWidth2;
            this.cmx = 0.0f;
            this.cmy = -this.lineWidth2;
            this.finish(this.cOutCode);
            return;
        }
        if ((this.sOutCode & this.cOutCode) == 0) {
            if (this.cx0 != this.sx0 || this.cy0 != this.sy0) {
                this.lineTo(this.sx0, this.sy0, true);
            }
            this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, this.sdx, this.sdy, this.cmx, this.cmy, this.smx, this.smy, this.sOutCode);
            this.emitLineTo(this.sx0 + this.smx, this.sy0 + this.smy);
            if (this.opened) {
                this.emitLineTo(this.sx0 - this.smx, this.sy0 - this.smy);
            } else {
                this.emitMoveTo(this.sx0 - this.smx, this.sy0 - this.smy);
            }
        }
        this.emitReverse();
        this.prev = 2;
        this.cx0 = this.sx0;
        this.cy0 = this.sy0;
        this.cOutCode = this.sOutCode;
        if (this.opened) {
            this.opened = false;
        } else {
            this.emitClose();
        }
    }

    private void emitReverse() {
        this.reverse.popAll(this.out);
    }

    @Override
    public void pathDone() {
        if (this.prev == 1) {
            this.finish(this.cOutCode);
        }
        this.out.pathDone();
        this.prev = 2;
        this.dispose();
    }

    private void finish(int outcode) {
        if (this.rdrCtx.closedPath) {
            this.emitReverse();
        } else {
            if (outcode == 0) {
                if (this.capStyle == 1) {
                    this.drawRoundCap(this.cx0, this.cy0, this.cmx, this.cmy);
                } else if (this.capStyle == 2) {
                    this.emitLineTo(this.cx0 - this.cmy + this.cmx, this.cy0 + this.cmx + this.cmy);
                    this.emitLineTo(this.cx0 - this.cmy - this.cmx, this.cy0 + this.cmx - this.cmy);
                }
            }
            this.emitReverse();
            if (!this.capStart) {
                this.capStart = true;
                if (this.sOutCode == 0) {
                    if (this.capStyle == 1) {
                        this.drawRoundCap(this.sx0, this.sy0, -this.smx, -this.smy);
                    } else if (this.capStyle == 2) {
                        this.emitLineTo(this.sx0 + this.smy - this.smx, this.sy0 - this.smx - this.smy);
                        this.emitLineTo(this.sx0 + this.smy + this.smx, this.sy0 - this.smx + this.smy);
                    }
                }
            }
        }
        this.emitClose();
    }

    private void emitMoveTo(float x0, float y0) {
        this.out.moveTo(x0, y0);
    }

    private void emitLineTo(float x1, float y1) {
        this.out.lineTo(x1, y1);
    }

    private void emitLineToRev(float x1, float y1) {
        this.reverse.pushLine(x1, y1);
    }

    private void emitLineTo(float x1, float y1, boolean rev) {
        if (rev) {
            this.emitLineToRev(x1, y1);
        } else {
            this.emitLineTo(x1, y1);
        }
    }

    private void emitQuadTo(float x1, float y1, float x2, float y2) {
        this.out.quadTo(x1, y1, x2, y2);
    }

    private void emitQuadToRev(float x0, float y0, float x1, float y1) {
        this.reverse.pushQuad(x0, y0, x1, y1);
    }

    private void emitCurveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.out.curveTo(x1, y1, x2, y2, x3, y3);
    }

    private void emitCurveToRev(float x0, float y0, float x1, float y1, float x2, float y2) {
        this.reverse.pushCubic(x0, y0, x1, y1, x2, y2);
    }

    private void emitCurveTo(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, boolean rev) {
        if (rev) {
            this.reverse.pushCubic(x0, y0, x1, y1, x2, y2);
        } else {
            this.out.curveTo(x1, y1, x2, y2, x3, y3);
        }
    }

    private void emitClose() {
        this.out.closePath();
    }

    private void drawJoin(float pdx, float pdy, float x0, float y0, float dx, float dy, float omx, float omy, float mx, float my, int outcode) {
        if (this.prev != 1) {
            this.emitMoveTo(x0 + mx, y0 + my);
            if (!this.opened) {
                this.sdx = dx;
                this.sdy = dy;
                this.smx = mx;
                this.smy = my;
            }
        } else {
            boolean cw = Stroker.isCW(pdx, pdy, dx, dy);
            if (outcode == 0) {
                if (this.joinStyle == 0) {
                    this.drawMiter(pdx, pdy, x0, y0, dx, dy, omx, omy, mx, my, cw);
                } else if (this.joinStyle == 1) {
                    this.mayDrawRoundJoin(x0, y0, omx, omy, mx, my, cw);
                }
            }
            this.emitLineTo(x0, y0, !cw);
        }
        this.prev = 1;
    }

    private static boolean within(float x1, float y1, float x2, float y2, float err) {
        assert (err > 0.0f) : "";
        return Helpers.within(x1, x2, err) && Helpers.within(y1, y2, err);
    }

    private void getLineOffsets(float x1, float y1, float x2, float y2, float[] left, float[] right) {
        Stroker.computeOffset(x2 - x1, y2 - y1, this.lineWidth2, this.offset0);
        float mx = this.offset0[0];
        float my = this.offset0[1];
        left[0] = x1 + mx;
        left[1] = y1 + my;
        left[2] = x2 + mx;
        left[3] = y2 + my;
        right[0] = x1 - mx;
        right[1] = y1 - my;
        right[2] = x2 - mx;
        right[3] = y2 - my;
    }

    private int computeOffsetCubic(float[] pts, int off, float[] leftOff, float[] rightOff) {
        float x1 = pts[off];
        float y1 = pts[off + 1];
        float x2 = pts[off + 2];
        float y2 = pts[off + 3];
        float x3 = pts[off + 4];
        float y3 = pts[off + 5];
        float x4 = pts[off + 6];
        float y4 = pts[off + 7];
        float dx4 = x4 - x3;
        float dy4 = y4 - y3;
        float dx1 = x2 - x1;
        float dy1 = y2 - y1;
        boolean p1eqp2 = Stroker.within(x1, y1, x2, y2, 6.0f * Math.ulp(y2));
        boolean p3eqp4 = Stroker.within(x3, y3, x4, y4, 6.0f * Math.ulp(y4));
        if (p1eqp2 && p3eqp4) {
            this.getLineOffsets(x1, y1, x4, y4, leftOff, rightOff);
            return 4;
        }
        if (p1eqp2) {
            dx1 = x3 - x1;
            dy1 = y3 - y1;
        } else if (p3eqp4) {
            dx4 = x4 - x2;
            dy4 = y4 - y2;
        }
        float dotsq = dx1 * dx4 + dy1 * dy4;
        dotsq *= dotsq;
        float l1sq = dx1 * dx1 + dy1 * dy1;
        float l4sq = dx4 * dx4 + dy4 * dy4;
        if (Helpers.within(dotsq, l1sq * l4sq, 4.0f * Math.ulp(dotsq))) {
            this.getLineOffsets(x1, y1, x4, y4, leftOff, rightOff);
            return 4;
        }
        float x = (x1 + 3.0f * (x2 + x3) + x4) / 8.0f;
        float y = (y1 + 3.0f * (y2 + y3) + y4) / 8.0f;
        float dxm = x3 + x4 - x1 - x2;
        float dym = y3 + y4 - y1 - y2;
        Stroker.computeOffset(dx1, dy1, this.lineWidth2, this.offset0);
        Stroker.computeOffset(dxm, dym, this.lineWidth2, this.offset1);
        Stroker.computeOffset(dx4, dy4, this.lineWidth2, this.offset2);
        float x1p = x1 + this.offset0[0];
        float y1p = y1 + this.offset0[1];
        float xi = x + this.offset1[0];
        float yi = y + this.offset1[1];
        float x4p = x4 + this.offset2[0];
        float y4p = y4 + this.offset2[1];
        float invdet43 = 4.0f / (3.0f * (dx1 * dy4 - dy1 * dx4));
        float two_pi_m_p1_m_p4x = 2.0f * xi - x1p - x4p;
        float two_pi_m_p1_m_p4y = 2.0f * yi - y1p - y4p;
        float c1 = invdet43 * (dy4 * two_pi_m_p1_m_p4x - dx4 * two_pi_m_p1_m_p4y);
        float c2 = invdet43 * (dx1 * two_pi_m_p1_m_p4y - dy1 * two_pi_m_p1_m_p4x);
        float x2p = x1p + c1 * dx1;
        float y2p = y1p + c1 * dy1;
        float x3p = x4p + c2 * dx4;
        float y3p = y4p + c2 * dy4;
        leftOff[0] = x1p;
        leftOff[1] = y1p;
        leftOff[2] = x2p;
        leftOff[3] = y2p;
        leftOff[4] = x3p;
        leftOff[5] = y3p;
        leftOff[6] = x4p;
        leftOff[7] = y4p;
        x1p = x1 - this.offset0[0];
        y1p = y1 - this.offset0[1];
        x4p = x4 - this.offset2[0];
        y4p = y4 - this.offset2[1];
        two_pi_m_p1_m_p4x = 2.0f * (xi -= 2.0f * this.offset1[0]) - x1p - x4p;
        two_pi_m_p1_m_p4y = 2.0f * (yi -= 2.0f * this.offset1[1]) - y1p - y4p;
        c1 = invdet43 * (dy4 * two_pi_m_p1_m_p4x - dx4 * two_pi_m_p1_m_p4y);
        c2 = invdet43 * (dx1 * two_pi_m_p1_m_p4y - dy1 * two_pi_m_p1_m_p4x);
        x2p = x1p + c1 * dx1;
        y2p = y1p + c1 * dy1;
        x3p = x4p + c2 * dx4;
        y3p = y4p + c2 * dy4;
        rightOff[0] = x1p;
        rightOff[1] = y1p;
        rightOff[2] = x2p;
        rightOff[3] = y2p;
        rightOff[4] = x3p;
        rightOff[5] = y3p;
        rightOff[6] = x4p;
        rightOff[7] = y4p;
        return 8;
    }

    private int computeOffsetQuad(float[] pts, int off, float[] leftOff, float[] rightOff) {
        float x1 = pts[off];
        float y1 = pts[off + 1];
        float x2 = pts[off + 2];
        float y2 = pts[off + 3];
        float x3 = pts[off + 4];
        float y3 = pts[off + 5];
        float dx3 = x3 - x2;
        float dy3 = y3 - y2;
        float dx1 = x2 - x1;
        float dy1 = y2 - y1;
        boolean p1eqp2 = Stroker.within(x1, y1, x2, y2, 6.0f * Math.ulp(y2));
        boolean p2eqp3 = Stroker.within(x2, y2, x3, y3, 6.0f * Math.ulp(y3));
        if (p1eqp2 || p2eqp3) {
            this.getLineOffsets(x1, y1, x3, y3, leftOff, rightOff);
            return 4;
        }
        float dotsq = dx1 * dx3 + dy1 * dy3;
        float l1sq = dx1 * dx1 + dy1 * dy1;
        float l3sq = dx3 * dx3 + dy3 * dy3;
        if (Helpers.within(dotsq *= dotsq, l1sq * l3sq, 4.0f * Math.ulp(dotsq))) {
            this.getLineOffsets(x1, y1, x3, y3, leftOff, rightOff);
            return 4;
        }
        Stroker.computeOffset(dx1, dy1, this.lineWidth2, this.offset0);
        Stroker.computeOffset(dx3, dy3, this.lineWidth2, this.offset1);
        float x1p = x1 + this.offset0[0];
        float y1p = y1 + this.offset0[1];
        float x3p = x3 + this.offset1[0];
        float y3p = y3 + this.offset1[1];
        Stroker.safeComputeMiter(x1p, y1p, x1p + dx1, y1p + dy1, x3p, y3p, x3p - dx3, y3p - dy3, leftOff);
        leftOff[0] = x1p;
        leftOff[1] = y1p;
        leftOff[4] = x3p;
        leftOff[5] = y3p;
        x1p = x1 - this.offset0[0];
        y1p = y1 - this.offset0[1];
        x3p = x3 - this.offset1[0];
        y3p = y3 - this.offset1[1];
        Stroker.safeComputeMiter(x1p, y1p, x1p + dx1, y1p + dy1, x3p, y3p, x3p - dx3, y3p - dy3, rightOff);
        rightOff[0] = x1p;
        rightOff[1] = y1p;
        rightOff[4] = x3p;
        rightOff[5] = y3p;
        return 6;
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        int outcode0 = this.cOutCode;
        if (this.clipRect != null) {
            int outcode3;
            int outcode2;
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1 | (outcode2 = Helpers.outcode(x2, y2, this.clipRect)) | (outcode3 = Helpers.outcode(x3, y3, this.clipRect));
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1 & outcode2 & outcode3;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.curveSplitter.splitCurve(this.cx0, this.cy0, x1, y1, x2, y2, x3, y3, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode3;
                    this._moveTo(x3, y3, outcode0);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = outcode3;
        }
        this._curveTo(x1, y1, x2, y2, x3, y3, outcode0);
    }

    private void _curveTo(float x1, float y1, float x2, float y2, float x3, float y3, int outcode0) {
        float[] mid;
        float len;
        float dxs = x1 - this.cx0;
        float dys = y1 - this.cy0;
        float dxf = x3 - x2;
        float dyf = y3 - y2;
        if (dxs == 0.0f && dys == 0.0f) {
            dxs = x2 - this.cx0;
            dys = y2 - this.cy0;
            if (dxs == 0.0f && dys == 0.0f) {
                dxs = x3 - this.cx0;
                dys = y3 - this.cy0;
            }
        }
        if (dxf == 0.0f && dyf == 0.0f) {
            dxf = x3 - x1;
            dyf = y3 - y1;
            if (dxf == 0.0f && dyf == 0.0f) {
                dxf = x3 - this.cx0;
                dyf = y3 - this.cy0;
            }
        }
        if (dxs == 0.0f && dys == 0.0f) {
            if (this.clipRect != null) {
                this.cOutCode = outcode0;
            }
            this.lineTo(this.cx0, this.cy0);
            return;
        }
        if (Math.abs(dxs) < 0.1f && Math.abs(dys) < 0.1f) {
            len = (float)Math.sqrt(dxs * dxs + dys * dys);
            dxs /= len;
            dys /= len;
        }
        if (Math.abs(dxf) < 0.1f && Math.abs(dyf) < 0.1f) {
            len = (float)Math.sqrt(dxf * dxf + dyf * dyf);
            dxf /= len;
            dyf /= len;
        }
        Stroker.computeOffset(dxs, dys, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, dxs, dys, this.cmx, this.cmy, this.offset0[0], this.offset0[1], outcode0);
        int nSplits = 0;
        float[] l = this.lp;
        if (this.monotonize) {
            TransformingPathConsumer2D.CurveBasicMonotonizer monotonizer = this.rdrCtx.monotonizer.curve(this.cx0, this.cy0, x1, y1, x2, y2, x3, y3);
            nSplits = monotonizer.nbSplits;
            mid = monotonizer.middle;
        } else {
            mid = l;
            mid[0] = this.cx0;
            mid[1] = this.cy0;
            mid[2] = x1;
            mid[3] = y1;
            mid[4] = x2;
            mid[5] = y2;
            mid[6] = x3;
            mid[7] = y3;
        }
        float[] r = this.rp;
        int kind = 0;
        int i = 0;
        int off = 0;
        while (i <= nSplits) {
            kind = this.computeOffsetCubic(mid, off, l, r);
            this.emitLineTo(l[0], l[1]);
            switch (kind) {
                case 8: {
                    this.emitCurveTo(l[2], l[3], l[4], l[5], l[6], l[7]);
                    this.emitCurveToRev(r[0], r[1], r[2], r[3], r[4], r[5]);
                    break;
                }
                case 4: {
                    this.emitLineTo(l[2], l[3]);
                    this.emitLineToRev(r[0], r[1]);
                    break;
                }
            }
            this.emitLineToRev(r[kind - 2], r[kind - 1]);
            ++i;
            off += 6;
        }
        this.prev = 1;
        this.cx0 = x3;
        this.cy0 = y3;
        this.cdx = dxf;
        this.cdy = dyf;
        this.cmx = (l[kind - 2] - r[kind - 2]) / 2.0f;
        this.cmy = (l[kind - 1] - r[kind - 1]) / 2.0f;
    }

    @Override
    public void quadTo(float x1, float y1, float x2, float y2) {
        int outcode0 = this.cOutCode;
        if (this.clipRect != null) {
            int outcode2;
            int outcode1 = Helpers.outcode(x1, y1, this.clipRect);
            int orCode = outcode0 | outcode1 | (outcode2 = Helpers.outcode(x2, y2, this.clipRect));
            if (orCode != 0) {
                int sideCode = outcode0 & outcode1 & outcode2;
                if (sideCode == 0) {
                    if (this.subdivide) {
                        this.subdivide = false;
                        boolean ret = this.curveSplitter.splitQuad(this.cx0, this.cy0, x1, y1, x2, y2, orCode, this);
                        this.subdivide = true;
                        if (ret) {
                            return;
                        }
                    }
                } else {
                    this.cOutCode = outcode2;
                    this._moveTo(x2, y2, outcode0);
                    this.opened = true;
                    return;
                }
            }
            this.cOutCode = outcode2;
        }
        this._quadTo(x1, y1, x2, y2, outcode0);
    }

    private void _quadTo(float x1, float y1, float x2, float y2, int outcode0) {
        float[] mid;
        float len;
        float dxs = x1 - this.cx0;
        float dys = y1 - this.cy0;
        float dxf = x2 - x1;
        float dyf = y2 - y1;
        if (dxs == 0.0f && dys == 0.0f || dxf == 0.0f && dyf == 0.0f) {
            dxs = dxf = x2 - this.cx0;
            dys = dyf = y2 - this.cy0;
        }
        if (dxs == 0.0f && dys == 0.0f) {
            if (this.clipRect != null) {
                this.cOutCode = outcode0;
            }
            this.lineTo(this.cx0, this.cy0);
            return;
        }
        if (Math.abs(dxs) < 0.1f && Math.abs(dys) < 0.1f) {
            len = (float)Math.sqrt(dxs * dxs + dys * dys);
            dxs /= len;
            dys /= len;
        }
        if (Math.abs(dxf) < 0.1f && Math.abs(dyf) < 0.1f) {
            len = (float)Math.sqrt(dxf * dxf + dyf * dyf);
            dxf /= len;
            dyf /= len;
        }
        Stroker.computeOffset(dxs, dys, this.lineWidth2, this.offset0);
        this.drawJoin(this.cdx, this.cdy, this.cx0, this.cy0, dxs, dys, this.cmx, this.cmy, this.offset0[0], this.offset0[1], outcode0);
        int nSplits = 0;
        float[] l = this.lp;
        if (this.monotonize) {
            TransformingPathConsumer2D.CurveBasicMonotonizer monotonizer = this.rdrCtx.monotonizer.quad(this.cx0, this.cy0, x1, y1, x2, y2);
            nSplits = monotonizer.nbSplits;
            mid = monotonizer.middle;
        } else {
            mid = l;
            mid[0] = this.cx0;
            mid[1] = this.cy0;
            mid[2] = x1;
            mid[3] = y1;
            mid[4] = x2;
            mid[5] = y2;
        }
        float[] r = this.rp;
        int kind = 0;
        int i = 0;
        int off = 0;
        while (i <= nSplits) {
            kind = this.computeOffsetQuad(mid, off, l, r);
            this.emitLineTo(l[0], l[1]);
            switch (kind) {
                case 6: {
                    this.emitQuadTo(l[2], l[3], l[4], l[5]);
                    this.emitQuadToRev(r[0], r[1], r[2], r[3]);
                    break;
                }
                case 4: {
                    this.emitLineTo(l[2], l[3]);
                    this.emitLineToRev(r[0], r[1]);
                    break;
                }
            }
            this.emitLineToRev(r[kind - 2], r[kind - 1]);
            ++i;
            off += 4;
        }
        this.prev = 1;
        this.cx0 = x2;
        this.cy0 = y2;
        this.cdx = dxf;
        this.cdy = dyf;
        this.cmx = (l[kind - 2] - r[kind - 2]) / 2.0f;
        this.cmy = (l[kind - 1] - r[kind - 1]) / 2.0f;
    }
}

