/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathConsumer2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.marlin.MarlinConst;
import com.sun.marlin.MarlinProperties;
import com.sun.marlin.MarlinRenderer;
import com.sun.marlin.MarlinUtils;
import com.sun.marlin.RendererContext;
import com.sun.marlin.TransformingPathConsumer2D;
import com.sun.prism.BasicStroke;
import java.util.Arrays;

public final class MarlinPrismUtils {
    private static final boolean FORCE_NO_AA = false;
    static final boolean DISABLE_2ND_STROKER_CLIPPING = true;
    static final boolean DO_TRACE_PATH = false;
    static final boolean DO_CLIP = MarlinProperties.isDoClip();
    static final boolean DO_CLIP_FILL = true;
    static final boolean DO_CLIP_RUNTIME_ENABLE = MarlinProperties.isDoClipRuntimeFlag();
    static final float UPPER_BND = 1.7014117E38f;
    static final float LOWER_BND = -1.7014117E38f;

    private MarlinPrismUtils() {
    }

    private static PathConsumer2D initStroker(RendererContext rdrCtx, BasicStroke stroke, float lineWidth, BaseTransform tx, PathConsumer2D out) {
        BaseTransform strokerTx = null;
        int dashLen = -1;
        boolean recycleDashes = false;
        float width = lineWidth;
        float[] dashes = stroke.getDashArray();
        float dashphase = stroke.getDashPhase();
        if (tx != null && !tx.isIdentity()) {
            double d;
            double c;
            double b;
            double a = tx.getMxx();
            if (MarlinPrismUtils.nearZero(a * (b = tx.getMxy()) + (c = tx.getMyx()) * (d = tx.getMyy())) && MarlinPrismUtils.nearZero(a * a + c * c - (b * b + d * d))) {
                float scale = (float)Math.sqrt(a * a + c * c);
                if (dashes != null) {
                    recycleDashes = true;
                    dashLen = dashes.length;
                    dashes = rdrCtx.dasher.copyDashArray(dashes);
                    int i = 0;
                    while (i < dashLen) {
                        int n = i++;
                        dashes[n] = dashes[n] * scale;
                    }
                    dashphase *= scale;
                }
                width *= scale;
            } else {
                strokerTx = tx;
            }
        } else {
            tx = null;
        }
        PathConsumer2D pc = out;
        TransformingPathConsumer2D transformerPC2D = rdrCtx.transformerPC2D;
        if (MarlinConst.USE_SIMPLIFIER) {
            pc = rdrCtx.simplifier.init(pc);
        }
        pc = transformerPC2D.deltaTransformConsumer(pc, strokerTx);
        pc = rdrCtx.stroker.init(pc, width, stroke.getEndCap(), stroke.getLineJoin(), stroke.getMiterLimit(), dashes == null);
        rdrCtx.monotonizer.init(width);
        if (dashes != null) {
            if (!recycleDashes) {
                dashLen = dashes.length;
            }
            pc = rdrCtx.dasher.init(pc, dashes, dashLen, dashphase, recycleDashes);
            rdrCtx.stroker.disableClipping();
        } else if (rdrCtx.doClip && stroke.getEndCap() != 0) {
            pc = transformerPC2D.detectClosedPath(pc);
        }
        pc = transformerPC2D.inverseDeltaTransformConsumer(pc, strokerTx);
        return pc;
    }

    private static boolean nearZero(double num) {
        return Math.abs(num) < 2.0 * Math.ulp(num);
    }

    private static PathConsumer2D initRenderer(RendererContext rdrCtx, BasicStroke stroke, BaseTransform tx, Rectangle clip, int piRule, MarlinRenderer renderer) {
        if (DO_CLIP || DO_CLIP_RUNTIME_ENABLE && MarlinProperties.isDoClipAtRuntime()) {
            float[] clipRect = rdrCtx.clipRect;
            float rdrOffX = renderer.getOffsetX();
            float rdrOffY = renderer.getOffsetY();
            float margin = 0.001f;
            clipRect[0] = (float)clip.y - 0.001f + rdrOffY;
            clipRect[1] = (float)(clip.y + clip.height) + 0.001f + rdrOffY;
            clipRect[2] = (float)clip.x - 0.001f + rdrOffX;
            clipRect[3] = (float)(clip.x + clip.width) + 0.001f + rdrOffX;
            if (MarlinConst.DO_LOG_CLIP) {
                MarlinUtils.logInfo("clipRect (clip): " + Arrays.toString(rdrCtx.clipRect));
            }
            rdrCtx.doClip = true;
        }
        if (stroke != null) {
            renderer.init(clip.x, clip.y, clip.width, clip.height, 1);
            return MarlinPrismUtils.initStroker(rdrCtx, stroke, stroke.getLineWidth(), tx, renderer);
        }
        int oprule = piRule == 0 ? 0 : 1;
        renderer.init(clip.x, clip.y, clip.width, clip.height, oprule);
        PathConsumer2D pc = renderer;
        TransformingPathConsumer2D transformerPC2D = rdrCtx.transformerPC2D;
        if (rdrCtx.doClip) {
            pc = rdrCtx.transformerPC2D.pathClipper(pc);
        }
        return pc;
    }

    public static MarlinRenderer setupRenderer(RendererContext rdrCtx, Shape shape, BasicStroke stroke, BaseTransform xform, Rectangle rclip, boolean antialiasedShape) {
        MarlinRenderer r;
        BaseTransform tf = xform != null && !xform.isIdentity() ? xform : null;
        MarlinRenderer marlinRenderer = r = antialiasedShape ? rdrCtx.renderer : rdrCtx.getRendererNoAA();
        if (shape instanceof Path2D) {
            Path2D p2d = (Path2D)shape;
            PathConsumer2D pc2d = MarlinPrismUtils.initRenderer(rdrCtx, stroke, tf, rclip, p2d.getWindingRule(), r);
            MarlinPrismUtils.feedConsumer(rdrCtx, p2d, tf, pc2d);
        } else {
            PathIterator pi = shape.getPathIterator(tf);
            PathConsumer2D pc2d = MarlinPrismUtils.initRenderer(rdrCtx, stroke, tf, rclip, pi.getWindingRule(), r);
            MarlinPrismUtils.feedConsumer(rdrCtx, pi, pc2d);
        }
        return r;
    }

    public static void strokeTo(RendererContext rdrCtx, Shape shape, BasicStroke stroke, float lineWidth, PathConsumer2D out) {
        PathConsumer2D pc2d = MarlinPrismUtils.initStroker(rdrCtx, stroke, lineWidth, null, out);
        if (shape instanceof Path2D) {
            MarlinPrismUtils.feedConsumer(rdrCtx, (Path2D)shape, null, pc2d);
        } else {
            MarlinPrismUtils.feedConsumer(rdrCtx, shape.getPathIterator(null), pc2d);
        }
    }

    private static void feedConsumer(RendererContext rdrCtx, PathIterator pi, PathConsumer2D pc2d) {
        if (MarlinConst.USE_PATH_SIMPLIFIER) {
            pc2d = rdrCtx.pathSimplifier.init(pc2d);
        }
        rdrCtx.dirty = true;
        float[] coords = rdrCtx.float6;
        boolean subpathStarted = false;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (!(coords[0] < 1.7014117E38f) || !(coords[0] > -1.7014117E38f) || !(coords[1] < 1.7014117E38f) || !(coords[1] > -1.7014117E38f)) break;
                    pc2d.moveTo(coords[0], coords[1]);
                    subpathStarted = true;
                    break;
                }
                case 1: {
                    if (!(coords[0] < 1.7014117E38f) || !(coords[0] > -1.7014117E38f) || !(coords[1] < 1.7014117E38f) || !(coords[1] > -1.7014117E38f)) break;
                    if (subpathStarted) {
                        pc2d.lineTo(coords[0], coords[1]);
                        break;
                    }
                    pc2d.moveTo(coords[0], coords[1]);
                    subpathStarted = true;
                    break;
                }
                case 2: {
                    if (!(coords[2] < 1.7014117E38f) || !(coords[2] > -1.7014117E38f) || !(coords[3] < 1.7014117E38f) || !(coords[3] > -1.7014117E38f)) break;
                    if (subpathStarted) {
                        if (coords[0] < 1.7014117E38f && coords[0] > -1.7014117E38f && coords[1] < 1.7014117E38f && coords[1] > -1.7014117E38f) {
                            pc2d.quadTo(coords[0], coords[1], coords[2], coords[3]);
                            break;
                        }
                        pc2d.lineTo(coords[2], coords[3]);
                        break;
                    }
                    pc2d.moveTo(coords[2], coords[3]);
                    subpathStarted = true;
                    break;
                }
                case 3: {
                    if (!(coords[4] < 1.7014117E38f) || !(coords[4] > -1.7014117E38f) || !(coords[5] < 1.7014117E38f) || !(coords[5] > -1.7014117E38f)) break;
                    if (subpathStarted) {
                        if (coords[0] < 1.7014117E38f && coords[0] > -1.7014117E38f && coords[1] < 1.7014117E38f && coords[1] > -1.7014117E38f && coords[2] < 1.7014117E38f && coords[2] > -1.7014117E38f && coords[3] < 1.7014117E38f && coords[3] > -1.7014117E38f) {
                            pc2d.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                            break;
                        }
                        pc2d.lineTo(coords[4], coords[5]);
                        break;
                    }
                    pc2d.moveTo(coords[4], coords[5]);
                    subpathStarted = true;
                    break;
                }
                case 4: {
                    if (!subpathStarted) break;
                    pc2d.closePath();
                    break;
                }
            }
            pi.next();
        }
        pc2d.pathDone();
        rdrCtx.dirty = false;
    }

    private static void feedConsumer(RendererContext rdrCtx, Path2D p2d, BaseTransform xform, PathConsumer2D pc2d) {
        if (MarlinConst.USE_PATH_SIMPLIFIER) {
            pc2d = rdrCtx.pathSimplifier.init(pc2d);
        }
        rdrCtx.dirty = true;
        float[] coords = rdrCtx.float6;
        boolean subpathStarted = false;
        float[] pCoords = p2d.getFloatCoordsNoClone();
        byte[] pTypes = p2d.getCommandsNoClone();
        int nsegs = p2d.getNumCommands();
        int coff = 0;
        block7: for (int i = 0; i < nsegs; ++i) {
            switch (pTypes[i]) {
                case 0: {
                    if (xform == null) {
                        coords[0] = pCoords[coff];
                        coords[1] = pCoords[coff + 1];
                    } else {
                        xform.transform(pCoords, coff, coords, 0, 1);
                    }
                    coff += 2;
                    if (!(coords[0] < 1.7014117E38f) || !(coords[0] > -1.7014117E38f) || !(coords[1] < 1.7014117E38f) || !(coords[1] > -1.7014117E38f)) continue block7;
                    pc2d.moveTo(coords[0], coords[1]);
                    subpathStarted = true;
                    continue block7;
                }
                case 1: {
                    if (xform == null) {
                        coords[0] = pCoords[coff];
                        coords[1] = pCoords[coff + 1];
                    } else {
                        xform.transform(pCoords, coff, coords, 0, 1);
                    }
                    coff += 2;
                    if (!(coords[0] < 1.7014117E38f) || !(coords[0] > -1.7014117E38f) || !(coords[1] < 1.7014117E38f) || !(coords[1] > -1.7014117E38f)) continue block7;
                    if (subpathStarted) {
                        pc2d.lineTo(coords[0], coords[1]);
                        continue block7;
                    }
                    pc2d.moveTo(coords[0], coords[1]);
                    subpathStarted = true;
                    continue block7;
                }
                case 2: {
                    if (xform == null) {
                        coords[0] = pCoords[coff];
                        coords[1] = pCoords[coff + 1];
                        coords[2] = pCoords[coff + 2];
                        coords[3] = pCoords[coff + 3];
                    } else {
                        xform.transform(pCoords, coff, coords, 0, 2);
                    }
                    coff += 4;
                    if (!(coords[2] < 1.7014117E38f) || !(coords[2] > -1.7014117E38f) || !(coords[3] < 1.7014117E38f) || !(coords[3] > -1.7014117E38f)) continue block7;
                    if (subpathStarted) {
                        if (coords[0] < 1.7014117E38f && coords[0] > -1.7014117E38f && coords[1] < 1.7014117E38f && coords[1] > -1.7014117E38f) {
                            pc2d.quadTo(coords[0], coords[1], coords[2], coords[3]);
                            continue block7;
                        }
                        pc2d.lineTo(coords[2], coords[3]);
                        continue block7;
                    }
                    pc2d.moveTo(coords[2], coords[3]);
                    subpathStarted = true;
                    continue block7;
                }
                case 3: {
                    if (xform == null) {
                        coords[0] = pCoords[coff];
                        coords[1] = pCoords[coff + 1];
                        coords[2] = pCoords[coff + 2];
                        coords[3] = pCoords[coff + 3];
                        coords[4] = pCoords[coff + 4];
                        coords[5] = pCoords[coff + 5];
                    } else {
                        xform.transform(pCoords, coff, coords, 0, 3);
                    }
                    coff += 6;
                    if (!(coords[4] < 1.7014117E38f) || !(coords[4] > -1.7014117E38f) || !(coords[5] < 1.7014117E38f) || !(coords[5] > -1.7014117E38f)) continue block7;
                    if (subpathStarted) {
                        if (coords[0] < 1.7014117E38f && coords[0] > -1.7014117E38f && coords[1] < 1.7014117E38f && coords[1] > -1.7014117E38f && coords[2] < 1.7014117E38f && coords[2] > -1.7014117E38f && coords[3] < 1.7014117E38f && coords[3] > -1.7014117E38f) {
                            pc2d.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                            continue block7;
                        }
                        pc2d.lineTo(coords[4], coords[5]);
                        continue block7;
                    }
                    pc2d.moveTo(coords[4], coords[5]);
                    subpathStarted = true;
                    continue block7;
                }
                case 4: {
                    if (!subpathStarted) continue block7;
                    pc2d.closePath();
                    continue block7;
                }
            }
        }
        pc2d.pathDone();
        rdrCtx.dirty = false;
    }
}

