/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.javafx.PlatformUtil;
import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.PGFont;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class J2DFontFactory
implements FontFactory {
    FontFactory prismFontFactory;
    private static boolean compositeFontMethodsInitialized = false;
    private static Method getCompositeFontUIResource = null;

    J2DFontFactory(FontFactory fontFactory) {
        this.prismFontFactory = fontFactory;
    }

    @Override
    public PGFont createFont(String name, float size) {
        return this.prismFontFactory.createFont(name, size);
    }

    @Override
    public PGFont createFont(String family, boolean bold, boolean italic, float size) {
        return this.prismFontFactory.createFont(family, bold, italic, size);
    }

    @Override
    public synchronized PGFont deriveFont(PGFont font, boolean bold, boolean italic, float size) {
        return this.prismFontFactory.deriveFont(font, bold, italic, size);
    }

    @Override
    public String[] getFontFamilyNames() {
        return this.prismFontFactory.getFontFamilyNames();
    }

    @Override
    public String[] getFontFullNames() {
        return this.prismFontFactory.getFontFullNames();
    }

    @Override
    public String[] getFontFullNames(String family) {
        return this.prismFontFactory.getFontFullNames(family);
    }

    @Override
    public boolean isPlatformFont(String name) {
        return this.prismFontFactory.isPlatformFont(name);
    }

    @Override
    public final boolean hasPermission() {
        return this.prismFontFactory.hasPermission();
    }

    @Override
    public PGFont[] loadEmbeddedFont(String name, InputStream fontStream, float size, boolean register, boolean loadAll) {
        if (!this.hasPermission()) {
            PGFont[] fonts = new PGFont[]{this.createFont("System Regular", size)};
            return fonts;
        }
        PGFont[] fonts = this.prismFontFactory.loadEmbeddedFont(name, fontStream, size, register, loadAll);
        if (fonts == null || fonts.length == 0) {
            return null;
        }
        FontResource fr = fonts[0].getFontResource();
        J2DFontFactory.registerFont(fonts[0].getFontResource());
        return fonts;
    }

    public static void registerFont(FontResource fr) {
        AccessController.doPrivileged(() -> {
            InputStream stream = null;
            try {
                File file = new File(fr.getFileName());
                stream = new FileInputStream(file);
                Font font = Font.createFont(0, stream);
                fr.setPeer(font);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return null;
        });
    }

    @Override
    public PGFont[] loadEmbeddedFont(String name, String path, float size, boolean register, boolean loadAll) {
        if (!this.hasPermission()) {
            PGFont[] fonts = new PGFont[]{this.createFont("System Regular", size)};
            return fonts;
        }
        PGFont[] fonts = this.prismFontFactory.loadEmbeddedFont(name, path, size, register, loadAll);
        if (fonts == null || fonts.length == 0) {
            return null;
        }
        final FontResource fr = fonts[0].getFontResource();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    File file = new File(fr.getFileName());
                    Font font = Font.createFont(0, file);
                    fr.setPeer(font);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
        return fonts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font getCompositeFont(Font srcFont) {
        if (PlatformUtil.isMac()) {
            return srcFont;
        }
        Class<J2DFontFactory> clazz = J2DFontFactory.class;
        synchronized (J2DFontFactory.class) {
            if (!compositeFontMethodsInitialized) {
                AccessController.doPrivileged(() -> {
                    Class<?> fontMgrCls;
                    compositeFontMethodsInitialized = true;
                    try {
                        fontMgrCls = Class.forName("sun.font.FontUtilities", true, null);
                    }
                    catch (ClassNotFoundException cnfe) {
                        try {
                            fontMgrCls = Class.forName("sun.font.FontManager", true, null);
                        }
                        catch (ClassNotFoundException cnfe2) {
                            return null;
                        }
                    }
                    try {
                        getCompositeFontUIResource = fontMgrCls.getMethod("getCompositeFontUIResource", Font.class);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return null;
                });
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (getCompositeFontUIResource != null) {
                try {
                    return (Font)getCompositeFontUIResource.invoke(null, srcFont);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return srcFont;
        }
    }
}

