/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import javafx.animation.Animation;
import javafx.util.Duration;

public class FiniteClipEnvelope
extends ClipEnvelope {
    private boolean autoReverse;
    private int cycleCount;
    private long totalTicks;
    private long pos;

    protected FiniteClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.autoReverse = animation.isAutoReverse();
            this.cycleCount = animation.getCycleCount();
        }
        this.updateTotalTicks();
    }

    @Override
    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    @Override
    protected double calculateCurrentRate() {
        return !this.autoReverse ? this.rate : (this.ticks % (2L * this.cycleTicks) < this.cycleTicks == this.rate > 0.0 ? this.rate : -this.rate);
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration cycleDuration) {
        if (cycleDuration.isIndefinite()) {
            return FiniteClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(cycleDuration);
        this.updateTotalTicks();
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int cycleCount) {
        if (cycleCount == 1 || cycleCount == -1) {
            return FiniteClipEnvelope.create(this.animation);
        }
        this.cycleCount = cycleCount;
        this.updateTotalTicks();
        return this;
    }

    @Override
    public void setRate(double rate) {
        boolean toggled = rate * this.rate < 0.0;
        long newTicks = toggled ? this.totalTicks - this.ticks : this.ticks;
        Animation.Status status = this.animation.getStatus();
        if (status != Animation.Status.STOPPED) {
            this.setInternalCurrentRate(Math.abs(this.currentRate - this.rate) < 1.0E-12 ? rate : -rate);
            this.deltaTicks = newTicks - Math.round((double)(this.ticks - this.deltaTicks) * Math.abs(rate / this.rate));
            this.abortCurrentPulse();
        }
        this.ticks = newTicks;
        this.rate = rate;
    }

    private void updateTotalTicks() {
        this.totalTicks = (long)this.cycleCount * this.cycleTicks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePulse(long currentTick) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            long cycleDelta;
            long oldTicks = this.ticks;
            this.ticks = ClipEnvelope.checkBounds(this.deltaTicks + Math.round((double)currentTick * Math.abs(this.rate)), this.totalTicks);
            boolean reachedEnd = this.ticks >= this.totalTicks;
            long overallDelta = this.ticks - oldTicks;
            if (overallDelta == 0L) {
                return;
            }
            long l = cycleDelta = this.currentRate > 0.0 ? this.cycleTicks - this.pos : this.pos;
            while (overallDelta >= cycleDelta) {
                if (cycleDelta > 0L) {
                    this.pos = this.currentRate > 0.0 ? this.cycleTicks : 0L;
                    overallDelta -= cycleDelta;
                    AnimationAccessor.getDefault().playTo(this.animation, this.pos, this.cycleTicks);
                    if (this.aborted) {
                        return;
                    }
                }
                if (!reachedEnd || overallDelta > 0L) {
                    if (this.autoReverse) {
                        this.setCurrentRate(-this.currentRate);
                    } else {
                        this.pos = this.currentRate > 0.0 ? 0L : this.cycleTicks;
                        AnimationAccessor.getDefault().jumpTo(this.animation, this.pos, this.cycleTicks, false);
                    }
                }
                cycleDelta = this.cycleTicks;
            }
            if (overallDelta > 0L && !reachedEnd) {
                this.pos += this.currentRate > 0.0 ? overallDelta : -overallDelta;
                AnimationAccessor.getDefault().playTo(this.animation, this.pos, this.cycleTicks);
            }
            if (reachedEnd && !this.aborted) {
                AnimationAccessor.getDefault().finished(this.animation);
            }
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long newTicks) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long oldTicks = this.ticks;
        if (this.rate < 0.0) {
            newTicks = this.totalTicks - newTicks;
        }
        this.ticks = ClipEnvelope.checkBounds(newTicks, this.totalTicks);
        long delta = this.ticks - oldTicks;
        if (delta != 0L) {
            this.deltaTicks += delta;
            if (this.autoReverse) {
                boolean forward = this.ticks % (2L * this.cycleTicks) < this.cycleTicks;
                if (forward == this.rate > 0.0) {
                    this.pos = this.ticks % this.cycleTicks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(Math.abs(this.rate));
                    }
                } else {
                    this.pos = this.cycleTicks - this.ticks % this.cycleTicks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(-Math.abs(this.rate));
                    }
                }
            } else {
                this.pos = this.ticks % this.cycleTicks;
                if (this.rate < 0.0) {
                    this.pos = this.cycleTicks - this.pos;
                }
                if (this.pos == 0L && this.ticks > 0L) {
                    this.pos = this.cycleTicks;
                }
            }
            AnimationAccessor.getDefault().jumpTo(this.animation, this.pos, this.cycleTicks, false);
            this.abortCurrentPulse();
        }
    }
}

