/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import javafx.css.SizeUnits;
import javafx.scene.text.Font;

public final class Size {
    private final double value;
    private final SizeUnits units;

    public Size(double value, SizeUnits units) {
        this.value = value;
        this.units = units != null ? units : SizeUnits.PX;
    }

    public double getValue() {
        return this.value;
    }

    public SizeUnits getUnits() {
        return this.units;
    }

    public boolean isAbsolute() {
        return this.units.isAbsolute();
    }

    double points(Font font) {
        return this.points(1.0, font);
    }

    double points(double multiplier, Font font) {
        return this.units.points(this.value, multiplier, font);
    }

    public double pixels(double multiplier, Font font) {
        return this.units.pixels(this.value, multiplier, font);
    }

    public double pixels(Font font) {
        return this.pixels(1.0, font);
    }

    double pixels(double multiplier) {
        return this.pixels(multiplier, null);
    }

    public double pixels() {
        return this.pixels(1.0, null);
    }

    public String toString() {
        return Double.toString(this.value) + this.units.toString();
    }

    public int hashCode() {
        long bits = 17L;
        bits = 37L * bits + Double.doubleToLongBits(this.value);
        bits = 37L * bits + (long)this.units.hashCode();
        return (int)(bits ^ bits >> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Size other = (Size)obj;
        if (this.units != other.units) {
            return false;
        }
        if (this.value == other.value) {
            return true;
        }
        if (this.value > 0.0 ? other.value > 0.0 : other.value < 0.0) {
            double v0 = this.value > 0.0 ? this.value : -this.value;
            double v1 = other.value > 0.0 ? other.value : -other.value;
            double diff = this.value - other.value;
            return !(diff < -1.0E-6) && !(1.0E-6 < diff);
        }
        return false;
    }
}

