/*
 * Decompiled with CFR 0.152.
 */
package javafx.css.converter;

import javafx.css.ParsedValue;
import javafx.css.Size;
import javafx.css.SizeUnits;
import javafx.css.StyleConverter;
import javafx.scene.text.Font;

public final class DeriveSizeConverter
extends StyleConverter<ParsedValue<Size, Size>[], Size> {
    public static DeriveSizeConverter getInstance() {
        return Holder.INSTANCE;
    }

    private DeriveSizeConverter() {
    }

    @Override
    public Size convert(ParsedValue<ParsedValue<Size, Size>[], Size> value, Font font) {
        ParsedValue<Size, Size>[] sizes = value.getValue();
        double px1 = sizes[0].convert(font).pixels(font);
        double px2 = sizes[1].convert(font).pixels(font);
        return new Size(px1 + px2, SizeUnits.PX);
    }

    public String toString() {
        return "DeriveSizeConverter";
    }

    private static class Holder {
        static final DeriveSizeConverter INSTANCE = new DeriveSizeConverter();

        private Holder() {
        }
    }
}

