/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.BoxBounds;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.LightBaseHelper;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.transform.TransformHelper;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SubScene;
import javafx.scene.paint.Color;
import javafx.scene.shape.Shape3D;

public abstract class LightBase
extends Node {
    private Affine3D localToSceneTx = new Affine3D();
    private ObjectProperty<Color> color;
    private BooleanProperty lightOn;
    private ObservableList<Node> scope;
    private ObservableList<Node> exclusionScope;

    protected LightBase() {
        this(Color.WHITE);
    }

    protected LightBase(Color color) {
        LightBaseHelper.initHelper(this);
        if (!Platform.isSupported(ConditionalFeature.SCENE3D)) {
            String logname = LightBase.class.getName();
            PlatformLogger.getLogger((String)logname).warning("System can't support ConditionalFeature.SCENE3D");
        }
        this.setColor(color);
        this.localToSceneTransformProperty().addListener(observable -> NodeHelper.markDirty(this, DirtyBits.NODE_LIGHT_TRANSFORM));
    }

    public final void setColor(Color value) {
        this.colorProperty().set((Object)value);
    }

    public final Color getColor() {
        return this.color == null ? null : (Color)this.color.get();
    }

    public final ObjectProperty<Color> colorProperty() {
        if (this.color == null) {
            this.color = new SimpleObjectProperty<Color>((Object)this, "color"){

                protected void invalidated() {
                    NodeHelper.markDirty(LightBase.this, DirtyBits.NODE_LIGHT);
                }
            };
        }
        return this.color;
    }

    public final void setLightOn(boolean value) {
        this.lightOnProperty().set(value);
    }

    public final boolean isLightOn() {
        return this.lightOn == null ? true : this.lightOn.get();
    }

    public final BooleanProperty lightOnProperty() {
        if (this.lightOn == null) {
            this.lightOn = new SimpleBooleanProperty(this, "lightOn", true){

                protected void invalidated() {
                    NodeHelper.markDirty(LightBase.this, DirtyBits.NODE_LIGHT);
                }
            };
        }
        return this.lightOn;
    }

    public ObservableList<Node> getScope() {
        if (this.scope == null) {
            this.scope = new TrackableObservableList<Node>(){

                protected void onChanged(ListChangeListener.Change<Node> c) {
                    LightBase.this.doOnChanged(c, LightBase.this.exclusionScope);
                }
            };
        }
        return this.scope;
    }

    public ObservableList<Node> getExclusionScope() {
        if (this.exclusionScope == null) {
            this.exclusionScope = new TrackableObservableList<Node>(){

                protected void onChanged(ListChangeListener.Change<Node> c) {
                    LightBase.this.doOnChanged(c, LightBase.this.scope);
                }
            };
        }
        return this.exclusionScope;
    }

    private void doOnChanged(ListChangeListener.Change<Node> c, ObservableList<Node> otherScope) {
        NodeHelper.markDirty(this, DirtyBits.NODE_LIGHT_SCOPE);
        while (c.next()) {
            c.getRemoved().forEach(this::markChildrenDirty);
            c.getAddedSubList().forEach(node -> {
                if (otherScope != null && otherScope.remove(node)) {
                    return;
                }
                this.markChildrenDirty((Node)node);
            });
        }
    }

    @Override
    void scenesChanged(Scene newScene, SubScene newSubScene, Scene oldScene, SubScene oldSubScene) {
        if (oldSubScene != null) {
            oldSubScene.removeLight(this);
        } else if (oldScene != null) {
            oldScene.removeLight(this);
        }
        if (newSubScene != null) {
            newSubScene.addLight(this);
        } else if (newScene != null) {
            newScene.addLight(this);
        }
    }

    private void markOwnerDirty() {
        SubScene subScene = this.getSubScene();
        if (subScene != null) {
            subScene.markContentDirty();
        } else {
            Scene scene = this.getScene();
            if (scene != null) {
                scene.setNeedsRepaint();
            }
        }
    }

    private void markChildrenDirty(Node node) {
        if (node instanceof Shape3D) {
            NodeHelper.markDirty((Shape3D)node, DirtyBits.NODE_DRAWMODE);
        } else if (node instanceof Parent) {
            for (Node child : ((Parent)node).getChildren()) {
                if (this.scope != null && this.getScope().contains((Object)child) || this.exclusionScope != null && this.getExclusionScope().contains((Object)child)) continue;
                this.markChildrenDirty(child);
            }
        }
    }

    private void doMarkDirty(DirtyBits dirtyBit) {
        if (this.scope == null || this.getScope().isEmpty()) {
            this.markOwnerDirty();
        } else if (dirtyBit != DirtyBits.NODE_LIGHT_SCOPE) {
            this.getScope().forEach(this::markChildrenDirty);
        }
    }

    private void doUpdatePeer() {
        NGLightBase peer = (NGLightBase)this.getPeer();
        if (this.isDirty(DirtyBits.NODE_LIGHT)) {
            peer.setColor(this.getColor() == null ? Toolkit.getPaintAccessor().getPlatformPaint(Color.WHITE) : Toolkit.getPaintAccessor().getPlatformPaint(this.getColor()));
            peer.setLightOn(this.isLightOn());
        }
        if (this.isDirty(DirtyBits.NODE_LIGHT_SCOPE)) {
            if (this.scope != null) {
                if (this.getScope().isEmpty()) {
                    peer.setScope(List.of());
                } else {
                    peer.setScope(this.getScope().stream().map(n -> n.getPeer()).collect(Collectors.toList()));
                }
            }
            if (this.exclusionScope != null) {
                if (this.getExclusionScope().isEmpty()) {
                    peer.setExclusionScope(List.of());
                } else {
                    peer.setExclusionScope(this.getExclusionScope().stream().map(n -> n.getPeer()).collect(Collectors.toList()));
                }
            }
        }
        if (this.isDirty(DirtyBits.NODE_LIGHT_TRANSFORM)) {
            this.localToSceneTx.setToIdentity();
            TransformHelper.apply(this.getLocalToSceneTransform(), this.localToSceneTx);
            peer.setWorldTransform(this.localToSceneTx);
        }
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        return new BoxBounds();
    }

    private boolean doComputeContains(double localX, double localY) {
        return false;
    }

    static {
        LightBaseHelper.setLightBaseAccessor(new LightBaseHelper.LightBaseAccessor(){

            @Override
            public void doMarkDirty(Node node, DirtyBits dirtyBit) {
                ((LightBase)node).doMarkDirty(dirtyBit);
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((LightBase)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((LightBase)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((LightBase)node).doComputeContains(localX, localY);
            }
        });
    }
}

