/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.scene.CssFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.SubSceneHelper;
import com.sun.javafx.scene.input.PickResultChooser;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.SubSceneTraversalEngine;
import com.sun.javafx.scene.traversal.TopMostTraversalEngine;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGLightBase;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGSubScene;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Point3D;
import javafx.scene.Camera;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.SceneAntialiasing;
import javafx.scene.input.PickResult;
import javafx.scene.paint.Paint;

public class SubScene
extends Node {
    private static boolean is3DSupported;
    private final SceneAntialiasing antiAliasing;
    private final boolean depthBuffer;
    private ObjectProperty<Parent> root;
    private ObjectProperty<Camera> camera;
    private Camera defaultCamera;
    private DoubleProperty width;
    private DoubleProperty height;
    private ObjectProperty<Paint> fill;
    private ObjectProperty<String> userAgentStylesheet;
    boolean dirtyLayout;
    private boolean dirtyNodes;
    private TopMostTraversalEngine traversalEngine;
    private int dirtyBits;
    private List<LightBase> lights;

    public SubScene(@NamedArg(value="root") Parent root, @NamedArg(value="width") double width, @NamedArg(value="height") double height) {
        this(root, width, height, false, SceneAntialiasing.DISABLED);
    }

    public SubScene(@NamedArg(value="root") Parent root, @NamedArg(value="width") double width, @NamedArg(value="height") double height, @NamedArg(value="depthBuffer") boolean depthBuffer, @NamedArg(value="antiAliasing") SceneAntialiasing antiAliasing) {
        String logname;
        SubSceneHelper.initHelper(this);
        this.userAgentStylesheet = null;
        this.dirtyLayout = false;
        this.dirtyNodes = false;
        this.traversalEngine = new SubSceneTraversalEngine(this);
        this.dirtyBits = -1;
        this.lights = new ArrayList<LightBase>();
        this.depthBuffer = depthBuffer;
        this.antiAliasing = antiAliasing;
        boolean isAntiAliasing = antiAliasing != null && antiAliasing != SceneAntialiasing.DISABLED;
        this.setRoot(root);
        this.setWidth(width);
        this.setHeight(height);
        if ((depthBuffer || isAntiAliasing) && !is3DSupported) {
            logname = SubScene.class.getName();
            PlatformLogger.getLogger((String)logname).warning("System can't support ConditionalFeature.SCENE3D");
        }
        if (isAntiAliasing && !Toolkit.getToolkit().isMSAASupported()) {
            logname = SubScene.class.getName();
            PlatformLogger.getLogger((String)logname).warning("System can't support antiAliasing");
        }
    }

    public final SceneAntialiasing getAntiAliasing() {
        return this.antiAliasing;
    }

    public final boolean isDepthBuffer() {
        return this.depthBuffer;
    }

    private boolean isDepthBufferInternal() {
        return is3DSupported ? this.depthBuffer : false;
    }

    public final void setRoot(Parent value) {
        this.rootProperty().set((Object)value);
    }

    public final Parent getRoot() {
        return this.root == null ? null : (Parent)this.root.get();
    }

    public final ObjectProperty<Parent> rootProperty() {
        if (this.root == null) {
            this.root = new ObjectPropertyBase<Parent>(){
                private Parent oldRoot;

                private void forceUnbind() {
                    System.err.println("Unbinding illegal root.");
                    this.unbind();
                }

                protected void invalidated() {
                    Parent _value = (Parent)this.get();
                    if (_value == null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new NullPointerException("Scene's root cannot be null");
                    }
                    if (_value.getParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(_value + "is already inside a scene-graph and cannot be set as root");
                    }
                    if (_value.getClipParent() != null) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(_value + "is set as a clip on another node, so cannot be set as root");
                    }
                    if (_value.getScene() != null && _value.getScene().getRoot() == _value || _value.getSubScene() != null && _value.getSubScene().getRoot() == _value && _value.getSubScene() != SubScene.this) {
                        if (this.isBound()) {
                            this.forceUnbind();
                        }
                        throw new IllegalArgumentException(_value + "is already set as root of another scene or subScene");
                    }
                    _value.setTreeVisible(SubScene.this.isTreeVisible());
                    _value.setDisabled(SubScene.this.isDisabled());
                    _value.setTreeShowing(SubScene.this.isTreeShowing());
                    if (this.oldRoot != null) {
                        StyleManager.getInstance().forget(SubScene.this);
                        this.oldRoot.setScenes(null, null);
                    }
                    this.oldRoot = _value;
                    _value.getStyleClass().add(0, (Object)"root");
                    _value.setScenes(SubScene.this.getScene(), SubScene.this);
                    SubScene.this.markDirty(SubSceneDirtyBits.ROOT_SG_DIRTY);
                    _value.resize(SubScene.this.getWidth(), SubScene.this.getHeight());
                    _value.requestLayout();
                }

                public Object getBean() {
                    return SubScene.this;
                }

                public String getName() {
                    return "root";
                }
            };
        }
        return this.root;
    }

    public final void setCamera(Camera value) {
        this.cameraProperty().set((Object)value);
    }

    public final Camera getCamera() {
        return this.camera == null ? null : (Camera)this.camera.get();
    }

    public final ObjectProperty<Camera> cameraProperty() {
        if (this.camera == null) {
            this.camera = new ObjectPropertyBase<Camera>(){
                Camera oldCamera = null;

                protected void invalidated() {
                    Camera _value = (Camera)this.get();
                    if (_value != null) {
                        if (_value instanceof PerspectiveCamera && !is3DSupported) {
                            String logname = SubScene.class.getName();
                            PlatformLogger.getLogger((String)logname).warning("System can't support ConditionalFeature.SCENE3D");
                        }
                        if (!(_value.getScene() == null && _value.getSubScene() == null || _value.getScene() == SubScene.this.getScene() && _value.getSubScene() == SubScene.this)) {
                            throw new IllegalArgumentException(_value + "is already part of other scene or subscene");
                        }
                        _value.setOwnerSubScene(SubScene.this);
                        _value.setViewWidth(SubScene.this.getWidth());
                        _value.setViewHeight(SubScene.this.getHeight());
                    }
                    SubScene.this.markDirty(SubSceneDirtyBits.CAMERA_DIRTY);
                    if (this.oldCamera != null && this.oldCamera != _value) {
                        this.oldCamera.setOwnerSubScene(null);
                    }
                    this.oldCamera = _value;
                }

                public Object getBean() {
                    return SubScene.this;
                }

                public String getName() {
                    return "camera";
                }
            };
        }
        return this.camera;
    }

    Camera getEffectiveCamera() {
        Camera cam = this.getCamera();
        if (cam == null || cam instanceof PerspectiveCamera && !is3DSupported) {
            if (this.defaultCamera == null) {
                this.defaultCamera = new ParallelCamera();
                this.defaultCamera.setOwnerSubScene(this);
                this.defaultCamera.setViewWidth(this.getWidth());
                this.defaultCamera.setViewHeight(this.getHeight());
            }
            return this.defaultCamera;
        }
        return cam;
    }

    final void markContentDirty() {
        this.markDirty(SubSceneDirtyBits.CONTENT_DIRTY);
    }

    public final void setWidth(double value) {
        this.widthProperty().set(value);
    }

    public final double getWidth() {
        return this.width == null ? 0.0 : this.width.get();
    }

    public final DoubleProperty widthProperty() {
        if (this.width == null) {
            this.width = new DoublePropertyBase(){

                public void invalidated() {
                    Parent _root = SubScene.this.getRoot();
                    if (_root.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
                        NodeHelper.transformsChanged(_root);
                    }
                    if (_root.isResizable()) {
                        _root.resize(this.get() - _root.getLayoutX() - _root.getTranslateX(), _root.getLayoutBounds().getHeight());
                    }
                    SubScene.this.markDirty(SubSceneDirtyBits.SIZE_DIRTY);
                    NodeHelper.geomChanged(SubScene.this);
                    SubScene.this.getEffectiveCamera().setViewWidth(this.get());
                }

                public Object getBean() {
                    return SubScene.this;
                }

                public String getName() {
                    return "width";
                }
            };
        }
        return this.width;
    }

    public final void setHeight(double value) {
        this.heightProperty().set(value);
    }

    public final double getHeight() {
        return this.height == null ? 0.0 : this.height.get();
    }

    public final DoubleProperty heightProperty() {
        if (this.height == null) {
            this.height = new DoublePropertyBase(){

                public void invalidated() {
                    Parent _root = SubScene.this.getRoot();
                    if (_root.isResizable()) {
                        _root.resize(_root.getLayoutBounds().getWidth(), this.get() - _root.getLayoutY() - _root.getTranslateY());
                    }
                    SubScene.this.markDirty(SubSceneDirtyBits.SIZE_DIRTY);
                    NodeHelper.geomChanged(SubScene.this);
                    SubScene.this.getEffectiveCamera().setViewHeight(this.get());
                }

                public Object getBean() {
                    return SubScene.this;
                }

                public String getName() {
                    return "height";
                }
            };
        }
        return this.height;
    }

    public final void setFill(Paint value) {
        this.fillProperty().set((Object)value);
    }

    public final Paint getFill() {
        return this.fill == null ? null : (Paint)this.fill.get();
    }

    public final ObjectProperty<Paint> fillProperty() {
        if (this.fill == null) {
            this.fill = new ObjectPropertyBase<Paint>(null){

                protected void invalidated() {
                    SubScene.this.markDirty(SubSceneDirtyBits.FILL_DIRTY);
                }

                public Object getBean() {
                    return SubScene.this;
                }

                public String getName() {
                    return "fill";
                }
            };
        }
        return this.fill;
    }

    private void doUpdatePeer() {
        this.dirtyNodes = false;
        if (this.isDirty()) {
            NGSubScene peer = (NGSubScene)this.getPeer();
            Camera cam = this.getEffectiveCamera();
            boolean contentChanged = false;
            if (cam.getSubScene() == null && this.isDirty(SubSceneDirtyBits.CONTENT_DIRTY)) {
                cam.syncPeer();
            }
            if (this.isDirty(SubSceneDirtyBits.FILL_DIRTY)) {
                Object platformPaint = this.getFill() == null ? null : Toolkit.getPaintAccessor().getPlatformPaint(this.getFill());
                peer.setFillPaint(platformPaint);
                contentChanged = true;
            }
            if (this.isDirty(SubSceneDirtyBits.SIZE_DIRTY)) {
                peer.setWidth((float)this.getWidth());
                peer.setHeight((float)this.getHeight());
            }
            if (this.isDirty(SubSceneDirtyBits.CAMERA_DIRTY)) {
                peer.setCamera((NGCamera)cam.getPeer());
                contentChanged = true;
            }
            if (this.isDirty(SubSceneDirtyBits.ROOT_SG_DIRTY)) {
                peer.setRoot((NGNode)this.getRoot().getPeer());
                contentChanged = true;
            }
            if ((contentChanged |= this.syncLights()) || this.isDirty(SubSceneDirtyBits.CONTENT_DIRTY)) {
                peer.markContentDirty();
            }
            this.clearDirtyBits();
        }
    }

    @Override
    void nodeResolvedOrientationChanged() {
        this.getRoot().parentResolvedOrientationInvalidated();
    }

    private void doProcessCSS() {
        if (this.cssFlag == CssFlags.CLEAN) {
            return;
        }
        if (this.getRoot().cssFlag == CssFlags.CLEAN) {
            this.getRoot().cssFlag = this.cssFlag;
        }
        SubSceneHelper.superProcessCSS(this);
        this.getRoot().processCSS();
    }

    @Override
    void processCSS() {
        Parent root = this.getRoot();
        if (root.isDirty(DirtyBits.NODE_CSS)) {
            root.clearDirty(DirtyBits.NODE_CSS);
            if (this.cssFlag == CssFlags.CLEAN) {
                this.cssFlag = CssFlags.UPDATE;
            }
        }
        super.processCSS();
    }

    public final ObjectProperty<String> userAgentStylesheetProperty() {
        if (this.userAgentStylesheet == null) {
            this.userAgentStylesheet = new SimpleObjectProperty<String>((Object)this, "userAgentStylesheet", null){

                protected void invalidated() {
                    StyleManager.getInstance().forget(SubScene.this);
                    SubScene.this.reapplyCSS();
                }
            };
        }
        return this.userAgentStylesheet;
    }

    public final String getUserAgentStylesheet() {
        return this.userAgentStylesheet == null ? null : (String)this.userAgentStylesheet.get();
    }

    public final void setUserAgentStylesheet(String url) {
        this.userAgentStylesheetProperty().set((Object)url);
    }

    @Override
    void updateBounds() {
        super.updateBounds();
        this.getRoot().updateBounds();
    }

    private NGNode doCreatePeer() {
        if (!is3DSupported) {
            return new NGSubScene(false, false);
        }
        boolean aa = this.antiAliasing != null && this.antiAliasing != SceneAntialiasing.DISABLED;
        return new NGSubScene(this.depthBuffer, aa && Toolkit.getToolkit().isMSAASupported());
    }

    private BaseBounds doComputeGeomBounds(BaseBounds bounds, BaseTransform tx) {
        int w = (int)Math.ceil(this.width.get());
        int h = (int)Math.ceil(this.height.get());
        bounds = bounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, w, h, 0.0f);
        bounds = tx.transform(bounds, bounds);
        return bounds;
    }

    void setDirtyLayout(Parent p) {
        if (!this.dirtyLayout && p != null && p.getSubScene() == this && this.getScene() != null) {
            this.dirtyLayout = true;
            this.markDirtyLayoutBranch();
            this.markDirty(SubSceneDirtyBits.CONTENT_DIRTY);
        }
    }

    void setDirty(Node n) {
        if (!this.dirtyNodes && n != null && n.getSubScene() == this && this.getScene() != null) {
            this.dirtyNodes = true;
            this.markDirty(SubSceneDirtyBits.CONTENT_DIRTY);
        }
    }

    void layoutPass() {
        if (this.dirtyLayout) {
            Parent r = this.getRoot();
            if (r != null) {
                r.layout();
            }
            this.dirtyLayout = false;
        }
    }

    boolean traverse(Node node, Direction dir) {
        return this.traversalEngine.trav(node, dir) != null;
    }

    private void clearDirtyBits() {
        this.dirtyBits = 0;
    }

    private boolean isDirty() {
        return this.dirtyBits != 0;
    }

    private void setDirty(SubSceneDirtyBits dirtyBit) {
        this.dirtyBits |= dirtyBit.getMask();
    }

    private boolean isDirty(SubSceneDirtyBits dirtyBit) {
        return (this.dirtyBits & dirtyBit.getMask()) != 0;
    }

    private void markDirty(SubSceneDirtyBits dirtyBit) {
        if (!this.isDirty()) {
            NodeHelper.markDirty(this, DirtyBits.NODE_CONTENTS);
        }
        this.setDirty(dirtyBit);
    }

    private boolean doComputeContains(double localX, double localY) {
        if (this.subSceneComputeContains(localX, localY)) {
            return true;
        }
        return NodeHelper.computeContains(this.getRoot(), localX, localY);
    }

    private boolean subSceneComputeContains(double localX, double localY) {
        if (localX < 0.0 || localY < 0.0 || localX > this.getWidth() || localY > this.getHeight()) {
            return false;
        }
        return this.getFill() != null;
    }

    private PickResult pickRootSG(double localX, double localY) {
        double viewWidth = this.getWidth();
        double viewHeight = this.getHeight();
        if (localX < 0.0 || localY < 0.0 || localX > viewWidth || localY > viewHeight) {
            return null;
        }
        PickResultChooser result = new PickResultChooser();
        PickRay pickRay = this.getEffectiveCamera().computePickRay(localX, localY, new PickRay());
        pickRay.getDirectionNoClone().normalize();
        this.getRoot().pickNode(pickRay, result);
        return result.toPickResult();
    }

    private void doPickNodeLocal(PickRay localPickRay, PickResultChooser result) {
        double boundsDistance = this.intersectsBounds(localPickRay);
        if (!Double.isNaN(boundsDistance) && result.isCloser(boundsDistance)) {
            Point3D intersectPt = PickResultChooser.computePoint(localPickRay, boundsDistance);
            PickResult subSceneResult = this.pickRootSG(intersectPt.getX(), intersectPt.getY());
            if (subSceneResult != null) {
                result.offerSubScenePickResult(this, subSceneResult, boundsDistance);
            } else if (this.isPickOnBounds() || this.subSceneComputeContains(intersectPt.getX(), intersectPt.getY())) {
                result.offer(this, boundsDistance, intersectPt);
            }
        }
    }

    final void addLight(LightBase light) {
        if (!this.lights.contains(light)) {
            this.markDirty(SubSceneDirtyBits.LIGHTS_DIRTY);
            this.lights.add(light);
        }
    }

    final void removeLight(LightBase light) {
        if (this.lights.remove(light)) {
            this.markDirty(SubSceneDirtyBits.LIGHTS_DIRTY);
        }
    }

    private boolean syncLights() {
        boolean lightOwnerChanged = false;
        if (!this.isDirty(SubSceneDirtyBits.LIGHTS_DIRTY)) {
            return lightOwnerChanged;
        }
        NGSubScene pgSubScene = (NGSubScene)this.getPeer();
        NGLightBase[] peerLights = pgSubScene.getLights();
        if (!this.lights.isEmpty() || peerLights != null) {
            if (this.lights.isEmpty()) {
                pgSubScene.setLights(null);
            } else {
                int i;
                if (peerLights == null || peerLights.length < this.lights.size()) {
                    peerLights = new NGLightBase[this.lights.size()];
                }
                for (i = 0; i < this.lights.size(); ++i) {
                    peerLights[i] = (NGLightBase)this.lights.get(i).getPeer();
                }
                while (i < peerLights.length && peerLights[i] != null) {
                    peerLights[i++] = null;
                }
                pgSubScene.setLights(peerLights);
            }
            lightOwnerChanged = true;
        }
        return lightOwnerChanged;
    }

    static {
        SubSceneHelper.setSubSceneAccessor(new SubSceneHelper.SubSceneAccessor(){

            @Override
            public NGNode doCreatePeer(Node node) {
                return ((SubScene)node).doCreatePeer();
            }

            @Override
            public void doUpdatePeer(Node node) {
                ((SubScene)node).doUpdatePeer();
            }

            @Override
            public BaseBounds doComputeGeomBounds(Node node, BaseBounds bounds, BaseTransform tx) {
                return ((SubScene)node).doComputeGeomBounds(bounds, tx);
            }

            @Override
            public boolean doComputeContains(Node node, double localX, double localY) {
                return ((SubScene)node).doComputeContains(localX, localY);
            }

            @Override
            public void doProcessCSS(Node node) {
                ((SubScene)node).doProcessCSS();
            }

            @Override
            public void doPickNodeLocal(Node node, PickRay localPickRay, PickResultChooser result) {
                ((SubScene)node).doPickNodeLocal(localPickRay, result);
            }

            @Override
            public boolean isDepthBuffer(SubScene subScene) {
                return subScene.isDepthBufferInternal();
            }

            @Override
            public Camera getEffectiveCamera(SubScene subScene) {
                return subScene.getEffectiveCamera();
            }
        });
        is3DSupported = Platform.isSupported(ConditionalFeature.SCENE3D);
    }

    private static enum SubSceneDirtyBits {
        SIZE_DIRTY,
        FILL_DIRTY,
        ROOT_SG_DIRTY,
        CAMERA_DIRTY,
        LIGHTS_DIRTY,
        CONTENT_DIRTY;

        private int mask = 1 << this.ordinal();

        public final int getMask() {
            return this.mask;
        }
    }
}

